/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorSelector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MirrorSelectorTest {
    private List<MirrorSelector.MirrorInfo> originals;

    @Before
    public void setUp() throws Exception {
        this.originals = new ArrayList<MirrorSelector.MirrorInfo>();
        MirrorSelector.MirrorInfo mi = null;
        mi = new MirrorSelector.MirrorInfo("https://ftp.wh2.tu-dresden.de/pub/mirrors/eclipse/", 3);
        mi.setBytesPerSecond(224906L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp-stud.fht-esslingen.de/pub/Mirrors/eclipse/", 1);
        mi.setBytesPerSecond(125868L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://mirror.netcologne.de/eclipse//", 0);
        mi.setBytesPerSecond(199719L);
        mi.incrementFailureCount();
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://mirror.selfnet.de/eclipse/", 5);
        mi.setBytesPerSecond(132379L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://mirror.switch.ch/eclipse/", 7);
        mi.setBytesPerSecond(137107L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://www.rcp-vision.com/eclipse/eclipseMirror/", 8);
        mi.setBytesPerSecond(128472L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://eclipse.mirror.garr.it/mirrors/eclipse//", 10);
        mi.setBytesPerSecond(129359L);
        mi.incrementFailureCount();
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.roedu.net/pub/mirrors/eclipse.org/", 6);
        mi.setBytesPerSecond(59587L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://giano.com.dist.unige.it/eclipse/", 9);
        mi.setBytesPerSecond(85624L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.roedu.net/mirrors/eclipse.org//", 19);
        mi.setBytesPerSecond(149572L);
        mi.incrementFailureCount();
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.ing.umu.se/mirror/eclipse/", 18);
        mi.setBytesPerSecond(105858L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://mirrors.fe.up.pt/pub/eclipse//", 15);
        mi.setBytesPerSecond(67202L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.heanet.ie/pub/eclipse//", 17);
        mi.setBytesPerSecond(68067L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.sh.cvut.cz/MIRRORS/eclipse/", 21);
        mi.setBytesPerSecond(73659L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.man.poznan.pl/eclipse/", 22);
        mi.setBytesPerSecond(73446L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://eclipse.dcc.fc.up.pt/", 16);
        mi.setBytesPerSecond(45175L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://eclipse.nordnet.fi/eclipse/", 23);
        mi.setBytesPerSecond(61443L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://www.gtlib.gatech.edu/pub/eclipse/", 26);
        mi.setBytesPerSecond(57637L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.osuosl.org/pub/eclipse//", 28);
        mi.setBytesPerSecond(35928L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://mirrors.med.harvard.edu/eclipse//", 32);
        mi.setBytesPerSecond(40683L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://mirrors.ibiblio.org/pub/mirrors/eclipse/", 31);
        mi.setBytesPerSecond(34207L);
        mi.incrementFailureCount();
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.ussg.iu.edu/eclipse/", 33);
        mi.setBytesPerSecond(31402L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://mirrors.xmission.com/eclipse/", 29);
        mi.setBytesPerSecond(24147L);
        mi.incrementFailureCount();
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.osuosl.org/pub/eclipse/", 34);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://www.ftp.saix.net/Eclipse//", 40);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.daum.net/eclipse/", 41);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://eclipse.stu.edu.tw/", 43);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://eclipse.stu.edu.tw/", 44);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.kaist.ac.kr/eclipse/", 45);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://eclipse.stu.edu.tw//", 46);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.tsukuba.wide.ad.jp/software/eclipse//", 47);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://mirror.neu.edu.cn/eclipse/", 50);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://mirror.bit.edu.cn/eclipse/", 51);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.cs.pu.edu.tw/pub/eclipse/", 52);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://ftp.neu.edu.cn/mirrors/eclipse/", 53);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://download.actuatechina.com/eclipse/", 54);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://linorg.usp.br/eclipse/", 57);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://eclipse.c3sl.ufpr.br/", 59);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
        mi = new MirrorSelector.MirrorInfo("https://download.eclipse.org/", 61);
        mi.setBytesPerSecond(-1L);
        this.originals.add(mi);
    }

    @Test
    public void testSorting() {
        long maxBytesPerSecond = 0L;
        for (MirrorSelector.MirrorInfo x : this.originals) {
            maxBytesPerSecond = Math.max(maxBytesPerSecond, x.getBytesPerSecond());
        }
        MirrorSelector.MirrorInfoComparator comparator = new MirrorSelector.MirrorInfoComparator(maxBytesPerSecond, 0, 0);
        int x = 0;
        while (x < 1000) {
            ArrayList<MirrorSelector.MirrorInfo> templist = new ArrayList<MirrorSelector.MirrorInfo>(this.originals);
            Collections.shuffle(templist);
            MirrorSelector.MirrorInfo[] mirrors = templist.toArray(new MirrorSelector.MirrorInfo[this.originals.size()]);
            Arrays.sort(mirrors, comparator);
            this.assertList(this.originals, mirrors);
            ++x;
        }
    }

    @Test
    public void testComparatorZeros() {
        MirrorSelector.MirrorInfoComparator comparator = new MirrorSelector.MirrorInfoComparator(0L, 0, 0);
        Assert.assertEquals((String)"equals", (long)comparator.compare(this.originals.get(0), this.originals.get(0)), (long)0L);
        Assert.assertEquals((String)"equals", (long)comparator.compare(this.originals.get(1), this.originals.get(1)), (long)0L);
    }

    private void assertList(List<MirrorSelector.MirrorInfo> originallist, MirrorSelector.MirrorInfo[] mirrors) {
        Assert.assertEquals((String)"length", (long)originallist.size(), (long)mirrors.length);
        int i = 0;
        while (i < originallist.size()) {
            Assert.assertEquals((String)("equal mirror_" + i), (Object)originallist.get(i), (Object)mirrors[i]);
            ++i;
        }
    }
}

