/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.repository.DefaultPGPPublicKeyService;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PGPVerifierTest
extends AbstractProvisioningTest {
    IArtifactRepository targetRepo = null;
    IArtifactRepository sourceRepo = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    private void loadPGPTestRepo(String repoName) throws Exception {
        this.sourceRepo = PGPVerifierTest.getArtifactRepositoryManager().loadRepository(PGPVerifierTest.getTestData("Test repository for PGP", "testData/pgp/" + repoName).toURI(), (IProgressMonitor)new NullProgressMonitor());
        this.targetRepo = this.createArtifactRepository(Files.createTempDirectory(PGPVerifierTest.class.getSimpleName(), new FileAttribute[0]).toUri(), NO_PROPERTIES);
    }

    @Test
    public void testAllGood() throws Exception {
        MirrorRequest mirrorRequest = this.performMirrorFrom("repoPGPOK");
        IStatus mirrorStatus = mirrorRequest.getResult();
        PGPVerifierTest.assertOK(mirrorStatus);
        IArtifactDescriptor[] artifactDescriptors = this.targetRepo.getArtifactDescriptors(mirrorRequest.getArtifactKey());
        Assert.assertEquals((long)1L, (long)artifactDescriptors.length);
        IArtifactDescriptor descriptor = artifactDescriptors[0];
        Assert.assertNotNull((String)"Signatures should be present", (Object)descriptor.getProperty("pgp.signatures"));
        Assert.assertNotNull((String)"Keys should be present", (Object)descriptor.getProperty("pgp.publicKeys"));
    }

    @Test
    public void testAllGoodWithEncodedProperties() throws Exception {
        MirrorRequest mirrorRequest = this.performMirrorFrom("repoPGPOK_encoded");
        IStatus mirrorStatus = mirrorRequest.getResult();
        PGPVerifierTest.assertOK(mirrorStatus);
        IArtifactDescriptor[] artifactDescriptors = this.targetRepo.getArtifactDescriptors(mirrorRequest.getArtifactKey());
        Assert.assertEquals((long)1L, (long)artifactDescriptors.length);
        IArtifactDescriptor descriptor = artifactDescriptors[0];
        Assert.assertNotNull((String)"Signatures should be present", (Object)descriptor.getProperty("pgp.signatures"));
        Assert.assertNotNull((String)"Keys should be present", (Object)descriptor.getProperty("pgp.publicKeys"));
    }

    private MirrorRequest performMirrorFrom(String repoName) throws Exception {
        IAgentLocation agentLocation = (IAgentLocation)PGPVerifierTest.getAgent().getService(IAgentLocation.class);
        Path repositoryCache = Paths.get(agentLocation.getDataArea("org.eclipse.equinox.p2.repository"));
        if (Files.isDirectory(repositoryCache, new LinkOption[0])) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Stream<Path> walk = Files.walk(repositoryCache, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        DefaultPGPPublicKeyService keyService = new DefaultPGPPublicKeyService(PGPVerifierTest.getAgent());
        keyService.setGPG(false);
        keyService.setKeyServers(Set.of());
        PGPVerifierTest.getAgent().registerService(PGPPublicKeyService.SERVICE_NAME, (Object)keyService);
        this.loadPGPTestRepo(repoName);
        ArtifactKey key = new ArtifactKey("osgi.bundle", "blah", Version.create((String)"1.0.0.123456"));
        MirrorRequest mirrorRequest = new MirrorRequest((IArtifactKey)key, this.targetRepo, NO_PROPERTIES, NO_PROPERTIES, this.getTransport());
        mirrorRequest.perform(this.sourceRepo, this.getMonitor());
        return mirrorRequest;
    }

    @Test
    public void testMissingPublicKey() throws Exception {
        MirrorRequest mirrorRequest = this.performMirrorFrom("repoMissingPublicKey");
        IStatus mirrorStatus = mirrorRequest.getResult();
        PGPVerifierTest.assertOK(mirrorStatus);
        IArtifactDescriptor[] artifactDescriptors = this.targetRepo.getArtifactDescriptors(mirrorRequest.getArtifactKey());
        Assert.assertEquals((long)1L, (long)artifactDescriptors.length);
        IArtifactDescriptor descriptor = artifactDescriptors[0];
        Assert.assertNull((String)"Signatures should not be present", (Object)descriptor.getProperty("pgp.signatures"));
        Assert.assertNull((String)"Keys should not be present", (Object)descriptor.getProperty("pgp.publicKeys"));
    }

    @Override
    protected void tearDown() throws Exception {
        PGPVerifierTest.getArtifactRepositoryManager().removeRepository(this.sourceRepo.getLocation());
        PGPVerifierTest.getArtifactRepositoryManager().removeRepository(this.targetRepo.getLocation());
        super.tearDown();
    }
}

