/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.osgi.framework.BundleException;

public class TransferExceptionsTest
extends AbstractProvisioningTest {
    public void testErrorMessages() throws IOException, BundleException, URISyntaxException {
        File f = File.createTempFile("TransferTest", "dummy.txt");
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream fos = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            Platform.getBundle((String)"org.eclipse.ecf.provider.filetransfer").start();
            IStatus s = this.getTransport().download(new URI("bogus!bogus"), fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("1", s);
            s = this.getTransport().download(new URI("bogus://somewhere.else"), fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("2", s);
            s = this.getTransport().download(new URI("http:bogusURL"), fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("3", s);
            s = this.getTransport().download(new URI("http://bogusURL:80/"), fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("4", s);
            s = this.getTransport().download(new URI("http:/bogusURL:999999999999/"), fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("5", s);
            s = this.getTransport().download(new URI("http://bogus.nowhere"), fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("6", s);
            s = this.getTransport().download(new URI("http://www.eclipse.org/AFileThatDoesNotExist.foo"), fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("7", s);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void printStatus(String msg, IStatus s) {
        System.err.print("TEST OUTPUT: " + msg + "\n");
        System.err.print("     ");
        System.err.print("Message [" + s.getMessage() + "] Exception Class[" + s.getException().getClass().getName() + "] ExceptionMessage[ ");
        System.err.print(s.getException().getMessage() + "]\n");
    }
}

