/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.osgi.framework.Bundle;

public class TransferTest
extends AbstractProvisioningTest {
    public void testGZFileAreNotUnzipped() throws Exception {
        File f = File.createTempFile("TransferTest", "pack.gz");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (OutputStream fos = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
                Platform.getBundle((String)"org.eclipse.ecf.provider.filetransfer").start();
                URI toDownload = new URI("https://download.eclipse.org/eclipse/updates/4.11/R-4.11-201903070500/plugins/javax.servlet.jsp_2.2.0.v201112011158.jar.pack.gz");
                IStatus s = this.getTransport().download(toDownload, fos, (IProgressMonitor)new NullProgressMonitor());
                TransferTest.assertOK("2.0", s);
                int httpSize = -1;
                try {
                    URL u = toDownload.toURL();
                    HttpURLConnection c = (HttpURLConnection)u.openConnection();
                    httpSize = c.getContentLength();
                }
                catch (IOException e1) {
                    httpSize = -1;
                }
                if (f != null) {
                    String[] ecfPlugins = new String[]{"org.eclipse.ecf", "org.eclipse.ecf.identity", "org.eclipse.ecf.filetransfer", "org.eclipse.ecf.provider.filetransfer", "org.eclipse.ecf.provider.filetransfer.httpclientjava"};
                    StringBuilder buffer = new StringBuilder();
                    String[] stringArray = ecfPlugins;
                    int n = ecfPlugins.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ecfPlugin = stringArray[n2];
                        Bundle bundle = Platform.getBundle((String)ecfPlugin);
                        buffer.append(bundle.getSymbolicName()).append('-').append(bundle.getVersion()).append('\n');
                        ++n2;
                    }
                    TransferTest.assertTrue((String)("4.0 - length found: " + f.length() + " using ECF bundles: " + buffer.toString()), (f.length() < 60000L ? 1 : 0) != 0);
                    TransferTest.assertTrue((String)"5.0", (boolean)(httpSize == -1 ? true : (long)httpSize == f.length()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }
}

