/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository.processing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.md5.MD5Verifier;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.artifact.repository.processing.Adder;
import org.eclipse.equinox.p2.tests.artifact.repository.processing.ByteShifter;
import org.eclipse.equinox.p2.tests.artifact.repository.processing.Multiplier;
import org.junit.Assert;
import org.junit.Test;

public class ProcessingStepHandlerTest {
    ProcessingStepHandler handler = new ProcessingStepHandler();
    IProgressMonitor monitor = new NullProgressMonitor();

    @Test
    public void testCanProcess_Ok() {
        ArtifactDescriptor descriptor = new ArtifactDescriptor(ArtifactKey.parse((String)"classifier,id,1.0.0"));
        descriptor.setProcessingSteps((IProcessingStepDescriptor[])new ProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.ByteShifter", null, true)});
        Assert.assertTrue((boolean)ProcessingStepHandler.canProcess((IArtifactDescriptor)descriptor));
    }

    @Test
    public void testCanProcess_FailNoSuchStep() {
        String noSuchStepId = "org.eclipse.equinox.p2.processing.test.Dummy";
        ArtifactDescriptor descriptor = new ArtifactDescriptor(ArtifactKey.parse((String)"classifier,id,1.0.0"));
        descriptor.setProcessingSteps((IProcessingStepDescriptor[])new ProcessingStepDescriptor[]{new ProcessingStepDescriptor(noSuchStepId, null, true), new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.ByteShifter", "1", true)});
        Assert.assertFalse((boolean)ProcessingStepHandler.canProcess((IArtifactDescriptor)descriptor));
    }

    @Test
    public void testCanProcess_FailAlwaysDisabled() {
        ArtifactDescriptor descriptor = new ArtifactDescriptor(ArtifactKey.parse((String)"classifier,id,1.0.0"));
        String processorId = "org.eclipse.equinox.p2.processing.AlwaysDisabled";
        descriptor.setProcessingSteps((IProcessingStepDescriptor[])new ProcessingStepDescriptor[]{new ProcessingStepDescriptor(processorId, null, true), new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.ByteShifter", "1", true)});
        Assert.assertFalse((boolean)ProcessingStepHandler.canProcess((IArtifactDescriptor)descriptor));
    }

    @Test
    public void testCanProcess_OkOptionalAlwaysDisabled() {
        ArtifactDescriptor descriptor = new ArtifactDescriptor(ArtifactKey.parse((String)"classifier,id,1.0.0"));
        String processorId = "org.eclipse.equinox.p2.processing.AlwaysDisabled";
        descriptor.setProcessingSteps((IProcessingStepDescriptor[])new ProcessingStepDescriptor[]{new ProcessingStepDescriptor(processorId, null, false), new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.ByteShifter", "1", true)});
        Assert.assertTrue((String)"Not enabled optional step should not block processing", (boolean)ProcessingStepHandler.canProcess((IArtifactDescriptor)descriptor));
    }

    @Test
    public void testCanProcess_FailMultipleSteps() {
        ArtifactDescriptor descriptor = new ArtifactDescriptor(ArtifactKey.parse((String)"classifier,id,1.0.0"));
        String processorId = "org.eclipse.equinox.p2.processing.MultipleSteps";
        descriptor.setProcessingSteps((IProcessingStepDescriptor[])new ProcessingStepDescriptor[]{new ProcessingStepDescriptor(processorId, null, true), new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.ByteShifter", "1", true)});
        Assert.assertFalse((String)String.format("Multiple step attributes in %s are not supported", processorId), (boolean)ProcessingStepHandler.canProcess((IArtifactDescriptor)descriptor));
    }

    @Test
    public void testExecuteNoPSs() throws IOException {
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.createAndLink(AbstractProvisioningTest.getAgent(), descriptors, null, (OutputStream)result, this.monitor);){
            testStream.write("Test".getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((Object)"Test", (Object)((Object)result).toString());
    }

    @Test
    public void testExecuteOneByteShifterPS() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new ByteShifter(1)};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])result.toByteArray());
    }

    @Test
    public void testExecuteTwoByteShifterPSs() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new ByteShifter(1), new ByteShifter(2)};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertArrayEquals((byte[])new byte[]{8}, (byte[])result.toByteArray());
    }

    @Test
    public void testExecuteOneMD5VerifierPSOk() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new MD5Verifier("0cbc6611f5540bd0809a388dc95a615b")};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write("Test".getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((Object)"Test", (Object)result.toString());
    }

    @Test
    public void testExecuteOneMD5VerifierPSFails() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new MD5Verifier("9cbc6611f5540bd0809a388dc95a615b")};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            try {
                testStream.write("Test".getBytes());
            }
            finally {
                if (testStream != null) {
                    testStream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((Object)"Test", (Object)result.toString());
        Assert.assertEquals((long)4L, (long)ProcessingStepHandler.checkStatus((OutputStream)testStream).getSeverity());
    }

    @Test
    public void testExecuteOneByteShifterAndOneMD5VerifierPSOk() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new ByteShifter(1), new MD5Verifier("ceeee507e8db83294600218b4e198897")};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertArrayEquals((byte[])new byte[]{2, 4, 6, 8, 10}, (byte[])result.toByteArray());
    }

    @Test
    public void testExecuteOneByteShifterAndOneMD5VerifierPSFailWrongOrder() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new MD5Verifier("af476bbaf152a4c39ca4e5c498a88aa0"), new ByteShifter(1)};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            try {
                testStream.write(new byte[]{1, 2, 3, 4, 5});
            }
            finally {
                if (testStream != null) {
                    testStream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertArrayEquals((byte[])new byte[]{2, 4, 6, 8, 10}, (byte[])result.toByteArray());
        Assert.assertEquals((long)4L, (long)ProcessingStepHandler.checkStatus((OutputStream)testStream).getSeverity());
    }

    @Test
    public void testAssureOrderingOfPSs1() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new Adder(1), new Multiplier(2)};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertArrayEquals((byte[])new byte[]{4, 6, 8, 10, 12}, (byte[])result.toByteArray());
    }

    @Test
    public void testAssureOrderingOfPSs2() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new Multiplier(2), new Adder(1)};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertArrayEquals((byte[])new byte[]{3, 5, 7, 9, 11}, (byte[])result.toByteArray());
    }

    @Test
    public void testCreateByteShifterPS() {
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.ByteShifter", "1", true)};
        ProcessingStep[] steps = this.handler.create(AbstractProvisioningTest.getAgent(), descriptors, null);
        Assert.assertNotNull((Object)steps);
        Assert.assertEquals((long)1L, (long)steps.length);
        Assert.assertEquals(ByteShifter.class, steps[0].getClass());
    }

    @Test
    public void testCreateMD5VerifierPS() {
        String processorId = "org.eclipse.equinox.p2.processing.MD5Verifier";
        ProcessingStepDescriptor[] descriptors = new ProcessingStepDescriptor[]{new ProcessingStepDescriptor(processorId, "1", true)};
        ProcessingStep[] steps = this.handler.create(AbstractProvisioningTest.getAgent(), (IProcessingStepDescriptor[])descriptors, null);
        Assert.assertNotNull((Object)steps);
        Assert.assertEquals((long)1L, (long)steps.length);
        Assert.assertNotEquals((String)String.format("Step '%s' is not available anymore", processorId), MD5Verifier.class, steps[0].getClass());
        Assert.assertEquals((long)4L, (long)steps[0].getStatus().getSeverity());
    }

    @Test
    public void testCreateChecksumVerifierPS() {
        ProcessingStepDescriptor processingStepDescriptor = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.ChecksumVerifier", "1", true);
        ProcessingStepDescriptor[] descriptors = new ProcessingStepDescriptor[]{processingStepDescriptor};
        ProcessingStep[] steps = this.handler.create(AbstractProvisioningTest.getAgent(), (IProcessingStepDescriptor[])descriptors, null);
        Assert.assertNotNull((Object)steps);
        Assert.assertEquals((long)1L, (long)steps.length);
        Assert.assertEquals((long)4L, (long)steps[0].getStatus().getSeverity());
    }

    @Test
    public void testCreateAdderPS() {
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Adder", "1", true)};
        ProcessingStep[] steps = this.handler.create(AbstractProvisioningTest.getAgent(), descriptors, null);
        Assert.assertNotNull((Object)steps);
        Assert.assertEquals((long)1L, (long)steps.length);
        Assert.assertEquals(Adder.class, steps[0].getClass());
    }

    @Test
    public void testCreateMultiplierPS() {
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Multiplier", "2", true)};
        ProcessingStep[] steps = this.handler.create(AbstractProvisioningTest.getAgent(), descriptors, null);
        Assert.assertNotNull((Object)steps);
        Assert.assertEquals((long)1L, (long)steps.length);
        Assert.assertEquals(Multiplier.class, steps[0].getClass());
    }

    @Test
    public void testCreatePSsAndAssureOrderingOfPSs1() throws IOException {
        ProcessingStepDescriptor adder = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Adder", "1", true);
        ProcessingStepDescriptor multiplier = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Multiplier", "2", true);
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{adder, multiplier};
        ProcessingStep[] steps = this.handler.create(AbstractProvisioningTest.getAgent(), descriptors, null);
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var7_8 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertArrayEquals((byte[])new byte[]{4, 6, 8, 10, 12}, (byte[])result.toByteArray());
    }

    @Test
    public void testCreatePSsAndAssureOrderingOfPSs2() throws IOException {
        ProcessingStepDescriptor adder = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Adder", "1", true);
        ProcessingStepDescriptor multiplier = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Multiplier", "2", true);
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{multiplier, adder};
        ProcessingStep[] steps = this.handler.create(AbstractProvisioningTest.getAgent(), descriptors, null);
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var7_8 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertArrayEquals((byte[])new byte[]{3, 5, 7, 9, 11}, (byte[])result.toByteArray());
    }

    @Test
    public void testLinkPSs() throws IOException {
        ProcessingStepDescriptor adder = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Adder", "1", true);
        ProcessingStepDescriptor multiplier = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Multiplier", "2", true);
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{adder, multiplier};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStream testStream = this.handler.createAndLink(AbstractProvisioningTest.getAgent(), descriptors, null, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertArrayEquals((byte[])new byte[]{4, 6, 8, 10, 12}, (byte[])result.toByteArray());
    }

    @Test
    public void testPSHgetStatusOK() {
        ProcessingStep ok1 = new ProcessingStep(){

            public IStatus getStatus() {
                return Status.OK_STATUS;
            }
        };
        ProcessingStep ok2 = new ProcessingStep(){

            public IStatus getStatus() {
                return Status.OK_STATUS;
            }
        };
        OutputStream testStream = this.handler.link(new ProcessingStep[]{ok1, ok2}, null, this.monitor);
        IStatus status = ProcessingStepHandler.getStatus((OutputStream)testStream);
        IStatus errStatus = ProcessingStepHandler.getStatus((OutputStream)testStream);
        Assert.assertTrue((status.isOK() && errStatus.isOK() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)status.isMultiStatus());
        Assert.assertFalse((boolean)errStatus.isMultiStatus());
    }

    @Test
    public void testPSHgetStatus() {
        ProcessingStep ok = new ProcessingStep(){

            public IStatus getStatus() {
                return Status.OK_STATUS;
            }
        };
        ProcessingStep info = new ProcessingStep(){

            public IStatus getStatus() {
                return new Status(1, "ID", "INFO");
            }
        };
        ProcessingStep warning = new ProcessingStep(){

            public IStatus getStatus() {
                return new Status(2, "ID", "WARNING");
            }
        };
        ProcessingStep error = new ProcessingStep(){

            public IStatus getStatus() {
                return new Status(4, "ID", "ERROR");
            }
        };
        OutputStream testStream = this.handler.link(new ProcessingStep[]{info, ok, error, warning}, null, this.monitor);
        Assert.assertEquals((long)2L, (long)ProcessingStepHandler.getErrorStatus((OutputStream)testStream).getChildren().length);
        Assert.assertEquals((long)4L, (long)ProcessingStepHandler.getStatus((OutputStream)testStream, (boolean)true).getChildren().length);
    }
}

