/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository.processing;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessingStepTest {
    private ProcessingStep ps;
    boolean flushed;
    boolean closed;

    @Before
    public void setUp() throws Exception {
        this.ps = new ProcessingStep(){};
        this.flushed = false;
        this.closed = false;
    }

    @Test
    public void testDefaultStatus() {
        Assert.assertNotNull((Object)this.ps.getStatus());
        Assert.assertTrue((boolean)this.ps.getStatus().isOK());
        Assert.assertTrue((boolean)this.ps.getStatus(false).isOK());
        Assert.assertTrue((boolean)this.ps.getStatus(true).isOK());
        Assert.assertTrue((boolean)ProcessingStepHandler.checkStatus((OutputStream)this.ps).isOK());
    }

    @Test
    public void testGetDeepStatus() {
        ProcessingStep ps2 = new ProcessingStep(){};
        this.ps.link((OutputStream)ps2, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)this.ps.getStatus(true).isOK());
        ps2.setStatus((IStatus)new Status(4, "plugin id", "message"));
        Assert.assertFalse((boolean)this.ps.getStatus(true).isOK());
        Assert.assertTrue((boolean)this.ps.getStatus(true).isMultiStatus());
        Assert.assertEquals((long)4L, (long)this.ps.getStatus(true).getSeverity());
        MultiStatus multi = (MultiStatus)this.ps.getStatus(true);
        Assert.assertEquals((long)2L, (long)multi.getChildren().length);
        ProcessingStep ps3 = new ProcessingStep(){};
        ps2.link((OutputStream)ps3, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)this.ps.getStatus(true).isOK());
        Assert.assertTrue((boolean)this.ps.getStatus(true).isMultiStatus());
        Assert.assertEquals((long)4L, (long)this.ps.getStatus(true).getSeverity());
        multi = (MultiStatus)this.ps.getStatus(true);
        Assert.assertEquals((long)3L, (long)multi.getChildren().length);
        ps3.setStatus(Status.CANCEL_STATUS);
        Assert.assertFalse((boolean)this.ps.getStatus(true).isOK());
        Assert.assertTrue((boolean)this.ps.getStatus(true).isMultiStatus());
        Assert.assertEquals((long)8L, (long)this.ps.getStatus(true).getSeverity());
    }

    @Test
    public void testFlush() throws IOException {
        OutputStream destination = new OutputStream(){

            @Override
            public void write(int b) {
            }

            @Override
            public void flush() {
                ProcessingStepTest.this.flushed = true;
            }
        };
        this.ps.link(destination, (IProgressMonitor)new NullProgressMonitor());
        this.ps.flush();
        Assert.assertTrue((boolean)this.flushed);
    }

    @Test
    public void testCloseSimpleOutputStreamAsDestination() throws IOException {
        OutputStream destination = new OutputStream(){

            @Override
            public void write(int b) {
            }

            @Override
            public void close() {
                ProcessingStepTest.this.closed = true;
            }
        };
        this.ps.link(destination, (IProgressMonitor)new NullProgressMonitor());
        this.ps.close();
        Assert.assertFalse((boolean)this.closed);
    }

    @Test
    public void testCloseProcessingStepAsDestination() throws IOException {
        ProcessingStep destination = new ProcessingStep(){

            public void close() {
                ProcessingStepTest.this.closed = true;
            }
        };
        this.ps.link((OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        this.ps.close();
        Assert.assertTrue((boolean)this.closed);
    }
}

