/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.eclipse.equinox.internal.p2.touchpoint.natives.SimpleBackupStore;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class BackupTest
extends AbstractProvisioningTest {
    private static final String BUPREFIX = "backup-test";
    private Path sourceDir;
    private Path aDir;
    private Path aaDir;
    private Path aTxt;
    private Path bDir;
    private Path bTxt;
    private Path abDir;
    private Path cTxt;
    private SimpleBackupStore store;

    @Override
    public void setUp() throws IOException {
        String userHome = System.getProperty("user.home");
        this.sourceDir = Path.of(userHome, "p2-backup-test");
        BackupTest.deleteAll(this.sourceDir);
        this.aDir = this.sourceDir.resolve("a");
        Files.createDirectories(this.aDir, new FileAttribute[0]);
        this.aaDir = this.aDir.resolve("aa");
        Files.createDirectories(this.aaDir, new FileAttribute[0]);
        this.aTxt = this.aaDir.resolve("a.txt");
        Files.write(this.aTxt, "A\nA file with an A".getBytes(), new OpenOption[0]);
        this.bTxt = this.aaDir.resolve("b.txt");
        Files.write(this.bTxt, "B\nA file with a B".getBytes(), new OpenOption[0]);
        this.abDir = this.aDir.resolve("ab");
        Files.createDirectories(this.abDir, new FileAttribute[0]);
        this.cTxt = this.abDir.resolve("c.txt");
        Files.write(this.cTxt, "C\nA file with a C".getBytes(), new OpenOption[0]);
        this.bDir = this.sourceDir.resolve("b");
        Files.createDirectories(this.bDir, new FileAttribute[0]);
        this.store = new SimpleBackupStore(null, BUPREFIX);
    }

    @Override
    public void tearDown() throws IOException {
        BackupTest.deleteAll(this.sourceDir);
    }

    private static void deleteAll(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void testBackupRelative() throws IOException {
        Path cTxtRelative = this.aaDir.resolve(this.aaDir.relativize(this.cTxt));
        this.store.backup(cTxtRelative.toFile());
        BackupTest.assertFalse((boolean)Files.exists(this.cTxt, new LinkOption[0]));
        Files.write(this.cTxt, "XXXX\n- This file should be restored with C".getBytes(), new OpenOption[0]);
        this.store.restore();
        BackupTest.assertFileContent("Restore of C failed - not original content", this.cTxt.toFile(), "C");
        BackupTest.assertNoGarbage(this.store);
    }

    public void testBackupRestore() throws IOException {
        this.store.backup(this.aTxt.toFile());
        BackupTest.assertFalse((String)"File not moved to backup - still exists", (boolean)Files.exists(this.aTxt, new LinkOption[0]));
        Files.write(this.aTxt, "XXXX\n- This file should be restored with A".getBytes(), new OpenOption[0]);
        this.store.backup(this.bDir.toFile());
        BackupTest.assertFalse((String)"Backed up directory was not moved", (boolean)Files.isDirectory(this.bDir, new LinkOption[0]));
        this.store.backupCopy(this.bTxt.toFile());
        BackupTest.assertFileContent("File should have been copied", this.bTxt.toFile(), "B");
        this.store.restore();
        BackupTest.assertFileContent("Restore of A failed - not original content", this.aTxt.toFile(), "A");
        BackupTest.assertTrue((String)"Empty directory not restored ok", (boolean)Files.isDirectory(this.bDir, new LinkOption[0]));
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> s = Files.list(this.bDir);){
            BackupTest.assertFalse((String)"Empty directory not restored ok", (boolean)s.findAny().isPresent());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        BackupTest.assertNoGarbage(this.store);
    }

    public void testBackupDiscard() throws IOException {
        this.store.backup(this.aTxt.toFile());
        BackupTest.assertFalse((String)"File not moved to backup - still exists", (boolean)Files.exists(this.aTxt, new LinkOption[0]));
        Files.write(this.aTxt, "XXXX\n- This file should be restored with A".getBytes(), new OpenOption[0]);
        this.store.backup(this.bDir.toFile());
        BackupTest.assertFalse((String)"Backed up directory was not moved", (boolean)Files.exists(this.bDir, new LinkOption[0]));
        this.store.discard();
        BackupTest.assertFileContent("Discard of a.txt failed - not new content", this.aTxt.toFile(), "XXXX");
        BackupTest.assertFalse((String)"Empty directory not discarded - still exists", (boolean)Files.isDirectory(this.bDir, new LinkOption[0]));
        BackupTest.assertNoGarbage(this.store);
    }

    public void testBackupAll() throws IOException {
        this.store.backupAll(this.aDir.toFile());
        BackupTest.assertFalse((String)"File not moved to backup - still exists", (boolean)Files.exists(this.aTxt, new LinkOption[0]));
        BackupTest.assertFalse((String)"File bTxt not moved to backup - still exists", (boolean)Files.exists(this.bTxt, new LinkOption[0]));
        Files.createDirectories(this.aTxt.getParent(), new FileAttribute[0]);
        Files.write(this.aTxt, "XXXX\n- This file should be restored with A".getBytes(), StandardOpenOption.CREATE_NEW);
        this.store.restore();
        BackupTest.assertFileContent("A not restored", this.aTxt.toFile(), "A");
        BackupTest.assertFileContent("B not restored", this.bTxt.toFile(), "B");
        BackupTest.assertNoGarbage(this.store);
    }

    public void testBackupCopyAll() throws IOException {
        this.store.backupCopyAll(this.aDir.toFile());
        BackupTest.assertTrue((String)"File not copied to backup - does not exist", (boolean)Files.exists(this.aTxt, new LinkOption[0]));
        BackupTest.assertTrue((String)"File bTxt not copied to backup - does not exists", (boolean)Files.exists(this.bTxt, new LinkOption[0]));
        Files.write(this.aTxt, "XXXX\n- This file should be restored with A".getBytes(), new OpenOption[0]);
        Files.write(this.bTxt, "XXXX\n- This file should be restored with B".getBytes(), new OpenOption[0]);
        this.store.restore();
        BackupTest.assertFileContent("A not restored", this.aTxt.toFile(), "A");
        BackupTest.assertFileContent("B not restored", this.bTxt.toFile(), "B");
        BackupTest.assertNoGarbage(this.store);
    }

    private static void assertNoGarbage(SimpleBackupStore store) {
        File buDir = store.getBackupRoot();
        BackupTest.assertFalse((String)"Backup directory not cleaned up", (boolean)buDir.exists());
    }
}

