/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class CollectorTest
extends AbstractProvisioningTest {
    public void testAccept() {
        Collector collector = new Collector();
        String value = "value";
        collector.accept((Object)value);
        Object[] result = collector.toArray(Object.class);
        CollectorTest.assertEquals((String)"1.0", (int)1, (int)result.length);
        CollectorTest.assertEquals((String)"1.1", (Object)value, (Object)result[0]);
        collector.accept((Object)new String(value));
        result = collector.toArray(Object.class);
        CollectorTest.assertEquals((String)"1.0", (int)1, (int)result.length);
        CollectorTest.assertEquals((String)"1.1", (Object)value, (Object)result[0]);
    }

    public void testIsEmpty() {
        Collector collector = new Collector();
        CollectorTest.assertEquals((String)"1.0", (boolean)true, (boolean)collector.isEmpty());
        collector.accept((Object)"value");
        CollectorTest.assertEquals((String)"1.0", (boolean)false, (boolean)collector.isEmpty());
    }

    public void testCompositeCollectors() {
        String[] s = new String[]{"A", "B", "C", "D", "E", "F", "G", "1", "2", "3", "4", "5", "6", "7"};
        List<String> list = Arrays.asList(s);
        MatchQuery<String> numeric = new MatchQuery<String>(){

            public boolean isMatch(String candidate) {
                return candidate.compareTo("0") > 0 && candidate.compareTo("8") < 0;
            }
        };
        MatchQuery<String> fourOrFiveOrABC = new MatchQuery<String>(){

            public boolean isMatch(String candidate) {
                return candidate.equals("4") || candidate.equals("5") || candidate.equals("A") || candidate.equals("B") || candidate.equals("C");
            }
        };
        IQueryResult queryResult = numeric.perform(list.iterator());
        CollectorTest.assertEquals((String)"1.0", (int)7, (int)CollectorTest.queryResultSize(queryResult));
        queryResult = queryResult.query((IQuery)fourOrFiveOrABC, null);
        CollectorTest.assertEquals((String)"2.0", (int)2, (int)CollectorTest.queryResultSize(queryResult));
        CollectorTest.assertContains("2.1", queryResult, "4");
        CollectorTest.assertContains("2.2", queryResult, "5");
    }

    public void testSameCollector() {
        String[] s = new String[]{"A", "B", "C", "D", "E", "F", "G", "1", "2", "3", "4", "5", "6", "7"};
        List<String> list = Arrays.asList(s);
        MatchQuery<String> numeric = new MatchQuery<String>(){

            public boolean isMatch(String candidate) {
                return candidate.compareTo("0") > 0 && candidate.compareTo("8") < 0;
            }
        };
        MatchQuery<String> fourOrFiveOrABC = new MatchQuery<String>(){

            public boolean isMatch(String candidate) {
                return candidate.equals("4") || candidate.equals("5") || candidate.equals("A") || candidate.equals("B") || candidate.equals("C");
            }
        };
        Collector collector = new Collector();
        collector.addAll(numeric.perform(list.iterator()));
        CollectorTest.assertEquals((String)"1.0", (int)7, (int)collector.toUnmodifiableSet().size());
        collector.addAll(collector.query((IQuery)fourOrFiveOrABC, null));
        Set collection = collector.toUnmodifiableSet();
        CollectorTest.assertEquals((String)"2.0", (int)7, (int)collection.size());
    }

    public void testEmptyCompositeCollectors() {
        String[] s = new String[]{"A", "B", "C", "D", "E", "F", "G", "1", "2", "3", "4", "5", "6", "7"};
        List<String> list = Arrays.asList(s);
        MatchQuery<String> eightOrNine = new MatchQuery<String>(){

            public boolean isMatch(String candidate) {
                return candidate.compareTo("8") > 0 && candidate.compareTo("9") < 0;
            }
        };
        MatchQuery<String> fourOrFiveOrABC = new MatchQuery<String>(){

            public boolean isMatch(String candidate) {
                return candidate.equals("4") || candidate.equals("5") || candidate.equals("A") || candidate.equals("B") || candidate.equals("C");
            }
        };
        IQueryResult queryResult = eightOrNine.perform(list.iterator());
        CollectorTest.assertTrue((String)"1.0", (boolean)queryResult.isEmpty());
        queryResult = queryResult.query((IQuery)fourOrFiveOrABC, null);
        CollectorTest.assertTrue((String)"2.0", (boolean)queryResult.isEmpty());
    }

    public void testToCollection() {
        Collector collector = new Collector();
        Set result = collector.toUnmodifiableSet();
        CollectorTest.assertEquals((String)"1.0", (int)0, (int)result.size());
        try {
            result.add("value");
            CollectorTest.fail((String)"1.1");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        String value = "value";
        collector.accept((Object)value);
        result = collector.toUnmodifiableSet();
        CollectorTest.assertEquals((String)"2.0", (int)1, (int)result.size());
        CollectorTest.assertEquals((String)"2.1", (String)value, (String)((String)result.iterator().next()));
        try {
            result.clear();
            CollectorTest.fail((String)"2.2");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

