/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;

public class FileUtilsTest
extends AbstractProvisioningTest {
    public void testUnzip() {
        File temp = this.getTempFolder();
        File one = new File(temp, "a.txt");
        File two = new File(temp, "b/b.txt");
        File data = FileUtilsTest.getTestData("1.0", "testData/core/a.zip");
        try {
            FileUtils.unzipFile((File)data, (File)temp);
        }
        catch (IOException e) {
            FileUtilsTest.fail("1.99", e);
        }
        FileUtilsTest.assertTrue((String)"1.1", (boolean)one.exists());
        FileUtilsTest.delete(one);
        FileUtilsTest.assertTrue((String)"1.2", (!one.exists() ? 1 : 0) != 0);
        data = FileUtilsTest.getTestData("2.0", "testData/core/a2.zip");
        try {
            FileUtils.unzipFile((File)data, (File)temp);
        }
        catch (IOException e) {
            FileUtilsTest.fail("2.99", e);
        }
        FileUtilsTest.assertTrue((String)"2.1", (boolean)one.exists());
        FileUtilsTest.assertTrue((String)"2.2", (boolean)two.exists());
        FileUtilsTest.delete(one);
        FileUtilsTest.delete(two);
        FileUtilsTest.assertTrue((String)"2.3", (!one.exists() ? 1 : 0) != 0);
        FileUtilsTest.assertTrue((String)"2.4", (!two.exists() ? 1 : 0) != 0);
        data = FileUtilsTest.getTestData("3.0", "testData/core/a.tar.gz");
        try {
            FileUtils.unzipFile((File)data, (File)temp);
        }
        catch (IOException e) {
            FileUtilsTest.fail("3.99", e);
        }
        FileUtilsTest.assertTrue((String)"3.1", (boolean)one.exists());
        FileUtilsTest.delete(one);
        FileUtilsTest.assertTrue((String)"3.2", (!one.exists() ? 1 : 0) != 0);
        data = FileUtilsTest.getTestData("2.0", "testData/core/a2.tar.gz");
        try {
            FileUtils.unzipFile((File)data, (File)temp);
        }
        catch (IOException e) {
            FileUtilsTest.fail("3.99", e);
        }
        FileUtilsTest.assertTrue((String)"3.1", (boolean)one.exists());
        FileUtilsTest.assertTrue((String)"3.2", (boolean)two.exists());
        FileUtilsTest.delete(one);
        FileUtilsTest.delete(two);
        FileUtilsTest.assertTrue((String)"3.3", (!one.exists() ? 1 : 0) != 0);
        FileUtilsTest.assertTrue((String)"3.4", (!two.exists() ? 1 : 0) != 0);
    }

    public void testUnzipEscapeZipRoot() throws IOException {
        File badZip = TestActivator.getContext().getDataFile(this.getName() + ".zip");
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(badZip.toPath(), new OpenOption[0]));){
            zos.putNextEntry(new ZipEntry("../../escapeRoot.txt"));
            zos.write("test data".getBytes());
            zos.closeEntry();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        File temp = this.getTempFolder();
        try {
            FileUtils.unzipFile((File)badZip, (File)temp);
        }
        catch (IOException e) {
            FileUtilsTest.assertTrue((String)("Wrong message: " + e.getMessage()), (boolean)e.getMessage().contains("Invalid path: "));
        }
        try {
            Util.unzipFile((File)badZip, (File)temp, null, null, null);
        }
        catch (IOException e) {
            FileUtilsTest.assertTrue((String)("Wrong message: " + e.getMessage()), (boolean)e.getMessage().contains("Invalid path: "));
        }
    }

    public void testBug266844zip() throws IOException {
        File zip = TestActivator.getContext().getDataFile(this.getName() + ".zip");
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zip.toPath(), new OpenOption[0]));){
            zos.putNextEntry(new ZipEntry("./"));
            zos.putNextEntry(new ZipEntry("./content.txt"));
            zos.write("test data".getBytes());
            zos.closeEntry();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        File temp = this.getTempFolder();
        FileUtils.unzipFile((File)zip, (File)temp);
        File extracted = new File(temp, "content.txt");
        FileUtilsTest.assertEquals((String)"test data", (String)Files.readString(extracted.toPath()));
        FileUtilsTest.assertTrue((String)"File not deleted", (boolean)extracted.delete());
        Util.unzipFile((File)zip, (File)temp, null, null, null);
        FileUtilsTest.assertEquals((String)"test data", (String)Files.readString(extracted.toPath()));
        FileUtilsTest.assertTrue((String)"File not deleted", (boolean)extracted.delete());
    }

    public void testBug266844tar() throws IOException {
        File tar = TestActivator.getContext().getDataFile(this.getName() + ".tar.gz");
        Throwable throwable = null;
        Object var3_4 = null;
        try (TarOutputStream tos = new TarOutputStream(Files.newOutputStream(tar.toPath(), new OpenOption[0]));){
            tos.putNextEntry(new TarEntry("./"));
            TarEntry entry = new TarEntry("./content.txt");
            entry.setSize(9L);
            tos.putNextEntry(entry);
            tos.write("test data".getBytes());
            tos.closeEntry();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        File temp = this.getTempFolder();
        FileUtils.unzipFile((File)tar, (File)temp);
        File extracted = new File(temp, "content.txt");
        FileUtilsTest.assertEquals((String)"test data", (String)Files.readString(extracted.toPath()));
        FileUtilsTest.assertTrue((String)"File not deleted", (boolean)extracted.delete());
    }

    public void testZipRootPathComputer() {
        File temp = this.getTempFolder();
        File data = FileUtilsTest.getTestData("1.0", "testData/core/a");
        File archive = new File(temp, FileUtilsTest.getUniqueString() + ".zip");
        try {
            FileUtils.zip((File[])data.listFiles(), null, (File)archive, (FileUtils.IPathComputer)FileUtils.createRootPathComputer((File)data));
        }
        catch (IOException e) {
            FileUtilsTest.fail("1.99", e);
        }
        FileUtilsTest.assertTrue((String)"1.1", (boolean)archive.exists());
        FileUtilsTest.assertTrue((String)"1.2", (archive.length() > 0L ? 1 : 0) != 0);
        FileUtilsTest.assertExists("1.3", archive, "a.txt");
        data = FileUtilsTest.getTestData("2.0", "testData/core/a2");
        archive = new File(temp, FileUtilsTest.getUniqueString() + ".zip");
        try {
            FileUtils.zip((File[])data.listFiles(), null, (File)archive, (FileUtils.IPathComputer)FileUtils.createRootPathComputer((File)data));
        }
        catch (IOException e) {
            FileUtilsTest.fail("2.99", e);
        }
        FileUtilsTest.assertTrue((String)"2.1", (boolean)archive.exists());
        FileUtilsTest.assertTrue((String)"2.2", (archive.length() > 0L ? 1 : 0) != 0);
        FileUtilsTest.assertExists("2.3", archive, "a.txt");
        FileUtilsTest.assertExists("2.4", archive, "b/b.txt");
        FileUtilsTest.assertExists("2.5", archive, "b/");
    }

    public void testZipDynamicPathComputer() {
        File temp = this.getTempFolder();
        File data = FileUtilsTest.getTestData("1.0", "testData/core/a2");
        File archive = new File(temp, FileUtilsTest.getUniqueString() + ".zip");
        try {
            FileUtils.zip((File[])data.listFiles(), null, (File)archive, (FileUtils.IPathComputer)FileUtils.createDynamicPathComputer((int)0));
            FileUtilsTest.fail((String)"1.99");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        archive = new File(temp, FileUtilsTest.getUniqueString() + ".zip");
        try {
            FileUtils.zip((File[])data.listFiles(), null, (File)archive, (FileUtils.IPathComputer)FileUtils.createDynamicPathComputer((int)1));
        }
        catch (IOException e) {
            FileUtilsTest.fail("2.99", e);
        }
        FileUtilsTest.assertTrue((String)"2.1", (boolean)archive.exists());
        FileUtilsTest.assertTrue((String)"2.2", (archive.length() > 0L ? 1 : 0) != 0);
        FileUtilsTest.assertExists("2.3", archive, "a.txt");
        FileUtilsTest.assertExists("2.4", archive, "b.txt");
        archive = new File(temp, FileUtilsTest.getUniqueString() + ".zip");
        try {
            FileUtils.zip((File[])data.listFiles(), null, (File)archive, (FileUtils.IPathComputer)FileUtils.createDynamicPathComputer((int)2));
        }
        catch (IOException e) {
            FileUtilsTest.fail("3.99", e);
        }
        FileUtilsTest.assertTrue((String)"3.1", (boolean)archive.exists());
        FileUtilsTest.assertTrue((String)"3.2", (archive.length() > 0L ? 1 : 0) != 0);
        FileUtilsTest.assertExists("3.3", archive, "a2/a.txt");
        FileUtilsTest.assertExists("3.3.1", archive, "a2/");
        FileUtilsTest.assertExists("3.4", archive, "b/b.txt");
        FileUtilsTest.assertExists("3.4.1", archive, "b/");
        archive = new File(temp, FileUtilsTest.getUniqueString() + ".zip");
        File[] input = new File[]{FileUtilsTest.getTestData("4.0", "testData/core/x/y"), FileUtilsTest.getTestData("4.0", "testData/core/z")};
        try {
            FileUtils.zip((File[])input, null, (File)archive, (FileUtils.IPathComputer)FileUtils.createDynamicPathComputer((int)2));
        }
        catch (IOException e) {
            FileUtilsTest.fail("4.99", e);
        }
        FileUtilsTest.assertTrue((String)"4.1", (boolean)archive.exists());
        FileUtilsTest.assertTrue((String)"4.2", (archive.length() > 0L ? 1 : 0) != 0);
        FileUtilsTest.assertExists("4.3", archive, "features/feature.txt");
        FileUtilsTest.assertExists("4.3.1", archive, "features/");
        FileUtilsTest.assertExists("4.4", archive, "plugins/bundle.txt");
        FileUtilsTest.assertExists("4.4.1", archive, "plugins/");
    }

    public void testZipParentPrefixComputer() {
        File temp = this.getTempFolder();
        File data = FileUtilsTest.getTestData("1.0", "testData/core/a2");
        File archive = new File(temp, FileUtilsTest.getUniqueString() + ".zip");
        try {
            FileUtils.zip((File[])data.listFiles(), null, (File)archive, (FileUtils.IPathComputer)FileUtils.createParentPrefixComputer((int)0));
            FileUtilsTest.fail((String)"0.99");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileUtils.zip((File[])data.listFiles(), null, (File)archive, (FileUtils.IPathComputer)FileUtils.createParentPrefixComputer((int)1));
        }
        catch (IOException e) {
            FileUtilsTest.fail("1.99", e);
        }
        FileUtilsTest.assertTrue((String)"1.1", (boolean)archive.exists());
        FileUtilsTest.assertTrue((String)"1.2", (archive.length() > 0L ? 1 : 0) != 0);
        FileUtilsTest.assertExists("1.3", archive, "a.txt");
        FileUtilsTest.assertExists("1.4", archive, "b.txt");
        archive = new File(temp, FileUtilsTest.getUniqueString() + ".zip");
        try {
            FileUtils.zip((File[])data.listFiles(), null, (File)archive, (FileUtils.IPathComputer)FileUtils.createParentPrefixComputer((int)2));
        }
        catch (IOException e) {
            FileUtilsTest.fail("2.99", e);
        }
        FileUtilsTest.assertTrue((String)"2.1", (boolean)archive.exists());
        FileUtilsTest.assertTrue((String)"2.2", (archive.length() > 0L ? 1 : 0) != 0);
        FileUtilsTest.assertExists("2.3", archive, "a2/a.txt");
        FileUtilsTest.assertExists("2.4", archive, "b/b.txt");
        archive = new File(temp, FileUtilsTest.getUniqueString() + ".zip");
        File[] input = new File[]{FileUtilsTest.getTestData("4.0", "testData/core/x/y"), FileUtilsTest.getTestData("4.0", "testData/core/z")};
        try {
            FileUtils.zip((File[])input, null, (File)archive, (FileUtils.IPathComputer)FileUtils.createParentPrefixComputer((int)2));
        }
        catch (IOException e) {
            FileUtilsTest.fail("3.99", e);
        }
        FileUtilsTest.assertTrue((String)"3.1", (boolean)archive.exists());
        FileUtilsTest.assertTrue((String)"3.2", (archive.length() > 0L ? 1 : 0) != 0);
        FileUtilsTest.assertExists("3.3", archive, "features/feature.txt");
        FileUtilsTest.assertExists("3.4", archive, "plugins/bundle.txt");
    }

    private static void assertExists(String message, File archive, String entry) {
        if (!archive.exists()) {
            FileUtilsTest.fail((String)(message + " file does not exist."));
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zip = new ZipFile(archive);){
                boolean found = false;
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (!found && e.hasMoreElements()) {
                    ZipEntry zipEntry = e.nextElement();
                    if (!entry.equals(zipEntry.getName())) continue;
                    found = true;
                }
                FileUtilsTest.assertTrue((String)message, (boolean)found);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            FileUtilsTest.fail(message, e);
        }
    }

    public void testDynamicPathComputer0() {
        FileUtils.IPathComputer computer = FileUtils.createDynamicPathComputer((int)0);
        this.validate(computer, "/foo", "");
        this.validate(computer, "/foo/bar", "bar");
        this.validate(computer, "/foo/bar/this", "bar/this");
        computer.reset();
        this.validate(computer, "/foo/bar", "");
        this.validate(computer, "/foo/bar/this", "this");
    }

    public void testDynamicPathComputer1() {
        FileUtils.IPathComputer computer = FileUtils.createDynamicPathComputer((int)1);
        this.validate(computer, "/foo", "/foo");
        this.validate(computer, "/foo/bar", "/foo/bar");
        this.validate(computer, "/foo/bar/this", "/foo/bar/this");
        computer.reset();
        this.validate(computer, "/foo/bar", "bar");
        this.validate(computer, "/foo/bar/this", "bar/this");
    }

    public void testParentPathComputer0() {
        FileUtils.IPathComputer computer = FileUtils.createParentPrefixComputer((int)0);
        this.validate(computer, "/foo", "");
        this.validate(computer, "/foo/bar", "");
        this.validate(computer, "/foo/bar/this", "");
    }

    public void testParentPathComputer1() {
        FileUtils.IPathComputer computer = FileUtils.createParentPrefixComputer((int)1);
        this.validate(computer, "/foo", "/foo");
        this.validate(computer, "/foo/bar", "bar");
        this.validate(computer, "/foo/bar/this", "this");
    }

    public void testParentPathComputer2() {
        FileUtils.IPathComputer computer = FileUtils.createParentPrefixComputer((int)2);
        this.validate(computer, "/foo", "/foo");
        this.validate(computer, "/foo/bar", "/foo/bar");
        this.validate(computer, "/foo/bar/this", "bar/this");
    }

    public void testRootPathComputer0() {
        FileUtils.IPathComputer computer = FileUtils.createRootPathComputer((File)new File("/"));
        this.validate(computer, "/foo", "/foo");
        this.validate(computer, "/foo/bar", "/foo/bar");
        this.validate(computer, "/foo/bar/this", "/foo/bar/this");
    }

    public void testRootPathComputer1() {
        FileUtils.IPathComputer computer = FileUtils.createRootPathComputer((File)new File("/foo"));
        this.validate(computer, "/foo", "");
        this.validate(computer, "/foo/bar", "bar");
        this.validate(computer, "/foo/bar/this", "bar/this");
    }

    public void testRootPathComputer2() {
        FileUtils.IPathComputer computer = FileUtils.createRootPathComputer((File)new File("/foo/bar"));
        this.validate(computer, "/foo", "");
        this.validate(computer, "/foo/bar", "");
        this.validate(computer, "/foo/bar/this", "this");
        this.validate(computer, "/foo/bar/this/that", "this/that");
    }

    private void validate(FileUtils.IPathComputer computer, String input, String output) {
        IPath computed = computer.computePath(new File(input));
        IPath desired = IPath.fromOSString((String)output);
        FileUtilsTest.assertEquals((Object)computed, (Object)desired);
    }
}

