/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.ServiceReference;

public class ProvisioningAgentTest
extends AbstractProvisioningTest {
    public void testMultipleAgents() throws ProvisionException, URISyntaxException {
        URI repoLocation = new URI("https://download.eclipse.org/eclipse/updates/latest");
        URI p2location = this.getTempFolder().toURI();
        String PROFILE_ID = "testMultipleAgents";
        ServiceReference providerRef = TestActivator.context.getServiceReference(IProvisioningAgentProvider.class);
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)TestActivator.context.getService(providerRef);
        IProvisioningAgent firstAgent = provider.createAgent(p2location);
        IProfileRegistry firstProfileRegistry = (IProfileRegistry)firstAgent.getService(IProfileRegistry.class);
        firstProfileRegistry.removeProfile(PROFILE_ID);
        firstProfileRegistry.addProfile(PROFILE_ID);
        IMetadataRepositoryManager firstMdrMgr = (IMetadataRepositoryManager)firstAgent.getService(IMetadataRepositoryManager.class);
        firstMdrMgr.addRepository(repoLocation);
        firstMdrMgr.setEnabled(repoLocation, false);
        firstAgent.stop();
        IProvisioningAgent secondAgent = provider.createAgent(p2location);
        IProfileRegistry secondProfileRegistry = (IProfileRegistry)secondAgent.getService(IProfileRegistry.class);
        secondProfileRegistry.removeProfile(PROFILE_ID);
        secondProfileRegistry.addProfile(PROFILE_ID);
        IMetadataRepositoryManager secondMdrMgr = (IMetadataRepositoryManager)secondAgent.getService(IMetadataRepositoryManager.class);
        secondMdrMgr.removeRepository(repoLocation);
        secondAgent.stop();
        TestActivator.context.ungetService(providerRef);
    }
}

