/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.util.List;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.junit.Assert;
import org.junit.Test;

public class QueryTest {
    @Test
    public void testPerformSimple() {
        List<String> items = List.of("red", "green", "blue");
        AnyStringQuery query = new AnyStringQuery();
        IQueryResult collector = query.perform(items.iterator());
        Assert.assertEquals((long)3L, (long)AbstractProvisioningTest.queryResultSize(collector));
        AbstractProvisioningTest.assertContains(collector, "red");
        AbstractProvisioningTest.assertContains(collector, "green");
        AbstractProvisioningTest.assertContains(collector, "blue");
    }

    @Test
    public void testPerformSomeMatches() {
        List<Object> items = List.of(new Object(), "green", new Object());
        AnyStringQuery query = new AnyStringQuery();
        IQueryResult collector = query.perform(items.iterator());
        Assert.assertEquals((long)1L, (long)AbstractProvisioningTest.queryResultSize(collector));
        AbstractProvisioningTest.assertContains(collector, "green");
    }

    @Test
    public void testLimitQuery() {
        List<String> items = List.of("red", "green", "blue");
        AnyStringQuery query = new AnyStringQuery();
        IQuery limitQuery = QueryUtil.createLimitQuery((IQuery)query, (int)1);
        IQueryResult collector = limitQuery.perform(items.iterator());
        Assert.assertEquals((long)1L, (long)AbstractProvisioningTest.queryResultSize(collector));
        AbstractProvisioningTest.assertContains(collector, "red");
    }

    @Test
    public void testLimitQuery2() {
        List<String> items = List.of("red", "green", "blue");
        AnyStringQuery query = new AnyStringQuery();
        IQuery limitQuery = QueryUtil.createLimitQuery((IQuery)query, (int)2);
        IQueryResult collector = limitQuery.perform(items.iterator());
        Assert.assertEquals((long)2L, (long)AbstractProvisioningTest.queryResultSize(collector));
        AbstractProvisioningTest.assertContains(collector, "red");
        AbstractProvisioningTest.assertContains(collector, "green");
    }

    @Test
    public void testLimitQuery3() {
        List<String> items = List.of("red", "green", "blue");
        AnyStringQuery query = new AnyStringQuery();
        IQuery limitQuery = QueryUtil.createLimitQuery((IQuery)query, (int)3);
        IQueryResult collector = limitQuery.perform(items.iterator());
        Assert.assertEquals((long)3L, (long)AbstractProvisioningTest.queryResultSize(collector));
        AbstractProvisioningTest.assertContains(collector, "red");
        AbstractProvisioningTest.assertContains(collector, "green");
        AbstractProvisioningTest.assertContains(collector, "blue");
    }

    @Test
    public void testLimitQuery0() {
        List<String> items = List.of("red", "green", "blue");
        AnyStringQuery query = new AnyStringQuery();
        IQuery limitQuery = QueryUtil.createLimitQuery((IQuery)query, (int)0);
        IQueryResult collector = limitQuery.perform(items.iterator());
        Assert.assertEquals((long)0L, (long)AbstractProvisioningTest.queryResultSize(collector));
    }

    static class AnyStringQuery
    extends MatchQuery {
        AnyStringQuery() {
        }

        public boolean isMatch(Object candidate) {
            return candidate instanceof String;
        }
    }
}

