/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.util.Arrays;
import org.eclipse.equinox.internal.p2.core.helpers.StringHelper;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.junit.Assert;
import org.junit.Test;

public class StringHelperTest {
    @Test
    public void testSimilarBehavior() {
        Object[] a1 = AbstractPublisherAction.getArrayFromString((String)"foo, bar, baz ,,, zaz", (String)",");
        Object[] a2 = StringHelper.getArrayFromString((String)"foo, bar, baz ,,, zaz", (char)',');
        Assert.assertTrue((String)"1.0", (boolean)Arrays.equals(a1, a2));
        a1 = AbstractPublisherAction.getArrayFromString((String)"foo   bar baz, ,, zaz", (String)" ");
        a2 = StringHelper.getArrayFromString((String)"foo   bar baz, ,, zaz", (char)' ');
        Assert.assertTrue((String)"1.1", (boolean)Arrays.equals(a1, a2));
        a1 = AbstractPublisherAction.getArrayFromString((String)"   ", (String)" ");
        a2 = StringHelper.getArrayFromString((String)"   ", (char)' ');
        Assert.assertTrue((String)"1.2", (boolean)Arrays.equals(a1, a2));
        a1 = AbstractPublisherAction.getArrayFromString((String)"", (String)",");
        a2 = StringHelper.getArrayFromString((String)"", (char)',');
        Assert.assertTrue((String)"1.3", (boolean)Arrays.equals(a1, a2));
        a1 = AbstractPublisherAction.getArrayFromString(null, (String)",");
        a2 = StringHelper.getArrayFromString(null, (char)',');
        Assert.assertTrue((String)"1.4", (boolean)Arrays.equals(a1, a2));
    }

    @Test
    public void testPerformance() throws Exception {
        String[] strings = new String[5];
        StringBuilder inputBld = new StringBuilder();
        int idx = 0;
        while (idx < 5) {
            if (idx > 0) {
                inputBld.append(',');
            }
            int c = 11;
            while (c > idx * 2) {
                inputBld.append((char)(97 + c));
                --c;
            }
            strings[idx] = inputBld.toString();
            ++idx;
        }
        long ts = System.currentTimeMillis();
        int cnt = 0;
        while (cnt < 1000000) {
            int idx2 = 0;
            while (idx2 < 5) {
                AbstractPublisherAction.getArrayFromString((String)strings[idx2], (String)",");
                ++idx2;
            }
            ++cnt;
        }
        long apaTime = System.currentTimeMillis() - ts;
        ts = System.currentTimeMillis();
        int cnt2 = 0;
        while (cnt2 < 1000000) {
            int idx3 = 0;
            while (idx3 < 5) {
                StringHelper.getArrayFromString((String)strings[idx3], (char)',');
                ++idx3;
            }
            ++cnt2;
        }
        long shTime = System.currentTimeMillis() - ts;
        System.out.println("Ratio: " + (double)shTime / (double)apaTime);
    }
}

