/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class URLUtilTest
extends AbstractProvisioningTest {
    private static final String[] testPaths = new String[]{"abc", "with spaces", "with%percent"};

    public void testToFile() throws MalformedURLException {
        File base = new File(System.getProperty("java.io.tmpdir"));
        int i = 0;
        while (i < testPaths.length) {
            File original = new File(base, testPaths[i]);
            URI uri = original.toURI();
            URL encoded = uri.toURL();
            File result = URLUtil.toFile((URL)encoded);
            URLUtilTest.assertEquals((Object)original, (Object)result);
            ++i;
        }
    }

    public void testToFileRelative() throws URISyntaxException, MalformedURLException {
        int i = 0;
        while (i < testPaths.length) {
            File original = new File(testPaths[i]);
            URI uri = new URI(null, testPaths[i], null);
            URL encoded = new URL("file:" + uri.getRawPath());
            File result = URLUtil.toFile((URL)encoded);
            URLUtilTest.assertEquals((Object)original, (Object)result);
            ++i;
        }
    }

    public void testToFileFromLocalURL() throws Exception {
        File original = new File(System.getProperty("java.io.tmpdir"), "repo");
        URL url = new URL("file:" + original.toString());
        File result = URLUtil.toFile((URL)url);
        URLUtilTest.assertEquals((Object)original, (Object)result);
    }

    public void testToFileFromUNC() throws Exception {
        File original = new File("//a/b c");
        URL url = new URL("file:" + original.toString());
        File result = URLUtil.toFile((URL)url);
        URLUtilTest.assertEquals((Object)original, (Object)result);
        url = original.toURI().toURL();
        result = URLUtil.toFile((URL)url);
        URLUtilTest.assertEquals((Object)original, (Object)result);
    }
}

