/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.app.DirectorApplication;
import org.eclipse.equinox.internal.simpleconfigurator.utils.URIUtil;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class DirectorApplicationTest
extends AbstractProvisioningTest {
    private StringBuilder runDirectorApp(String message, String[] args) throws Exception {
        PrintStream out = System.out;
        PrintStream err = System.err;
        StringBuilder buffer = new StringBuilder();
        try {
            PrintStream newStream = new PrintStream(new StringBufferStream(buffer));
            System.setOut(newStream);
            System.setErr(newStream);
            DirectorApplication application = new DirectorApplication();
            application.run(args);
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
        return buffer;
    }

    private String[] getSingleRepoUninstallArgs(String message, File srcRepo, File destinationRepo, String installIU) {
        return new String[]{"-repository", srcRepo.toURI().toString(), "-uninstallIU", installIU, "-destination", destinationRepo.toURI().toString(), "-profile", "PlatformSDKProfile"};
    }

    private String[] getSingleRepoArgs(String message, File metadataRepo, File artifactRepo, File destinationRepo, String installIU) {
        return new String[]{"-metadataRepository", URIUtil.toUnencodedString((URI)metadataRepo.toURI()), "-artifactRepository", URIUtil.toUnencodedString((URI)artifactRepo.toURI()), "-installIU", installIU, "-destination", URIUtil.toUnencodedString((URI)destinationRepo.toURI()), "-profile", "PlatformSDKProfile", "-profileProperties", "org.eclipse.update.install.features=true", "-bundlepool", destinationRepo.getAbsolutePath(), "-roaming"};
    }

    private String[] getSingleRepoArgs(String message, File metadataRepo, File artifactRepo, File destinationRepo, String installIU, String parameter) {
        return new String[]{"-metadataRepository", URIUtil.toUnencodedString((URI)metadataRepo.toURI()), "-artifactRepository", URIUtil.toUnencodedString((URI)artifactRepo.toURI()), "-installIU", installIU, "-destination", URIUtil.toUnencodedString((URI)destinationRepo.toURI()), "-profile", "PlatformSDKProfile", "-profileProperties", "org.eclipse.update.install.features=true", "-bundlepool", destinationRepo.getAbsolutePath(), "-roaming", parameter};
    }

    private String[] getSingleRepoArgsForListing(String message, File metadataRepo, File artifactRepo, String listArgument, String iuToList, String listFormatArgument, String formatString) {
        return new String[]{"-metadataRepository", URIUtil.toUnencodedString((URI)metadataRepo.toURI()), "-artifactRepository", URIUtil.toUnencodedString((URI)artifactRepo.toURI()), listArgument, iuToList, listFormatArgument, formatString};
    }

    private String[] getMultipleRepoArgs(String message, File metadataRepo1, File metadataRepo2, File artifactRepo1, File artifactRepo2, File destinationRepo, String installIU) {
        return new String[]{"-metadataRepository", metadataRepo1.toURI().toString() + "," + metadataRepo2.toURI().toString(), "-artifactRepository", artifactRepo1.toURI().toString() + "," + artifactRepo2.toURI().toString(), "-installIU", installIU, "-destination", destinationRepo.toURI().toString(), "-profile", "PlatformSDKProfile", "-profileProperties", "org.eclipse.update.install.features=true", "-bundlepool", destinationRepo.getAbsolutePath(), "-roaming"};
    }

    public void testSingleRepoCreationBothInvalid() {
        File metadataRepo = new File(this.getTempFolder(), "DirectorApp Metadata");
        File artifactRepo = new File(this.getTempFolder(), "DirectorApp Artifact");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(metadataRepo);
        DirectorApplicationTest.delete(artifactRepo);
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getSingleRepoArgs("1.0", metadataRepo, artifactRepo, destinationRepo, installIU);
        StringBuilder outputBuffer = null;
        try {
            outputBuffer = this.runDirectorApp("1.1", args);
        }
        catch (ProvisionException provisionException) {
        }
        catch (Exception e) {
            DirectorApplicationTest.fail("1.2", e);
        }
        String outputString = outputBuffer.toString();
        DirectorApplicationTest.assertTrue((boolean)outputString.contains("No repository found at " + metadataRepo.toURI().toString()));
        DirectorApplicationTest.assertTrue((boolean)outputString.contains("No repository found at " + artifactRepo.toURI().toString()));
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertFalse((String)"1.3", (boolean)metadataRepo.exists());
        DirectorApplicationTest.assertFalse((String)"1.4", (boolean)artifactRepo.exists());
        DirectorApplicationTest.assertFalse((String)"1.5", (boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(metadataRepo);
        DirectorApplicationTest.delete(artifactRepo);
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testSingleRepoCreationMetadataInvalid() {
        File metadataRepo = new File(this.getTempFolder(), "DirectorApp Metadata");
        File artifactRepo = DirectorApplicationTest.getTestData("2.0", "/testData/mirror/mirrorSourceRepo1 with space");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(metadataRepo);
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getSingleRepoArgs("2.1", metadataRepo, artifactRepo, destinationRepo, installIU);
        StringBuilder outputBuffer = null;
        try {
            outputBuffer = this.runDirectorApp("2.2", args);
        }
        catch (ProvisionException provisionException) {
        }
        catch (Exception e) {
            DirectorApplicationTest.fail("2.3", e);
        }
        DirectorApplicationTest.assertTrue((boolean)outputBuffer.toString().contains("No repository found at " + metadataRepo.toURI().toString()));
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertFalse((String)"2.4", (boolean)metadataRepo.exists());
        DirectorApplicationTest.assertTrue((String)"2.5", (boolean)artifactRepo.exists());
        DirectorApplicationTest.assertFalse((String)"2.6", (boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(metadataRepo);
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testSingleRepoCreationArtifactInvalid() {
        File metadataRepo = DirectorApplicationTest.getTestData("3.0", "/testData/mirror/mirrorSourceRepo1 with space");
        File artifactRepo = new File(this.getTempFolder(), "DirectorApp Artifact");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(artifactRepo);
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getSingleRepoArgs("3.1", metadataRepo, artifactRepo, destinationRepo, installIU);
        StringBuilder outputBuffer = null;
        try {
            outputBuffer = this.runDirectorApp("3.2", args);
        }
        catch (ProvisionException provisionException) {
        }
        catch (Exception e) {
            DirectorApplicationTest.fail("3.3", e);
        }
        DirectorApplicationTest.assertTrue((boolean)outputBuffer.toString().contains("No repository found at " + artifactRepo.toURI().toString()));
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertFalse((String)"3.4", (boolean)artifactRepo.exists());
        DirectorApplicationTest.assertTrue((String)"3.5", (boolean)metadataRepo.exists());
        DirectorApplicationTest.assertFalse((String)"3.6", (boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(artifactRepo);
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testMultipleRepoCreationAllInvalid() {
        File metadataRepo1 = new File(this.getTempFolder(), "DirectorApp Metadata1");
        File metadataRepo2 = new File(this.getTempFolder(), "DirectorApp Metadata2");
        File artifactRepo1 = new File(this.getTempFolder(), "DirectorApp Artifact1");
        File artifactRepo2 = new File(this.getTempFolder(), "DirectorApp Artifact2");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(metadataRepo1);
        DirectorApplicationTest.delete(metadataRepo2);
        DirectorApplicationTest.delete(artifactRepo1);
        DirectorApplicationTest.delete(artifactRepo2);
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getMultipleRepoArgs("4.0", metadataRepo1, metadataRepo2, artifactRepo1, artifactRepo2, destinationRepo, installIU);
        try {
            this.runDirectorApp("4.1", args);
        }
        catch (ProvisionException provisionException) {
        }
        catch (Exception e) {
            DirectorApplicationTest.fail("4.3", e);
        }
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertFalse((String)"4.4", (boolean)metadataRepo1.exists());
        DirectorApplicationTest.assertFalse((String)"4.5", (boolean)metadataRepo2.exists());
        DirectorApplicationTest.assertFalse((String)"4.6", (boolean)artifactRepo1.exists());
        DirectorApplicationTest.assertFalse((String)"4.6", (boolean)artifactRepo2.exists());
        DirectorApplicationTest.assertFalse((String)"4.7", (boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(metadataRepo1);
        DirectorApplicationTest.delete(metadataRepo2);
        DirectorApplicationTest.delete(artifactRepo1);
        DirectorApplicationTest.delete(artifactRepo2);
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testMultipleRepoCreationAllMetadataInvalid() {
        File metadataRepo1 = new File(this.getTempFolder(), "DirectorApp Metadata1");
        File metadataRepo2 = new File(this.getTempFolder(), "DirectorApp Metadata2");
        File artifactRepo1 = DirectorApplicationTest.getTestData("5.0", "/testData/mirror/mirrorSourceRepo1 with space");
        File artifactRepo2 = DirectorApplicationTest.getTestData("5.1", "/testData/mirror/mirrorSourceRepo2");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(metadataRepo1);
        DirectorApplicationTest.delete(metadataRepo2);
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getMultipleRepoArgs("5.2", metadataRepo1, metadataRepo2, artifactRepo1, artifactRepo2, destinationRepo, installIU);
        try {
            this.runDirectorApp("5.3", args);
        }
        catch (ProvisionException provisionException) {
        }
        catch (Exception e) {
            DirectorApplicationTest.fail("5.5", e);
        }
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertFalse((boolean)metadataRepo1.exists());
        DirectorApplicationTest.assertFalse((boolean)metadataRepo2.exists());
        DirectorApplicationTest.assertTrue((boolean)artifactRepo1.exists());
        DirectorApplicationTest.assertTrue((boolean)artifactRepo2.exists());
        DirectorApplicationTest.assertFalse((boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(metadataRepo1);
        DirectorApplicationTest.delete(metadataRepo2);
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testMultipleRepoCreationOneMetadataInvalid() throws Exception {
        File metadataRepo1 = new File(this.getTempFolder(), "DirectorApp Metadata1");
        File metadataRepo2 = DirectorApplicationTest.getTestData("6.0", "/testData/mirror/mirrorSourceRepo1 with space");
        File artifactRepo1 = DirectorApplicationTest.getTestData("6.1", "/testData/mirror/mirrorSourceRepo1 with space");
        File artifactRepo2 = DirectorApplicationTest.getTestData("6.2", "/testData/mirror/mirrorSourceRepo2");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(metadataRepo1);
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getMultipleRepoArgs("6.3", metadataRepo1, metadataRepo2, artifactRepo1, artifactRepo2, destinationRepo, installIU);
        this.runDirectorApp("6.4", args);
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertFalse((String)"6.7", (boolean)metadataRepo1.exists());
        DirectorApplicationTest.assertTrue((String)"6.8", (boolean)metadataRepo2.exists());
        DirectorApplicationTest.assertTrue((String)"6.9", (boolean)artifactRepo1.exists());
        DirectorApplicationTest.assertTrue((String)"6.10", (boolean)artifactRepo2.exists());
        DirectorApplicationTest.assertFalse((String)"6.11", (boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(metadataRepo1);
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testMultipleRepoCreationAllArtifactInvalid() {
        File artifactRepo1 = new File(this.getTempFolder(), "DirectorApp Artifact1");
        File artifactRepo2 = new File(this.getTempFolder(), "DirectorApp Artifact2");
        File metadataRepo1 = DirectorApplicationTest.getTestData("7.0", "/testData/mirror/mirrorSourceRepo1 with space");
        File metadataRepo2 = DirectorApplicationTest.getTestData("7.1", "/testData/mirror/mirrorSourceRepo2");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(artifactRepo1);
        DirectorApplicationTest.delete(artifactRepo2);
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getMultipleRepoArgs("7.2", metadataRepo1, metadataRepo2, artifactRepo1, artifactRepo2, destinationRepo, installIU);
        try {
            this.runDirectorApp("7.3", args);
        }
        catch (ProvisionException provisionException) {
        }
        catch (Exception e) {
            DirectorApplicationTest.fail("7.5", e);
        }
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertTrue((String)"7.6", (boolean)metadataRepo1.exists());
        DirectorApplicationTest.assertTrue((String)"7.7", (boolean)metadataRepo2.exists());
        DirectorApplicationTest.assertFalse((String)"7.8", (boolean)artifactRepo1.exists());
        DirectorApplicationTest.assertFalse((String)"7.9", (boolean)artifactRepo2.exists());
        DirectorApplicationTest.assertFalse((String)"7.10", (boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(artifactRepo1);
        DirectorApplicationTest.delete(artifactRepo2);
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testMultipleRepoCreationOneArtifactInvalid() throws Exception {
        File artifactRepo1 = new File(this.getTempFolder(), "DirectorApp Artifact1");
        File artifactRepo2 = DirectorApplicationTest.getTestData("8.0", "/testData/mirror/mirrorSourceRepo1 with space");
        File metadataRepo1 = DirectorApplicationTest.getTestData("8.1", "/testData/mirror/mirrorSourceRepo1 with space");
        File metadataRepo2 = DirectorApplicationTest.getTestData("8.2", "/testData/mirror/mirrorSourceRepo2");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(artifactRepo1);
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getMultipleRepoArgs("8.3", metadataRepo1, metadataRepo2, artifactRepo1, artifactRepo2, destinationRepo, installIU);
        this.runDirectorApp("8.4", args);
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertTrue((boolean)metadataRepo1.exists());
        DirectorApplicationTest.assertTrue((boolean)metadataRepo2.exists());
        DirectorApplicationTest.assertFalse((boolean)artifactRepo1.exists());
        DirectorApplicationTest.assertTrue((boolean)artifactRepo2.exists());
        DirectorApplicationTest.assertFalse((boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(artifactRepo1);
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testMultipleRepoCreationOneArtifactOneMetadataInvalid() throws Exception {
        File artifactRepo1 = new File(this.getTempFolder(), "DirectorApp Artifact1");
        File metadataRepo1 = new File(this.getTempFolder(), "DirectorApp Metadata1");
        File artifactRepo2 = DirectorApplicationTest.getTestData("9.0", "/testData/mirror/mirrorSourceRepo1 with space");
        File metadataRepo2 = DirectorApplicationTest.getTestData("9.1", "/testData/mirror/mirrorSourceRepo1 with space");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(artifactRepo1);
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getMultipleRepoArgs("9.2", metadataRepo1, metadataRepo2, artifactRepo1, artifactRepo2, destinationRepo, installIU);
        this.runDirectorApp("9.3", args);
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertFalse((boolean)metadataRepo1.exists());
        DirectorApplicationTest.assertTrue((boolean)metadataRepo2.exists());
        DirectorApplicationTest.assertFalse((boolean)artifactRepo1.exists());
        DirectorApplicationTest.assertTrue((boolean)artifactRepo2.exists());
        DirectorApplicationTest.assertFalse((boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(artifactRepo1);
        DirectorApplicationTest.delete(metadataRepo1);
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testSingleRepoCreationNoneInvalid() throws Exception {
        File artifactRepo = DirectorApplicationTest.getTestData("10.0", "/testData/mirror/mirrorSourceRepo1 with space");
        File metadataRepo = DirectorApplicationTest.getTestData("10.1", "/testData/mirror/mirrorSourceRepo1 with space");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getSingleRepoArgs("10.2", metadataRepo, artifactRepo, destinationRepo, installIU);
        this.runDirectorApp("10.3", args);
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertTrue((boolean)metadataRepo.exists());
        DirectorApplicationTest.assertTrue((boolean)artifactRepo.exists());
        DirectorApplicationTest.assertFalse((boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testMultipleRepoCreationNoneInvalid() {
        File artifactRepo1 = DirectorApplicationTest.getTestData("11.0", "/testData/mirror/mirrorSourceRepo1 with space");
        File metadataRepo1 = DirectorApplicationTest.getTestData("11.1", "/testData/mirror/mirrorSourceRepo1 with space");
        File artifactRepo2 = DirectorApplicationTest.getTestData("11.2", "/testData/mirror/mirrorSourceRepo2");
        File metadataRepo2 = DirectorApplicationTest.getTestData("11.3", "/testData/mirror/mirrorSourceRepo2");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "invalidIU";
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getMultipleRepoArgs("11.4", metadataRepo1, metadataRepo2, artifactRepo1, artifactRepo2, destinationRepo, installIU);
        try {
            this.runDirectorApp("11.5", args);
        }
        catch (ProvisionException e) {
            DirectorApplicationTest.fail("11.6", e);
        }
        catch (Exception e) {
            DirectorApplicationTest.fail("11.7", e);
        }
        DirectorApplicationTest.delete(new File(destinationRepo, "p2"));
        destinationRepo.delete();
        DirectorApplicationTest.assertTrue((String)"11.8", (boolean)metadataRepo1.exists());
        DirectorApplicationTest.assertTrue((String)"11.9", (boolean)metadataRepo2.exists());
        DirectorApplicationTest.assertTrue((String)"11.10", (boolean)artifactRepo1.exists());
        DirectorApplicationTest.assertTrue((String)"11.11", (boolean)artifactRepo2.exists());
        DirectorApplicationTest.assertFalse((String)"11.12", (boolean)destinationRepo.exists());
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testOnlyUsePassedInRepos() throws Exception {
        File artifactRepo1 = DirectorApplicationTest.getTestData("12.0", "/testData/mirror/mirrorSourceRepo3");
        File metadataRepo1 = DirectorApplicationTest.getTestData("12.1", "/testData/mirror/mirrorSourceRepo3");
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)DirectorApplicationTest.getAgent().getService(IArtifactRepositoryManager.class);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)DirectorApplicationTest.getAgent().getService(IMetadataRepositoryManager.class);
        DirectorApplicationTest.assertNotNull((Object)artifactManager);
        DirectorApplicationTest.assertNotNull((Object)metadataManager);
        artifactManager.loadRepository(artifactRepo1.toURI(), (IProgressMonitor)new NullProgressMonitor());
        metadataManager.loadRepository(metadataRepo1.toURI(), (IProgressMonitor)new NullProgressMonitor());
        URI[] knownArtifactRepos = artifactManager.getKnownRepositories(0);
        URI[] knownMetadataRepos = metadataManager.getKnownRepositories(0);
        File artifactRepo2 = DirectorApplicationTest.getTestData("12.2", "/testData/mirror/mirrorSourceRepo4");
        File metadataRepo2 = DirectorApplicationTest.getTestData("12.3", "/testData/mirror/mirrorSourceRepo4");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String[] args = this.getSingleRepoArgs("12.4", metadataRepo2, artifactRepo2, destinationRepo, "yetanotherplugin");
        destinationRepo.mkdirs();
        StringBuilder buffer = this.runDirectorApp("12.5", args);
        DirectorApplicationTest.assertTrue((boolean)buffer.toString().contains("The installable unit yetanotherplugin has not been found."));
        URI[] afterArtifactRepos = artifactManager.getKnownRepositories(0);
        URI[] afterMetadataRepos = metadataManager.getKnownRepositories(0);
        DirectorApplicationTest.assertEquals((int)knownMetadataRepos.length, (int)afterMetadataRepos.length);
        DirectorApplicationTest.assertEquals((int)knownArtifactRepos.length, (int)afterArtifactRepos.length);
        artifactManager.removeRepository(artifactRepo1.toURI());
        metadataManager.removeRepository(metadataRepo1.toURI());
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testPassedInRepos_ProvisioningContext() throws Exception {
        File artifactRepo1 = DirectorApplicationTest.getTestData("13.0", "/testData/mirror/mirrorSourceRepo4");
        File metadataRepo1 = DirectorApplicationTest.getTestData("13.1", "/testData/mirror/mirrorSourceRepo4");
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)DirectorApplicationTest.getAgent().getService(IArtifactRepositoryManager.class);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)DirectorApplicationTest.getAgent().getService(IMetadataRepositoryManager.class);
        DirectorApplicationTest.assertNotNull((Object)artifactManager);
        DirectorApplicationTest.assertNotNull((Object)metadataManager);
        artifactManager.loadRepository(artifactRepo1.toURI(), (IProgressMonitor)new NullProgressMonitor());
        metadataManager.loadRepository(metadataRepo1.toURI(), (IProgressMonitor)new NullProgressMonitor());
        File artifactRepo2 = DirectorApplicationTest.getTestData("13.2", "/testData/mirror/mirrorSourceRepo3");
        File metadataRepo2 = DirectorApplicationTest.getTestData("13.3", "/testData/mirror/mirrorSourceRepo3");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String[] args = this.getSingleRepoArgs("13.4", metadataRepo2, artifactRepo2, destinationRepo, "helloworld");
        destinationRepo.mkdirs();
        StringBuilder buffer = this.runDirectorApp("13.5", args);
        DirectorApplicationTest.assertTrue((boolean)buffer.toString().contains("Installing helloworld 1.0.0."));
        artifactManager.removeRepository(artifactRepo1.toURI());
        metadataManager.removeRepository(metadataRepo1.toURI());
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testDownloadOnlyFlag() {
        File artifactRepo = DirectorApplicationTest.getTestData("testDownloadOnly", "/testData/testRepos/sitewithnestedfeatures");
        File metadataRepo = DirectorApplicationTest.getTestData("testDownloadOnly", "/testData/testRepos/sitewithnestedfeatures");
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String installIU = "fff.feature.group";
        DirectorApplicationTest.delete(destinationRepo);
        String[] args = this.getSingleRepoArgs("testDownloadOnly", metadataRepo, artifactRepo, destinationRepo, installIU, "-downloadOnly");
        try {
            StringBuilder buffer = this.runDirectorApp("testDownloadOnly", args);
            DirectorApplicationTest.assertTrue((boolean)buffer.toString().contains("Installing fff.feature.group 1.0.0."));
        }
        catch (Exception e) {
            DirectorApplicationTest.fail("fail", e);
        }
        DirectorApplicationTest.assertTrue((boolean)destinationRepo.exists());
        File features = new File(destinationRepo, "features");
        DirectorApplicationTest.assertTrue((boolean)features.exists());
        File feature = new File(features, "fff_1.0.0");
        DirectorApplicationTest.assertTrue((boolean)feature.exists());
        File plugins = new File(destinationRepo, "plugins");
        DirectorApplicationTest.assertTrue((boolean)plugins.exists());
        File plugin1 = new File(plugins, "aaa_1.0.0.jar");
        DirectorApplicationTest.assertTrue((boolean)plugin1.exists());
        File plugin2 = new File(plugins, "ccc_1.0.0");
        DirectorApplicationTest.assertTrue((boolean)plugin2.exists());
    }

    public void testListFormatMissingListArgument() throws Exception {
        File artifactRepo = DirectorApplicationTest.getTestData("testListFormatMissingListArgument", "/testData/testRepos/updateSite");
        File metadataRepo = DirectorApplicationTest.getTestData("testListFormatMissingListArgument", "/testData/testRepos/updateSite");
        String[] args = this.getSingleRepoArgsForListing("testListFormatMissingListArgument", metadataRepo, artifactRepo, "", "", "-listFormat", "%i=%v,%d");
        StringBuilder buffer = this.runDirectorApp("testListFormatMissingListArgument", args);
        MatcherAssert.assertThat((Object)buffer.toString(), (Matcher)CoreMatchers.containsString((String)"-listFormat requires"));
    }

    public void testListFormat() throws Exception {
        File artifactRepo = DirectorApplicationTest.getTestData("testListFormat", "/testData/testRepos/updateSite");
        File metadataRepo = DirectorApplicationTest.getTestData("testListFormat", "/testData/testRepos/updateSite");
        String[] args = this.getSingleRepoArgsForListing("testListFormat", metadataRepo, artifactRepo, "-list", "", "-listFormat", "${id}_${version},${id},${org.eclipse.equinox.p2.name}");
        StringBuilder buffer = this.runDirectorApp("testListFormat", args);
        MatcherAssert.assertThat((Object)buffer.toString(), (Matcher)CoreMatchers.containsString((String)"org.eclipse.ui.examples.job_3.0.0,org.eclipse.ui.examples.job,Progress Examples Plug-in"));
    }

    public void testListNoExplicitFormat() throws Exception {
        File artifactRepo = DirectorApplicationTest.getTestData("testListNoExplicitFormat", "/testData/testRepos/updateSite");
        File metadataRepo = DirectorApplicationTest.getTestData("testListNoExplicitFormat", "/testData/testRepos/updateSite");
        String[] args = this.getSingleRepoArgsForListing("testListNoExplicitFormat", metadataRepo, artifactRepo, "-list", "", "", "");
        StringBuilder buffer = this.runDirectorApp("testListNoExplicitFormat", args);
        MatcherAssert.assertThat((Object)buffer.toString(), (Matcher)CoreMatchers.containsString((String)"org.eclipse.ui.examples.job=3.0.0"));
    }

    public void testUninstallIgnoresPassedInRepos() throws Exception {
        File srcRepo = DirectorApplicationTest.getTestData("14.0", "/testData/mirror/mirrorSourceRepo4");
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)DirectorApplicationTest.getAgent().getService(IArtifactRepositoryManager.class);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)DirectorApplicationTest.getAgent().getService(IMetadataRepositoryManager.class);
        DirectorApplicationTest.assertNotNull((Object)artifactManager);
        DirectorApplicationTest.assertNotNull((Object)metadataManager);
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String[] args = this.getSingleRepoUninstallArgs("14.1", srcRepo, destinationRepo, "helloworld");
        destinationRepo.mkdirs();
        StringBuilder buffer = this.runDirectorApp("14.2", args);
        DirectorApplicationTest.assertTrue((boolean)buffer.toString().contains("The installable unit helloworld has not been found."));
        artifactManager.removeRepository(srcRepo.toURI());
        metadataManager.removeRepository(srcRepo.toURI());
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testAvoidTrustPromptServiceNoUntrustedCertificates() {
        UIServices.TrustInfo trustInfo = this.getTrustInfoFor(null);
        DirectorApplicationTest.assertNotNull((Object)trustInfo);
        Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
        DirectorApplicationTest.assertNotNull((Object)trustedCertificates);
        DirectorApplicationTest.assertEquals((int)0, (int)trustedCertificates.length);
    }

    public void testAvoidTrustPromptServiceTrustsOneCertificate() {
        DummyCertificate certificate = new DummyCertificate("certificate");
        UIServices.TrustInfo trustInfo = this.getTrustInfoFor(Map.of(List.of(certificate), Set.of()));
        DirectorApplicationTest.assertNotNull((Object)trustInfo);
        Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
        DirectorApplicationTest.assertEquals((int)1, (int)trustedCertificates.length);
        DirectorApplicationTest.assertSame((Object)certificate, (Object)trustedCertificates[0]);
    }

    public void testAvoidTrustPromptServiceTrustsManyCertificates() {
        DummyCertificate certificate1 = new DummyCertificate("certificate1");
        DummyCertificate certificate2 = new DummyCertificate("certificate2");
        UIServices.TrustInfo trustInfo = this.getTrustInfoFor(Map.of(List.of(certificate1), Set.of(), List.of(certificate2), Set.of()));
        DirectorApplicationTest.assertNotNull((Object)trustInfo);
        Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
        DirectorApplicationTest.assertEquals((int)2, (int)trustedCertificates.length);
        Set keys = Collections.newSetFromMap(new IdentityHashMap());
        keys.addAll(Arrays.asList(trustedCertificates));
        DirectorApplicationTest.assertTrue((boolean)keys.contains(certificate1));
        DirectorApplicationTest.assertTrue((boolean)keys.contains(certificate2));
    }

    private UIServices.TrustInfo getTrustInfoFor(Map<List<Certificate>, Set<IArtifactKey>> untrustedChains) {
        DirectorApplication.AvoidTrustPromptService avoidTrustPromptService = new DirectorApplication.AvoidTrustPromptService();
        return avoidTrustPromptService.getTrustInfo(untrustedChains, Map.of(), Set.of(), Map.of());
    }

    private UIServices.TrustInfo getTrustInfoFor(Map<List<Certificate>, Set<IArtifactKey>> untrustedChains, Set<String> trustedCertificates) {
        DirectorApplication.AvoidTrustPromptService avoidTrustPromptService = new DirectorApplication.AvoidTrustPromptService(false, true, null, null, trustedCertificates);
        return avoidTrustPromptService.getTrustInfo(untrustedChains, Map.of(), Set.of(), Map.of());
    }

    public void testTrustPromptServiceTrustsOneCertificateReject() {
        DummyCertificate certificate = new DummyCertificate("certificate");
        UIServices.TrustInfo trustInfo = this.getTrustInfoFor(Map.of(List.of(certificate), Set.of()), Set.of());
        DirectorApplicationTest.assertNotNull((Object)trustInfo);
        Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
        DirectorApplicationTest.assertEquals((int)0, (int)trustedCertificates.length);
    }

    public void testTrustPromptServiceTrustsOneCertificateSpecificallyAccepted() {
        DummyCertificate certificate = new DummyCertificate("certificate");
        UIServices.TrustInfo trustInfo = this.getTrustInfoFor(Map.of(List.of(certificate), Set.of()), Set.of("03d66dd08835c1ca3f128cceacd1f31ac94163096b20f445ae84285bc0832d72"));
        DirectorApplicationTest.assertNotNull((Object)trustInfo);
        Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
        DirectorApplicationTest.assertEquals((int)1, (int)trustedCertificates.length);
        DirectorApplicationTest.assertSame((Object)certificate, (Object)trustedCertificates[0]);
    }

    public void testPGPSignedArtifact() throws Exception {
        File srcRepo = DirectorApplicationTest.getTestData(null, "/testData/pgp/repoPGPOK");
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)DirectorApplicationTest.getAgent().getService(IArtifactRepositoryManager.class);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)DirectorApplicationTest.getAgent().getService(IMetadataRepositoryManager.class);
        DirectorApplicationTest.assertNotNull((Object)artifactManager);
        DirectorApplicationTest.assertNotNull((Object)metadataManager);
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        String[] args = this.getSingleRepoArgs(null, srcRepo, srcRepo, destinationRepo, "blah");
        destinationRepo.mkdirs();
        StringBuilder buffer = this.runDirectorApp(null, args);
        DirectorApplicationTest.assertFalse((String)buffer.toString(), (boolean)buffer.toString().contains("failed"));
        artifactManager.removeRepository(srcRepo.toURI());
        metadataManager.removeRepository(srcRepo.toURI());
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testRejectedPGPSignedArtifact() throws Exception {
        File srcRepo = DirectorApplicationTest.getTestData(null, "/testData/pgp/repoPGPOK");
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)DirectorApplicationTest.getAgent().getService(IArtifactRepositoryManager.class);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)DirectorApplicationTest.getAgent().getService(IMetadataRepositoryManager.class);
        DirectorApplicationTest.assertNotNull((Object)artifactManager);
        DirectorApplicationTest.assertNotNull((Object)metadataManager);
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(this.getSingleRepoArgs(null, srcRepo, srcRepo, destinationRepo, "blah")));
        args.add("-tk");
        destinationRepo.mkdirs();
        StringBuilder buffer = this.runDirectorApp(null, (String[])args.toArray(String[]::new));
        DirectorApplicationTest.assertTrue((String)buffer.toString(), (boolean)buffer.toString().contains("One or more PGP keys are not trusted."));
        artifactManager.removeRepository(srcRepo.toURI());
        metadataManager.removeRepository(srcRepo.toURI());
        DirectorApplicationTest.delete(destinationRepo);
    }

    public void testSpecificallyAcceptedGPSignedArtifact() throws Exception {
        File srcRepo = DirectorApplicationTest.getTestData(null, "/testData/pgp/repoPGPOK");
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)DirectorApplicationTest.getAgent().getService(IArtifactRepositoryManager.class);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)DirectorApplicationTest.getAgent().getService(IMetadataRepositoryManager.class);
        DirectorApplicationTest.assertNotNull((Object)artifactManager);
        DirectorApplicationTest.assertNotNull((Object)metadataManager);
        File destinationRepo = new File(this.getTempFolder(), "DirectorApp Destination");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(this.getSingleRepoArgs(null, srcRepo, srcRepo, destinationRepo, "blah")));
        args.add("-tk");
        args.add("e996c670aa7f65409bf5db56139e38d90ded11f0");
        args.add("-verboseTrust");
        destinationRepo.mkdirs();
        StringBuilder buffer = this.runDirectorApp(null, (String[])args.toArray(String[]::new));
        DirectorApplicationTest.assertFalse((String)buffer.toString(), (boolean)buffer.toString().contains("failed"));
        artifactManager.removeRepository(srcRepo.toURI());
        metadataManager.removeRepository(srcRepo.toURI());
        DirectorApplicationTest.delete(destinationRepo);
    }

    private static final class DummyCertificate
    extends Certificate {
        private final String identity;

        DummyCertificate(String identity) {
            super("");
            this.identity = identity;
        }

        @Override
        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        }

        @Override
        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        }

        @Override
        public String toString() {
            return "[ " + this.identity + " ]";
        }

        @Override
        public PublicKey getPublicKey() {
            return null;
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return this.identity.getBytes(StandardCharsets.UTF_8);
        }
    }
}

