/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.director.app.IUListFormatter;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class IUListFormatterTest {
    @Test
    public void testFormat() {
        IUListFormatter format = new IUListFormatter("${id}=${id},${version},${org.eclipse.equinox.p2.name}");
        String result = format.format(Arrays.asList(IUListFormatterTest.createIU("iu1", "1.0.0", "name", null)));
        Assert.assertEquals((Object)"iu1=iu1,1.0.0,name", (Object)result);
    }

    @Test
    public void testFormat_MultipleIUs() {
        IUListFormatter format = new IUListFormatter("${id}=${version},${org.eclipse.equinox.p2.name}");
        String result = format.format(Arrays.asList(IUListFormatterTest.createIU("iu1", "1.0.0", "name", null), IUListFormatterTest.createIU("iu2", "2.0.0", "name2", null)));
        Assert.assertEquals((Object)("iu1=1.0.0,name" + System.lineSeparator() + "iu2=2.0.0,name2"), (Object)result);
    }

    @Test
    public void testFormat_UnknownFormatOption() {
        IUListFormatter format = new IUListFormatter("${id}${UNKNOWN}");
        String result = format.format(Arrays.asList(IUListFormatterTest.createIU("iu1", "1.0.0", "name", null)));
        Assert.assertEquals((Object)"iu1", (Object)result);
    }

    @Test
    public void testFormat_Malformed() {
        IUListFormatter format = new IUListFormatter("${id=${version");
        String result = format.format(Arrays.asList(IUListFormatterTest.createIU("iu1", "1.0.0", "name", null)));
        Assert.assertEquals((String)"Input must be preserved", (Object)"${id=${version", (Object)result);
    }

    public static void main(String[] args) {
        IUListFormatter format = new IUListFormatter("${id=${version");
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>(20000);
        int i = 0;
        while (i < 20000) {
            ius.add(IUListFormatterTest.createIU("iu_" + i, "1.0.0", 30));
            ++i;
        }
        long start = System.currentTimeMillis();
        format.format(ius);
        System.out.println(System.currentTimeMillis() - start);
    }

    private static IInstallableUnit createIU(String id, String version, String name, String description) {
        IInstallableUnit iu = (IInstallableUnit)Mockito.mock(IInstallableUnit.class);
        Mockito.when((Object)iu.getId()).thenReturn((Object)id);
        Mockito.when((Object)iu.getVersion()).thenReturn((Object)Version.create((String)version));
        HashMap<String, String> properties = new HashMap<String, String>(3, 1.0f);
        properties.put("org.eclipse.equinox.p2.name", name);
        properties.put("org.eclipse.equinox.p2.description", description);
        Mockito.when((Object)iu.getProperties()).thenReturn(properties);
        Mockito.when((Object)iu.getProperty(ArgumentMatchers.anyString())).thenAnswer(new MapAnswer(properties));
        Mockito.when((Object)iu.getProperty(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(new MapAnswer(properties));
        return iu;
    }

    private static IInstallableUnit createIU(String id, String version, int propCount) {
        IInstallableUnit iu = (IInstallableUnit)Mockito.mock(IInstallableUnit.class);
        Mockito.when((Object)iu.getId()).thenReturn((Object)id);
        Mockito.when((Object)iu.getVersion()).thenReturn((Object)Version.create((String)version));
        HashMap<CallSite, CallSite> properties = new HashMap<CallSite, CallSite>(propCount, 1.0f);
        int i = 0;
        while (i < propCount) {
            properties.put((CallSite)((Object)("prop_" + i)), (CallSite)((Object)("propValue_" + i)));
            ++i;
        }
        Mockito.when((Object)iu.getProperties()).thenReturn(properties);
        Mockito.when((Object)iu.getProperty(ArgumentMatchers.anyString())).thenAnswer(new MapAnswer(properties));
        Mockito.when((Object)iu.getProperty(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(new MapAnswer(properties));
        return iu;
    }

    private static final class MapAnswer<T>
    implements Answer<T> {
        private final Map<?, T> map;

        MapAnswer(Map<?, T> map) {
            this.map = map;
        }

        public T answer(InvocationOnMock arg) throws Throwable {
            return this.map.get(arg.getArguments()[0]);
        }
    }
}

