/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.equinox.internal.p2.director.OperationGenerator;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.p2.metadata.ResolvedInstallableUnit;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class OperationGenerationTest
extends AbstractProvisioningTest {
    public void testInstallUninstall() {
        IInstallableUnit a1 = OperationGenerationTest.createIU("a", Version.createOSGi((int)1, (int)0, (int)0), false);
        IInstallableUnit a2 = OperationGenerationTest.createIU("a", Version.createOSGi((int)2, (int)0, (int)0), false);
        IInstallableUnit a3 = OperationGenerationTest.createIU("a", Version.createOSGi((int)3, (int)0, (int)0), false);
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(a1);
        from.add(a2);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(a1);
        to.add(a3);
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((int)2, (int)operands.size());
    }

    public void test1() {
        IInstallableUnit a1 = OperationGenerationTest.createIU("a", Version.createOSGi((int)1, (int)0, (int)0), false);
        IInstallableUnit a2 = OperationGenerationTest.createIU("a", Version.createOSGi((int)2, (int)0, (int)0), false);
        IInstallableUnit a3 = OperationGenerationTest.createIU("a", Version.createOSGi((int)3, (int)0, (int)0), false);
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(a1);
        from.add(a3);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(a1);
        to.add(a3);
        to.add(a2);
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((int)1, (int)operands.size());
    }

    public void test2() {
        IInstallableUnit a1 = OperationGenerationTest.createIU("a", Version.createOSGi((int)1, (int)0, (int)0), false);
        IInstallableUnit a2 = OperationGenerationTest.createIU("a", Version.createOSGi((int)2, (int)0, (int)0), false);
        IInstallableUnit a3 = OperationGenerationTest.createIU("a", Version.createOSGi((int)3, (int)0, (int)0), false);
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(a1);
        from.add(a2);
        from.add(a3);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(a1);
        to.add(a3);
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((int)1, (int)operands.size());
    }

    public void testUpdate1() {
        IInstallableUnit a = OperationGenerationTest.createIU("a", Version.createOSGi((int)1, (int)0, (int)0), false);
        MetadataFactory.InstallableUnitDescription b = new MetadataFactory.InstallableUnitDescription();
        b.setId("b");
        b.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        b.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)"a", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), (int)0, null));
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(a);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)b));
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((int)1, (int)operands.size());
    }

    public void testUpdate2() {
        IInstallableUnit a1 = OperationGenerationTest.createIU("a", Version.createOSGi((int)1, (int)0, (int)0), false);
        IInstallableUnit a2 = OperationGenerationTest.createIU("a", Version.createOSGi((int)2, (int)0, (int)0), false);
        MetadataFactory.InstallableUnitDescription b = new MetadataFactory.InstallableUnitDescription();
        b.setId("b");
        b.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        b.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)"a", (VersionRange)new VersionRange("[1.0.0, 3.0.0)"), (int)0, null));
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(a1);
        from.add(a2);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)b));
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((int)3, (int)operands.size());
    }

    public void testUpdate3() {
        IInstallableUnit a1 = OperationGenerationTest.createIU("a", Version.createOSGi((int)1, (int)0, (int)0), false);
        IInstallableUnit a2 = OperationGenerationTest.createIU("a", Version.createOSGi((int)2, (int)0, (int)0), false);
        MetadataFactory.InstallableUnitDescription b = new MetadataFactory.InstallableUnitDescription();
        b.setId("b");
        b.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        b.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)"a", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), (int)0, null));
        MetadataFactory.InstallableUnitDescription c = new MetadataFactory.InstallableUnitDescription();
        c.setId("c");
        c.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        c.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)"a", (VersionRange)new VersionRange("[2.0.0, 2.3.0)"), (int)0, null));
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(a1);
        from.add(a2);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)b));
        to.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)c));
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((int)2, (int)operands.size());
    }

    public void testUpdate4() {
        IInstallableUnit a1 = OperationGenerationTest.createIU("a", Version.createOSGi((int)1, (int)0, (int)0), false);
        IInstallableUnit a2 = OperationGenerationTest.createIU("a", Version.createOSGi((int)2, (int)0, (int)0), false);
        IInstallableUnit b1 = OperationGenerationTest.createIU("b", Version.createOSGi((int)1, (int)0, (int)0), false);
        MetadataFactory.InstallableUnitDescription b2 = new MetadataFactory.InstallableUnitDescription();
        b2.setId("b");
        b2.setVersion(Version.createOSGi((int)2, (int)0, (int)0));
        b2.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)"b", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), (int)0, null));
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(a1);
        from.add(a2);
        from.add(b1);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(a1);
        to.add(a2);
        to.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)b2));
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((int)1, (int)operands.size());
    }

    public void testUpdate5() {
        IInstallableUnit a1 = OperationGenerationTest.createIU("a", Version.createOSGi((int)1, (int)0, (int)0), false);
        IInstallableUnit a2 = OperationGenerationTest.createIU("a", Version.createOSGi((int)2, (int)0, (int)0), false);
        IInstallableUnit b1 = OperationGenerationTest.createIU("b", Version.createOSGi((int)1, (int)0, (int)0), false);
        MetadataFactory.InstallableUnitDescription b2 = new MetadataFactory.InstallableUnitDescription();
        b2.setId("b");
        b2.setVersion(Version.createOSGi((int)2, (int)0, (int)0));
        b2.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)"b", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), (int)0, null));
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(a1);
        from.add(a2);
        from.add(b1);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(a1);
        to.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)b2));
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((int)2, (int)operands.size());
    }

    public void test248468b() {
        String id = "myBundle";
        IUpdateDescriptor update = this.createUpdateDescriptor(id, Version.create((String)"1.0.0"));
        IInstallableUnit one = OperationGenerationTest.createIU(id, Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update, null);
        IUpdateDescriptor update2 = this.createUpdateDescriptor(id, Version.create((String)"2.0.0"));
        IInstallableUnit two = OperationGenerationTest.createIU(id, Version.create((String)"2.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update2, null);
        IUpdateDescriptor update3 = this.createUpdateDescriptor(id, Version.create((String)"3.0.0"));
        IInstallableUnit three = OperationGenerationTest.createIU(id, Version.create((String)"3.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update3, null);
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)one, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        from.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)two, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        from.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)three, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)three, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        for (Operand operand : operands) {
            OperationGenerationTest.assertNotSame((String)"3.0", (Object)three, (Object)((InstallableUnitOperand)operand).first());
            OperationGenerationTest.assertNotSame((String)"3.0.1", (Object)three, (Object)((InstallableUnitOperand)operand).second());
        }
        OperationGenerationTest.assertEquals("3.1", one, ((InstallableUnitOperand)operands.get(0)).first());
        OperationGenerationTest.assertNull((String)"3.2", (Object)((InstallableUnitOperand)operands.get(0)).second());
        OperationGenerationTest.assertEquals("3.3", two, ((InstallableUnitOperand)operands.get(1)).first());
        OperationGenerationTest.assertNull((String)"3.4", (Object)((InstallableUnitOperand)operands.get(1)).second());
    }

    public void test248468d() {
        String id = "myBundle";
        IUpdateDescriptor update = this.createUpdateDescriptor(id, Version.create((String)"1.0.0"));
        IInstallableUnit one = OperationGenerationTest.createIU(id, Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update, null);
        update = this.createUpdateDescriptor(id, Version.create((String)"2.0.0"));
        IInstallableUnit two = OperationGenerationTest.createIU(id, Version.create((String)"2.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update, null);
        IUpdateDescriptor update3 = this.createUpdateDescriptor(id, Version.create((String)"3.0.0"));
        IInstallableUnit three = OperationGenerationTest.createIU("anotherBundle", Version.create((String)"3.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update3, null);
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)one, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        from.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)two, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)two, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        to.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)three, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        for (Operand operand : operands) {
            OperationGenerationTest.assertNotSame((String)"2.0", (Object)two, (Object)((InstallableUnitOperand)operand).first());
            OperationGenerationTest.assertNotSame((String)"2.1", (Object)two, (Object)((InstallableUnitOperand)operand).second());
        }
        OperationGenerationTest.assertEquals((String)"2.2", (int)1, (int)operands.size());
        OperationGenerationTest.assertEquals("2.4", one, ((InstallableUnitOperand)operands.get(0)).first());
        OperationGenerationTest.assertEquals("2.5", three, ((InstallableUnitOperand)operands.get(0)).second());
    }

    public void test248468c() {
        String id = "myBundle";
        IUpdateDescriptor update = this.createUpdateDescriptor(id, Version.create((String)"1.0.0"));
        IInstallableUnit one = OperationGenerationTest.createIU(id, Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update, null);
        update = this.createUpdateDescriptor(id, Version.create((String)"2.0.0"));
        IInstallableUnit two = OperationGenerationTest.createIU(id, Version.create((String)"2.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update, null);
        IUpdateDescriptor update3 = MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)new VersionRange(Version.createOSGi((int)2, (int)0, (int)0), true, Version.createOSGi((int)3, (int)0, (int)0), false), (int)1, (String)"desc");
        IInstallableUnit three = OperationGenerationTest.createIU("anotherBundle", Version.create((String)"3.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update3, null);
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)one, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        from.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)two, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)two, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        to.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)three, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        for (Operand operand : operands) {
            OperationGenerationTest.assertNotSame((String)"2.0", (Object)two, (Object)((InstallableUnitOperand)operand).first());
            OperationGenerationTest.assertNotSame((String)"2.1", (Object)two, (Object)((InstallableUnitOperand)operand).second());
        }
        OperationGenerationTest.assertEquals((String)"2.2", (int)2, (int)operands.size());
        OperationGenerationTest.assertNull((String)"2.3", (Object)((InstallableUnitOperand)operands.get(0)).first());
        OperationGenerationTest.assertEquals("2.4", three, ((InstallableUnitOperand)operands.get(0)).second());
        OperationGenerationTest.assertEquals("2.5", one, ((InstallableUnitOperand)operands.get(1)).first());
        OperationGenerationTest.assertNull((String)"2.6", (Object)((InstallableUnitOperand)operands.get(1)).second());
    }

    public void test248468() {
        String id = "myBundle";
        IUpdateDescriptor update = this.createUpdateDescriptor(id, Version.create((String)"1.0.0"));
        IInstallableUnit one = OperationGenerationTest.createIU(id, Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update, null);
        update = this.createUpdateDescriptor(id, Version.create((String)"2.0.0"));
        IInstallableUnit two = OperationGenerationTest.createIU(id, Version.create((String)"2.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, update, null);
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>();
        from.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)one, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        from.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)two, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        to.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)two, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((String)"1.0", (int)1, (int)operands.size());
        OperationGenerationTest.assertEquals("1.1", one, ((InstallableUnitOperand)operands.get(0)).first());
        OperationGenerationTest.assertNull((String)"1.2", (Object)((InstallableUnitOperand)operands.get(0)).second());
    }

    public void testConfigurationChange1() {
        String id = "myBundle";
        String cuId = "cu";
        IInstallableUnit anIU = OperationGenerationTest.createIU(id, Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, null);
        IInstallableUnit anotherIU = OperationGenerationTest.createIU("misc", Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, null);
        IInstallableUnit anotherIU2 = OperationGenerationTest.createIU("misc2", Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, null);
        IInstallableUnitFragment cu1 = OperationGenerationTest.createIUFragment(anIU, cuId, Version.create((String)"1.0.0"));
        IInstallableUnitFragment cu2 = OperationGenerationTest.createIUFragment(anIU, cuId, Version.create((String)"2.0.0"));
        ArrayList<Object> from = new ArrayList<Object>();
        ResolvedInstallableUnit fromResolved = (ResolvedInstallableUnit)MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[]{cu1});
        from.add(fromResolved);
        from.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anotherIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        IInstallableUnit toResolved = MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[]{cu2});
        to.add(toResolved);
        to.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anotherIU2, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]));
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((String)"1.0", (int)3, (int)operands.size());
        this.assertContainsConfigurationChange("2.0", operands);
        this.assertContainsInstallableUnitOperand("3.0", operands, new InstallableUnitOperand((IInstallableUnit)fromResolved, toResolved));
    }

    private void assertContainsInstallableUnitOperand(String message, List<Operand> operands, InstallableUnitOperand operand) {
        for (Operand op : operands) {
            InstallableUnitOperand cmp;
            if (!(op instanceof InstallableUnitOperand) || (cmp = (InstallableUnitOperand)op).first() == null || !cmp.first().equals((Object)operand.first()) || cmp.second() == null || !cmp.second().equals((Object)operand.second())) continue;
            return;
        }
        OperationGenerationTest.fail((String)message);
    }

    public void testConfigurationChange2() {
        String id = "myBundle";
        String cuId = "cu";
        IInstallableUnit anIU = OperationGenerationTest.createIU(id, Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, null);
        IInstallableUnitFragment cu2 = OperationGenerationTest.createIUFragment(anIU, cuId, Version.create((String)"2.0.0"));
        ArrayList<ResolvedInstallableUnit> from = new ArrayList<ResolvedInstallableUnit>();
        ResolvedInstallableUnit fromResolved = (ResolvedInstallableUnit)MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]);
        from.add(fromResolved);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        IInstallableUnit toResolved = MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[]{cu2});
        to.add(toResolved);
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((String)"1.0", (int)1, (int)operands.size());
        this.assertContainsInstallableUnitOperand("3.0", operands, new InstallableUnitOperand((IInstallableUnit)fromResolved, toResolved));
    }

    public void testConfigurationChange3() {
        String id = "myBundle";
        String cuId = "cu";
        IInstallableUnit anIU = OperationGenerationTest.createIU(id, Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, null);
        IInstallableUnitFragment cu2 = OperationGenerationTest.createIUFragment(anIU, cuId, Version.create((String)"2.0.0"));
        ArrayList<ResolvedInstallableUnit> from = new ArrayList<ResolvedInstallableUnit>();
        ResolvedInstallableUnit fromResolved = (ResolvedInstallableUnit)MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[]{cu2});
        from.add(fromResolved);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        IInstallableUnit toResolved = MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[0]);
        to.add(toResolved);
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((String)"1.0", (int)1, (int)operands.size());
        this.assertContainsInstallableUnitOperand("3.0", operands, new InstallableUnitOperand((IInstallableUnit)fromResolved, toResolved));
    }

    public void testConfigurationChange4() {
        String id = "myBundle";
        String cuId = "cu";
        IInstallableUnit anIU = OperationGenerationTest.createIU(id, Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, null);
        IInstallableUnitFragment cu2 = OperationGenerationTest.createIUFragment(anIU, cuId, Version.create((String)"2.0.0"));
        ArrayList<ResolvedInstallableUnit> from = new ArrayList<ResolvedInstallableUnit>();
        ResolvedInstallableUnit fromResolved = (ResolvedInstallableUnit)MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[]{cu2});
        from.add(fromResolved);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        IInstallableUnit toResolved = MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[]{cu2});
        to.add(toResolved);
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((String)"1.0", (int)0, (int)operands.size());
    }

    public void testConfigurationChange5() {
        String id = "myBundle";
        String cuId = "cu";
        IInstallableUnit anIU = OperationGenerationTest.createIU(id, Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, null);
        IInstallableUnitFragment cu2 = OperationGenerationTest.createIUFragment(anIU, cuId, Version.create((String)"2.0.0"));
        IInstallableUnitFragment cu1 = OperationGenerationTest.createIUFragment(anIU, cuId, Version.create((String)"1.0.0"));
        ArrayList<ResolvedInstallableUnit> from = new ArrayList<ResolvedInstallableUnit>();
        ResolvedInstallableUnit fromResolved = (ResolvedInstallableUnit)MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[]{cu1, cu2});
        from.add(fromResolved);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        IInstallableUnit toResolved = MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[]{cu2, cu1});
        to.add(toResolved);
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((String)"1.0", (int)0, (int)operands.size());
    }

    public void testConfigurationChange6() {
        String id = "myBundle";
        String cuId = "cu";
        IInstallableUnit anIU = OperationGenerationTest.createIU(id, Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, null);
        IInstallableUnitFragment cu2 = OperationGenerationTest.createIUFragment(anIU, cuId, Version.create((String)"2.0.0"));
        IInstallableUnitFragment cu1 = OperationGenerationTest.createIUFragment(anIU, cuId, Version.create((String)"1.0.0"));
        IInstallableUnitFragment cu3 = OperationGenerationTest.createIUFragment(anIU, cuId, Version.create((String)"3.0.0"));
        ArrayList<ResolvedInstallableUnit> from = new ArrayList<ResolvedInstallableUnit>();
        ResolvedInstallableUnit fromResolved = (ResolvedInstallableUnit)MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[]{cu1, cu2});
        from.add(fromResolved);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>();
        IInstallableUnit toResolved = MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)anIU, (IInstallableUnitFragment[])new IInstallableUnitFragment[]{cu1, cu3});
        to.add(toResolved);
        ProvisioningPlan plan = (ProvisioningPlan)this.getEngine().createPlan(this.createProfile("temp"), null);
        new OperationGenerator((IProvisioningPlan)plan).generateOperation(from, to);
        List<Operand> operands = Arrays.asList(plan.getOperands());
        OperationGenerationTest.assertEquals((String)"1.0", (int)1, (int)operands.size());
        this.assertContainsInstallableUnitOperand("3.0", operands, new InstallableUnitOperand((IInstallableUnit)fromResolved, toResolved));
    }

    public void assertContains(String message, Object[] searched, Object expected) {
        Object[] objectArray = searched;
        int n = searched.length;
        int n2 = 0;
        while (n2 < n) {
            Object search = objectArray[n2];
            if (search.equals(expected)) {
                return;
            }
            ++n2;
        }
        OperationGenerationTest.fail((String)(message + "Can't find " + String.valueOf(expected)));
    }

    public void assertContainsConfigurationChange(String message, List<Operand> operands) {
        for (Operand operand : operands) {
            InstallableUnitOperand op;
            if (!(operand instanceof InstallableUnitOperand) || (op = (InstallableUnitOperand)operand).first() == null || !op.first().equals((Object)op.second())) continue;
            return;
        }
        OperationGenerationTest.fail((String)(message + " No configuration change operand found"));
    }
}

