/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ReplacePlanTest
extends AbstractProvisioningTest {
    IInstallableUnit f1;
    IInstallableUnit f1_1;
    IInstallableUnit f1_4;
    IInstallableUnit frag1;
    IInstallableUnit frag1_1;
    IInstallableUnit frag1_4;
    IInstallableUnit fa;
    IInstallableUnit fap;
    IDirector director;
    IPlanner planner;
    IProfile profile;

    @Override
    protected void setUp() throws Exception {
        this.f1 = ReplacePlanTest.createIU("f1", DEFAULT_VERSION, true);
        this.f1_1 = ReplacePlanTest.createIU("f1", Version.createOSGi((int)1, (int)1, (int)0), true);
        this.f1_4 = ReplacePlanTest.createIU("f1", Version.createOSGi((int)1, (int)4, (int)0), true);
        this.frag1 = ReplacePlanTest.createIUFragment(this.f1, "frag1", this.f1.getVersion());
        this.frag1_1 = ReplacePlanTest.createIUFragment(this.f1, "frag1", this.f1_1.getVersion());
        this.frag1_4 = ReplacePlanTest.createIUFragment(this.f1, "frag1", this.f1_4.getVersion());
        IRequirement[] requires = ReplacePlanTest.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "f1", new VersionRange("[1.0.0, 1.3.0)"));
        this.fa = ReplacePlanTest.createIU("fa", requires, false);
        requires = ReplacePlanTest.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "f1", new VersionRange("[1.0.0, 1.4.0)"));
        this.fap = ReplacePlanTest.createIU("fa", Version.createOSGi((int)1, (int)1, (int)0), requires, NO_PROPERTIES, false);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.f1, this.fa, this.frag1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.director = ReplacePlanTest.createDirector();
        this.planner = ReplacePlanTest.createPlanner();
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{this.fa, this.frag1});
        this.director.provision((IProfileChangeRequest)request, null, null);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.f1_1, this.f1_4, this.frag1_1, this.frag1_4});
    }

    public void testSimpleReplace() {
        IInstallableUnit[] oldUnits = new IInstallableUnit[]{this.fa};
        IInstallableUnit[] newUnits = new IInstallableUnit[]{this.fap};
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.removeInstallableUnits(oldUnits);
        request.addInstallableUnits(newUnits);
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)request, new ProvisioningContext(ReplacePlanTest.getAgent()), null);
        ReplacePlanTest.assertTrue((String)"1.0", (boolean)plan.getStatus().isOK());
        ReplacePlanTest.assertProfileContainsAll("1.1", this.profile, oldUnits);
        IStatus result = ReplacePlanTest.createEngine().perform(plan, null);
        ReplacePlanTest.assertTrue((String)"1.2", (boolean)result.isOK());
        ReplacePlanTest.assertProfileContainsAll("1.3", this.profile, newUnits);
    }

    public void testReplaceFragment() {
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.removeInstallableUnits(new IInstallableUnit[]{this.frag1});
        request.addInstallableUnits(new IInstallableUnit[]{this.frag1_4});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)request, new ProvisioningContext(ReplacePlanTest.getAgent()), null);
        ReplacePlanTest.assertTrue((String)"1.0", (boolean)plan.getStatus().isOK());
    }
}

