/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.directorywatcher;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryWatcher;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.junit.Assert;

public class DirectoryWatcherTest
extends AbstractProvisioningTest {
    public DirectoryWatcherTest(String name) {
        super(name);
    }

    public void testCreateDirectoryWatcherNullDirectory() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            DirectoryWatcher directoryWatcher = new DirectoryWatcher(null);
        });
    }

    public void testCreateDirectoryWatcherOneDirectory() throws Exception {
        URL base = TestActivator.getContext().getBundle().getEntry("/testData/directorywatcher1");
        File folder = new File(FileLocator.toFileURL((URL)base).getPath());
        DirectoryWatcher watcher = new DirectoryWatcher(folder);
        watcher.start();
        watcher.stop();
    }

    public void testCreateDirectoryWatcherProps() throws Exception {
        URL base = TestActivator.getContext().getBundle().getEntry("/testData/directorywatcher1");
        File folder = new File(FileLocator.toFileURL((URL)base).getPath());
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("eclipse.p2.directory.watcher.dir", folder.getAbsolutePath());
        DirectoryWatcher watcher = new DirectoryWatcher(props, TestActivator.getContext());
        watcher.start();
        watcher.stop();
    }

    public void testDirectoryWatcherListener() throws Exception {
        URL base = TestActivator.getContext().getBundle().getEntry("/testData/directorywatcher1");
        File folder = new File(FileLocator.toFileURL((URL)base).getPath());
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("eclipse.p2.directory.watcher.dir", folder.getAbsolutePath());
        DirectoryWatcher watcher = new DirectoryWatcher(props, TestActivator.getContext());
        final List list = Collections.synchronizedList(new ArrayList());
        DirectoryChangeListener listener = new DirectoryChangeListener(){

            public boolean added(File file) {
                if (file.getName().equals("CVS")) {
                    return false;
                }
                list.add(file);
                return true;
            }

            public boolean changed(File file) {
                return false;
            }

            public boolean removed(File file) {
                if (file.getName().equals("CVS")) {
                    return false;
                }
                list.remove(file);
                return true;
            }

            public boolean isInterested(File file) {
                return true;
            }

            public Long getSeenFile(File file) {
                return null;
            }
        };
        watcher.addListener(listener);
        watcher.poll();
        DirectoryWatcherTest.assertEquals((int)2, (int)list.size());
    }
}

