/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.directorywatcher;

import java.io.File;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.directorywatcher.AbstractDirectoryWatcherTest;
import org.eclipse.equinox.p2.tests.directorywatcher.TestRepositoryWatcher;

public class ProfileSynchronizerTest
extends AbstractDirectoryWatcherTest {
    public ProfileSynchronizerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ProfileSynchronizerTest.class);
    }

    public void test() {
    }

    public void _testPlatformFilter() {
        String base = "/testData/profileSynchronizer/";
        String[] extensions = new String[]{"bbb_1.0.0.jar", "bbb.linux_1.0.0.jar", "bbb.win32_1.0.0.jar"};
        HashSet<File> jars = new HashSet<File>();
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            jars.add(ProfileSynchronizerTest.getTestData("0.99", base + extension));
            ++n2;
        }
        File folder = this.getTempFolder();
        this.toRemove.add(folder);
        for (File next : jars) {
            ProfileSynchronizerTest.copy("1.0 " + next.getAbsolutePath(), next, new File(folder, next.getName()));
        }
        TestRepositoryWatcher watcher = TestRepositoryWatcher.createWatcher(folder);
        ProfileSynchronizerTest.assertEquals((String)"2.0", (int)0, (int)watcher.getInstallableUnits().length);
        ProfileSynchronizerTest.assertEquals((String)"2.1", (int)0, (int)watcher.getArtifactKeys().length);
        watcher.poll();
        HashSet<String> expected = new HashSet<String>();
        expected.add("bbb");
        String os = System.getProperty("osgi.os");
        if ("win32".equals(os)) {
            expected.add("bbb.win32");
        } else if ("linux".equals(os)) {
            expected.add("bbb.linux");
        }
        IInstallableUnit[] ius = watcher.getInstallableUnits();
        ProfileSynchronizerTest.assertEquals((String)"3.0", (int)expected.size(), (int)ius.length);
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n3 = ius.length;
        int n4 = 0;
        while (n4 < n3) {
            IInstallableUnit iu = iInstallableUnitArray[n4];
            ProfileSynchronizerTest.assertTrue((String)("3.1 " + iu.getId()), (boolean)expected.contains(iu.getId()));
            ++n4;
        }
        ProfileSynchronizerTest.assertEquals((String)"3.2", (int)expected.size(), (int)watcher.getArtifactKeys().length);
    }

    public void _testMultipleVersions() {
        File one = ProfileSynchronizerTest.getTestData("0.1", "/testData/profileSynchronizer/ccc_1.0.0.jar");
        File two = ProfileSynchronizerTest.getTestData("0.2", "/testData/profileSynchronizer/ccc_2.0.0.jar");
        File folder = this.getTempFolder();
        this.toRemove.add(folder);
        ProfileSynchronizerTest.copy("1.0", one, new File(folder, one.getName()));
        ProfileSynchronizerTest.copy("1.1", two, new File(folder, two.getName()));
        TestRepositoryWatcher watcher = TestRepositoryWatcher.createWatcher(folder);
        ProfileSynchronizerTest.assertEquals((String)"2.0", (int)0, (int)watcher.getInstallableUnits().length);
        ProfileSynchronizerTest.assertEquals((String)"2.1", (int)0, (int)watcher.getArtifactKeys().length);
        watcher.poll();
        IInstallableUnit[] ius = watcher.getInstallableUnits();
        IArtifactKey[] artifacts = watcher.getArtifactKeys();
        ProfileSynchronizerTest.assertEquals((String)"3.0", (int)1, (int)ius.length);
        ProfileSynchronizerTest.assertEquals((String)"3.1", (String)"ccc", (String)ius[0].getId());
        ProfileSynchronizerTest.assertEquals((String)"3.2", (Object)Version.create((String)"2.0.0"), (Object)ius[0].getVersion());
        ProfileSynchronizerTest.assertEquals((String)"4.0", (int)1, (int)artifacts.length);
    }
}

