/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.core.AgentLocation;
import org.eclipse.equinox.internal.p2.core.ProvisioningAgent;
import org.eclipse.equinox.internal.p2.engine.phases.CertificateChecker;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.repository.DefaultPGPPublicKeyService;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;

public class CertificateCheckerTest
extends AbstractProvisioningTest {
    private static final String PGP_SIGNER1_PUBLIC_KEY = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\n=JYpC\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String PGP_SIGNER1_SIGNATURE = "-----BEGIN PGP SIGNATURE-----\n\niQHRBAABCAA7FiEE6ZbGcKp/ZUCb9dtWE5442Q3tEfAFAmB4Bf8dHHNpZ25lcjFA\nZmFrZXVzZXIuZWNsaXBzZS5vcmcACgkQE5442Q3tEfBPuAwAhE4zA7BswKFhEtzm\nDS3EbyRr/U13sV01YxqGtxYDCfrOt8TGVPXJSvo0AVP4vLFc5b+0jtVFoarFJNBu\nxhbVuyC72YdqudNbncSlW6KG5SgeWIM//ThKfl95pOWRWvJEoKJhmDwbDqhZYtL5\nSECegnWGtGx/klFtZihzHYJE/nfSnhySDaz5lCvXFFYRhIbNmNm2Yq7ztCOsN4Ys\n3uN+GEdoXGvv1DFg/xZPvwCOhZGsSQfkl1jmUwVltgKrw9OCFbdfYz7H6dbGWhRu\n2XpuKxPXGavKfpSvssVQIZ6aWi5W6wp5lZAQQddZvYAv3Gi5CZZcUT7ayFJYdD23\np9jz76G7MXm0f0uNT9B57T72QryokUIEIJYsCb6lNjWUQB4cd0+JesM7sHwweOQ3\n7iTFc+WgVJkP0e695mm1tcvtQHUPbIItYJUsndyLgGInzglxN8+F4U4k8uapydI9\nRmV2NVAifYp8z95Am5AnlG8lqjwrWk5bMbJH82QsQESrNT/h\n=8Vrn\n-----END PGP SIGNATURE-----\n";
    private static final String PGP_SIGNER2_PUBLIC_KEY = "-----BEGIN PGP PUBLIC KEY BLOCK-----\r\n\r\nmQINBGHUyxYBEADATeNx4XA4H2fP9mD5xwlIyh7qvHLezgXpqCwNS9ATqBwnfrCV\r\n06a+pfSLsLoXrP/sdaB5WhijfuxTis18RMfoDVwGMRqyD2GiBCl2vwJDg3BUwHnc\r\nH7W6XkWKO7dkPmF+TUbD3cTWZ7cvrPmMjinmXaq8htuktGuE2VEGZRnuG1m+ChDM\r\nPnSb1ioFS2+MJv13P2fagVk2qC95DkPJGpMk3CY3ghLDEaY/KaJl+8axAlUUUk9N\r\nd3k/KVxxf5k3g26EVQkWWgH2mmolptGO101xW64iked97Cy4NK2yafOF/wmpsavx\r\nPGpOewnDgAJBBPkum6mPH0vcOZgxmLyh4uqfPfr3IaBQlbJLN2dXaDsV83j5t1wZ\r\n2qxOPcWBfORm6W7dC0TQgCXbEG0geMBpJtvnMX83Q2ORqDpjbHRJsV2k+8NxaXON\r\npYXGr+Lj/9n0xfNEDXhCdGab0XP2tVZ5jfr2OQ5dAomEaPqK5Kq7akoWMddpDLNC\r\nG4IvH8G0cxwruJk00uwd6Nd2NVqVMRYCsBbA89VanUnutLUIpVnnOAetlX9blXHO\r\nJtmiCPGgHyp+iYGhKYVzfuZQyFhonbi0AhidJDvbHsoLT3p4Mcog1B9y6MODBE7R\r\njwrU+qMqYsYeFhGYKbYyXv9TfEyUvtCQ/GnTtRJAQyicFdOdbK37WecS6QARAQAB\r\ntDdFY2xpcHNlIHAyIHRlc3QgU2lnbmVyIDIgPHNpZ25lcjJAZmFrZXVzZXIuZWNs\r\naXBzZS5vcmc+iQJYBBMBCABCFiEEzZ1aK4a8T+GDlFHh4vaU9BsKs3AFAmHUyxYC\r\nGwMFCQPCZwAFCwkIBwIDIgIBBhUKCQgLAgQWAgMBAh4HAheAAAoJEOL2lPQbCrNw\r\nwH4QAIiCaw1mREgt4ldz7hQvmGxdMuQwVKZPzbOIAlYbZBo0q9SmeMf/CBCO90hg\r\nLFmJmsZV4KUU5NKI7UwkDVrpUCl00Ok6+gtiUTId2tRcwXI+25I478VX27j6OkQj\r\n7Xr6giv8cn8nstt5CF6xxeqrxvpmnZC0u30jE6CL6SdXSd0vViFDPQj3KgGJCRc9\r\nSt+LHB3XJTsadihzQnscqI4E2i5Z3Uj1GogqxtR59M1NAXubl5dySM0qHhwn8O+6\r\nlcgCCeuyMLLde1M1v8w07jdRUM+IFqHrRnE89EPH3MQeZbQ3UfFXK2r7wx2BJCqL\r\nIrtn68kz834ByKchGR6DqaAw0q+iF2QkgzYxpwai41BgmtUCYnj+HxQNIF4KTzDe\r\nnd8mDAPWttGCoVuV2Tyu9peYOaqyAZ2PZwUEH5MqihPCbenU17RLXzRu/IT/SH47\r\nNGrN3yKGgLZr2EVWPWFibpoxP4G4NUCHsY75uiL2EWPVSjK/+OOeHIE5k3U3lYwB\r\n7clhBwMkIhQHJ+a0SHRkKixkwrQDw4veKY4LaD0NCBLHFoV5L9orH1ToGM729kr/\r\n+4I1VQFkL3KvfLjmRbTUgwHeqEquQ96JtqowbNwlpujfHXQKDNsuiKGP5OazXll5\r\nsH2CR7e4ePqhhzxjLvi9e/79Khq+08eqllS3rs06EXEAJYTo\r\n=807V\r\n-----END PGP PUBLIC KEY BLOCK-----\r\n";
    private static final String PGP_SIGNER2_SIGNATURE = "-----BEGIN PGP SIGNATURE-----\n\niQIzBAABCAAdFiEEzZ1aK4a8T+GDlFHh4vaU9BsKs3AFAmHUy4UACgkQ4vaU9BsK\ns3DjuhAAvlCtqhK/7/aAG0/cXtlpu0fPC176OmEmBGTjCsrGdWwuRHsqXbLnMBVZ\n0D1m38MDvuYZfJuP7arw7USKp+Jy54Bv/YwvHLl74YTx1BN9hAN9QvyLxLZOjdm1\n/ipiWUuUgGa/brxEZNQqSR0w17TqXkIJHeFFS3T/rNH/Ckom5vQhAEm9HwJYeGdt\ntJ5BUl7BS1rrEOs+xmzqLu6AaERREc5gGRniJe7aP2Ke+/wL6oOLG3v/6vsJSM2e\nt+Olo4Ugc6JbdNrwvTO8kkTxsi0gp2CPhKl3RZVnbGoe4tXHawmk2V3eVTa0w6iP\nARPJ/xH2dDsRi4Kz3OkcyQOI24jGmaqpUrx3+f2BnEbcVs4cHIJc+O2gh1WUz6uY\nZw7qtK0W3H+E7RuJLCScgasPZZPBzyA6B3o2J3bfXnG5r41aJEuiq3otgllrBakG\nu7fX00h8lylgRrlCb4mquZxxRsrl+ac6U5eYdDMkK5VNkXgrus8FedIh3vmqI7RR\nou9GEjho4kebt1Y1yTAQnxWBtTUG2hFt6VirKydI7+ZcCZmbD9lrZT6xVQOCkyUQ\nCwy7vNPWkpMBBRVLoaThD2+7znDpb6wNYf9mDCcCK8tyuVCDSYEFX6jlqv1yfpNl\nQlYE1biLAHl09NH397Ta/9cWdfu68I7Mv4Ev2zu45OGa83h820M=\n=9Ha/\n-----END PGP SIGNATURE-----\n";
    CertificateChecker checker;
    CertificateTestService serviceUI;
    File unsigned;
    private ProvisioningAgent testAgent;
    private Path agentLocation;

    @Override
    protected void setUp() throws Exception {
        this.serviceUI = new CertificateTestService();
        this.testAgent = new ProvisioningAgent();
        this.testAgent.registerService(UIServices.SERVICE_NAME, (Object)this.serviceUI);
        this.agentLocation = Files.createTempDirectory("certificateTest", new FileAttribute[0]);
        this.testAgent.setLocation(this.agentLocation.toUri());
        this.testAgent.setBundleContext(TestActivator.getContext());
        this.checker = new CertificateChecker((IProvisioningAgent)this.testAgent);
        PGPPublicKeyService keyService = (PGPPublicKeyService)this.testAgent.getService(PGPPublicKeyService.class);
        if (keyService instanceof DefaultPGPPublicKeyService) {
            ((DefaultPGPPublicKeyService)keyService).setKeyServers(Set.of());
        }
        try {
            this.unsigned = TestData.getFile("CertificateChecker", "unsigned.jar");
        }
        catch (IOException e) {
            CertificateCheckerTest.fail("0.99", e);
        }
        CertificateCheckerTest.assertNotNull((String)"1.0", (Object)this.unsigned);
        CertificateCheckerTest.assertTrue((String)"1.0", (boolean)this.unsigned.exists());
    }

    @Override
    protected void tearDown() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> walk = Files.walk(this.agentLocation, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testPolicyAllow() {
        try {
            this.serviceUI.unsignedReturnValue = false;
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "allow");
            this.checker.add(Map.of(new ArtifactDescriptor((IArtifactKey)new ArtifactKey("what", "ever", Version.create((String)"1"))), this.unsigned));
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertEquals((String)"1.0", (int)0, (int)result.getSeverity());
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    public void testPolicyFail() {
        try {
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "fail");
            this.checker.add(Map.of(new ArtifactDescriptor((IArtifactKey)new ArtifactKey("what", "ever", Version.create((String)"1"))), this.unsigned));
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertEquals((String)"1.0", (int)4, (int)result.getSeverity());
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    public void testPolicyPromptSuccess() {
        try {
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "prompt");
            this.serviceUI.unsignedReturnValue = true;
            this.checker.add(Map.of(new ArtifactDescriptor((IArtifactKey)new ArtifactKey("what", "ever", Version.create((String)"1"))), this.unsigned));
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertEquals((String)"1.0", (int)0, (int)result.getSeverity());
            CertificateCheckerTest.assertTrue((String)"1.1", (boolean)this.serviceUI.wasPrompted);
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    public void testPolicyDefault() {
        System.getProperties().remove("eclipse.p2.unsignedPolicy");
        this.serviceUI.unsignedReturnValue = true;
        this.checker.add(Map.of(new ArtifactDescriptor((IArtifactKey)new ArtifactKey("what", "ever", Version.create((String)"1"))), this.unsigned));
        IStatus result = this.checker.start();
        CertificateCheckerTest.assertEquals((String)"1.0", (int)0, (int)result.getSeverity());
        CertificateCheckerTest.assertTrue((String)"1.1", (boolean)this.serviceUI.wasPrompted);
    }

    public void testPolicyPromptCancel() {
        try {
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "prompt");
            this.serviceUI.unsignedReturnValue = false;
            this.checker.add(Map.of(new ArtifactDescriptor((IArtifactKey)new ArtifactKey("what", "ever", Version.create((String)"1"))), this.unsigned));
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertEquals((String)"1.0", (int)8, (int)result.getSeverity());
            CertificateCheckerTest.assertTrue((String)"1.1", (boolean)this.serviceUI.wasPrompted);
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    public void testBug291049() {
        try {
            this.testAgent.registerService(UIServices.SERVICE_NAME, null);
            this.checker.add(Map.of(new ArtifactDescriptor((IArtifactKey)new ArtifactKey("what", "ever", Version.create((String)"1"))), this.unsigned));
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "prompt");
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertTrue((String)"1.0", (boolean)result.isOK());
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    public void testPGPSignedArtifactUntrustedKey() throws IOException, ProvisionException {
        try {
            this.testAgent.registerService("FORCED_SELF", (Object)"_SELF_");
            this.testAgent.registerService(IAgentLocation.SERVICE_NAME, (Object)new AgentLocation(Files.createTempDirectory(CertificateCheckerTest.class.getName() + "testPGPSignedArtifactUntrustedKey-profile", new FileAttribute[0]).toUri()));
            ((IProfileRegistry)this.testAgent.getService(IProfileRegistry.class)).addProfile("_SELF_");
            this.unsigned = TestData.getFile("pgp/repoPGPOK/plugins", "blah_1.0.0.123456.jar");
            ArtifactDescriptor artifactDescriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("what", "ever", Version.create((String)"1")));
            artifactDescriptor.addProperties(Map.of("pgp.signatures", PGP_SIGNER1_SIGNATURE, "pgp.publicKeys", PGP_SIGNER1_PUBLIC_KEY));
            this.checker.add(Map.of(artifactDescriptor, this.unsigned));
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "prompt");
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertFalse((boolean)result.isOK());
            CertificateCheckerTest.assertTrue((boolean)this.serviceUI.wasPrompted);
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    public void testPGPSignedArtifactTrustedKeyInProvideCapability() throws IOException {
        try {
            this.unsigned = TestData.getFile("pgp/repoPGPOK/plugins", "blah_1.0.0.123456.jar");
            ArtifactDescriptor artifactDescriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("what", "ever", Version.create((String)"1")));
            artifactDescriptor.addProperties(Map.of("pgp.signatures", PGP_SIGNER2_SIGNATURE, "pgp.publicKeys", PGP_SIGNER2_PUBLIC_KEY));
            this.checker.add(Map.of(artifactDescriptor, this.unsigned));
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "prompt");
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertTrue((boolean)result.isOK());
            CertificateCheckerTest.assertFalse((boolean)this.serviceUI.wasPrompted);
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    class CertificateTestService
    extends UIServices {
        public boolean unsignedReturnValue = true;
        public boolean wasPrompted = false;

        CertificateTestService() {
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location) {
            return null;
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location, UIServices.AuthenticationInfo previousInfo) {
            return null;
        }

        public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChain, String[] unsignedDetail) {
            this.wasPrompted = true;
            return new UIServices.TrustInfo(Collections.emptyList(), Collections.emptyList(), false, this.unsignedReturnValue);
        }
    }
}

