/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.engine.CollectEvent;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.ParameterizedProvisioningAction;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.junit.Assert;

public class PhaseTest
extends AbstractProvisioningTest {
    private IEngine engine;

    public PhaseTest(String name) {
        super(name);
    }

    public PhaseTest() {
        super("");
    }

    @Override
    protected void setUp() throws Exception {
        this.engine = this.getEngine();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.engine = null;
    }

    public void testNullPhaseId() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            TestPhase testPhase = new TestPhase(null, 1);
        });
    }

    public void testEmptyPhaseId() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            TestPhase testPhase = new TestPhase("", 1);
        });
    }

    public void testNegativeWeight() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            TestPhase testPhase = new TestPhase("xyz", -1);
        });
    }

    public void testZeroWeight() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            TestPhase testPhase = new TestPhase("xyz", 0);
        });
    }

    public void testPerform() {
        TestPhaseSet phaseSet = new TestPhaseSet((Phase)new TestPhase());
        IProfile profile = this.createProfile("PhaseTest");
        this.engine.perform(this.engine.createPlan(profile, null), (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testInitCompletePhase() {
        TestPhase phase = new TestPhase(){

            @Override
            protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
                PhaseTest.assertFalse((boolean)parameters.containsKey("TestPhase.initializePhase"));
                PhaseTest.assertFalse((boolean)this.completePhase);
                super.initializePhase(monitor, profile, parameters);
                PhaseTest.assertTrue((boolean)parameters.containsKey("TestPhase.initializePhase"));
                PhaseTest.assertFalse((boolean)this.completePhase);
                return null;
            }

            @Override
            protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
                PhaseTest.assertTrue((boolean)parameters.containsKey("TestPhase.initializePhase"));
                PhaseTest.assertFalse((boolean)this.completePhase);
                super.completePhase(monitor, profile, parameters);
                PhaseTest.assertTrue((boolean)parameters.containsKey("TestPhase.initializePhase"));
                PhaseTest.assertTrue((boolean)this.completePhase);
                return null;
            }
        };
        TestPhaseSet phaseSet = new TestPhaseSet((Phase)phase);
        IProfile profile = this.createProfile("PhaseTest");
        IInstallableUnit unit = PhaseTest.createIU("unit");
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(unit);
        this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        PhaseTest.assertTrue((boolean)phase.initializePhase);
        PhaseTest.assertTrue((boolean)phase.completePhase);
    }

    public void testInitCompleteOperand() {
        TestPhase phase = new TestPhase(){

            protected IStatus completeOperand(IProfile profile, Operand operand, Map<String, Object> parameters, IProgressMonitor monitor) {
                PhaseTest.assertTrue((boolean)parameters.containsKey("TestPhase.initializeOperand"));
                PhaseTest.assertFalse((boolean)this.completeOperand);
                super.completeOperand(profile, operand, parameters, monitor);
                PhaseTest.assertTrue((boolean)parameters.containsKey("TestPhase.initializeOperand"));
                PhaseTest.assertTrue((boolean)this.completeOperand);
                return null;
            }

            protected IStatus initializeOperand(IProfile profile, Operand operand, Map<String, Object> parameters, IProgressMonitor monitor) {
                PhaseTest.assertFalse((boolean)parameters.containsKey("TestPhase.initializeOperand"));
                PhaseTest.assertFalse((boolean)this.completeOperand);
                super.initializeOperand(profile, operand, parameters, monitor);
                PhaseTest.assertTrue((boolean)parameters.containsKey("TestPhase.initializeOperand"));
                PhaseTest.assertFalse((boolean)this.completeOperand);
                return null;
            }
        };
        TestPhaseSet phaseSet = new TestPhaseSet((Phase)phase);
        IProfile profile = this.createProfile("PhaseTest");
        IInstallableUnit unit = PhaseTest.createIU("testInitCompleteOperand");
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(unit);
        this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        PhaseTest.assertTrue((boolean)phase.initializeOperand);
        PhaseTest.assertTrue((boolean)phase.completeOperand);
    }

    public void testGetProfileDataArea() {
        TestPhase phase = new TestPhase(){

            @Override
            protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
                File profileDataArea = (File)parameters.get("profileDataDirectory");
                PhaseTest.assertTrue((boolean)profileDataArea.isDirectory());
                File test = new File(profileDataArea, "test");
                PhaseTest.assertFalse((boolean)test.exists());
                try {
                    test.createNewFile();
                }
                catch (IOException e) {
                    PhaseTest.fail((String)e.getMessage());
                }
                PhaseTest.assertTrue((boolean)test.exists());
                return super.initializePhase(monitor, profile, parameters);
            }

            @Override
            protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
                File profileDataArea = (File)parameters.get("profileDataDirectory");
                PhaseTest.assertTrue((boolean)profileDataArea.isDirectory());
                File test = new File(profileDataArea, "test");
                PhaseTest.assertTrue((boolean)test.exists());
                test.delete();
                PhaseTest.assertFalse((boolean)test.exists());
                return super.completePhase(monitor, profile, parameters);
            }
        };
        TestPhaseSet phaseSet = new TestPhaseSet((Phase)phase);
        IProfile profile = this.createProfile("PhaseTest");
        IInstallableUnit unit = PhaseTest.createIU("testGetProfileDataArea");
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(unit);
        this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        PhaseTest.assertTrue((boolean)phase.initializePhase);
        PhaseTest.assertTrue((boolean)phase.completePhase);
    }

    public void testGetAction() {
        final ArrayList actionsList1 = new ArrayList();
        InstallableUnitPhase phase1 = new InstallableUnitPhase("test", 1){

            protected List<ProvisioningAction> getActions(InstallableUnitOperand operand) {
                List actions = this.getActions(operand.second(), "test1");
                actionsList1.addAll(actions);
                return actions;
            }
        };
        final ArrayList actionsList2 = new ArrayList();
        InstallableUnitPhase phase2 = new InstallableUnitPhase("test", 1){

            protected List<ProvisioningAction> getActions(InstallableUnitOperand operand) {
                List actions = this.getActions(operand.second(), "test2");
                actionsList2.addAll(actions);
                return actions;
            }
        };
        TestPhaseSet phaseSet = new TestPhaseSet(new Phase[]{phase1, phase2});
        IProfile profile = this.createProfile("PhaseTest");
        HashMap<String, ITouchpointInstruction> instructions = new HashMap<String, ITouchpointInstruction>();
        instructions.put("test1", MetadataFactory.createTouchpointInstruction((String)"test1.test()", null));
        instructions.put("test2", MetadataFactory.createTouchpointInstruction((String)"test2.test()", null));
        ITouchpointData touchpointData = MetadataFactory.createTouchpointData(instructions);
        IInstallableUnit unit = PhaseTest.createIU("test", Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[0], NO_PROPERTIES, ITouchpointType.NONE, touchpointData, false);
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(unit);
        IStatus status = this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK()) {
            PhaseTest.fail((String)status.toString());
        }
        PhaseTest.assertEquals(TestAction.class, ((ParameterizedProvisioningAction)actionsList1.get(0)).getAction().getClass());
        PhaseTest.assertEquals(TestAction.class, ((ParameterizedProvisioningAction)actionsList2.get(0)).getAction().getClass());
    }

    public void testCancelHappenBeforeCompleteCollectPhase() {
        String testDataLocation = "testData/mirror/mirrorSourceRepo3";
        Set ius = null;
        try {
            IArtifactRepositoryManager mgr = PhaseTest.getArtifactRepositoryManager();
            mgr.loadRepository(PhaseTest.getTestData("test artifact repo", "testData/mirror/mirrorSourceRepo3").toURI(), null);
            IMetadataRepositoryManager metaManager = PhaseTest.getMetadataRepositoryManager();
            IMetadataRepository metaRepo = metaManager.loadRepository(PhaseTest.getTestData("test metadata repo", "testData/mirror/mirrorSourceRepo3").toURI(), null);
            ius = metaRepo.query(QueryUtil.ALL_UNITS, null).toUnmodifiableSet();
        }
        catch (Exception e) {
            PhaseTest.fail("1.0", e);
        }
        class MyCollect
        extends Collect {
            boolean isCancelled;
            int progress;
            static final int THREHOLD = 2;

            public MyCollect(int weight) {
                super(weight);
                this.isCancelled = false;
                this.progress = 0;
            }

            protected List<ProvisioningAction> getActions(InstallableUnitOperand operand) {
                List actions = super.getActions(operand);
                if (actions != null) {
                    ++this.progress;
                }
                if (this.progress > 2) {
                    this.isCancelled = true;
                }
                return actions;
            }
        }
        final MyCollect collect = new MyCollect(100);
        TestPhaseSet phaseSet = new TestPhaseSet(new Phase[]{collect});
        IProfile profile = this.createProfile("PhaseTest");
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        for (IInstallableUnit iu : ius) {
            plan.addInstallableUnit(iu);
        }
        class TestListener
        implements ProvisioningListener {
            boolean collectEvent = false;

            TestListener() {
            }

            public void notify(EventObject o) {
                if (o instanceof CollectEvent) {
                    this.collectEvent = true;
                }
            }
        }
        TestListener listener = new TestListener();
        this.getEventBus().addListener((ProvisioningListener)listener);
        try {
            IStatus status = this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor(){
                {
                }

                public boolean isCanceled() {
                    return collect.isCancelled;
                }
            });
            if (!status.matches(8)) {
                PhaseTest.fail((String)status.toString());
            }
            PhaseTest.assertFalse((String)"Collect actually happened!", (boolean)listener.collectEvent);
        }
        finally {
            this.getEventBus().removeListener((ProvisioningListener)listener);
        }
    }

    public static class TestAction
    extends ProvisioningAction {
        public IStatus execute(Map<String, Object> parameters) {
            return null;
        }

        public IStatus undo(Map<String, Object> parameters) {
            return null;
        }
    }

    public static class TestPhase
    extends InstallableUnitPhase {
        public boolean initializePhase;
        public boolean completePhase;
        public boolean initializeOperand;
        public boolean completeOperand;

        protected TestPhase() {
            super("test", 1);
        }

        protected TestPhase(String phaseId, int weight) {
            super(phaseId, weight);
        }

        protected IStatus completeOperand(IProfile profile, InstallableUnitOperand operand, Map<String, Object> parameters, IProgressMonitor monitor) {
            this.completeOperand = true;
            return super.completeOperand(profile, operand, parameters, monitor);
        }

        protected IStatus initializeOperand(IProfile profile, InstallableUnitOperand operand, Map<String, Object> parameters, IProgressMonitor monitor) {
            parameters.put("TestPhase.initializeOperand", "true");
            this.initializeOperand = true;
            return super.initializeOperand(profile, operand, parameters, monitor);
        }

        protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
            this.completePhase = true;
            return super.completePhase(monitor, profile, parameters);
        }

        protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
            parameters.put("TestPhase.initializePhase", "true");
            this.initializePhase = true;
            return super.initializePhase(monitor, profile, parameters);
        }

        protected List<ProvisioningAction> getActions(InstallableUnitOperand operand) {
            IInstallableUnit unit = operand.second();
            List parsedActions = this.getActions(unit, this.phaseId);
            if (parsedActions != null) {
                return parsedActions;
            }
            ITouchpointType type = unit.getTouchpointType();
            if (type == null || type == ITouchpointType.NONE) {
                return null;
            }
            String actionId = this.getActionManager().getTouchpointQualifiedActionId(this.phaseId, type);
            ProvisioningAction action = this.getActionManager().getAction(actionId, null);
            if (action == null) {
                throw new IllegalArgumentException("action not found: " + this.phaseId);
            }
            return Collections.singletonList(action);
        }
    }

    public static class TestPhaseSet
    extends PhaseSet {
        public TestPhaseSet() {
            super(new Phase[]{new TestPhase()});
        }

        public TestPhaseSet(Phase phase) {
            super(new Phase[]{phase});
        }

        public TestPhaseSet(Phase[] phases) {
            super(phases);
        }
    }
}

