/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.net.URI;
import java.util.Hashtable;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.internal.p2.core.ProvisioningAgent;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.ProfilePreferences;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProfilePreferencesTest
extends AbstractProvisioningTest {
    private IPreferencesService prefServ;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.prefServ = (IPreferencesService)ServiceHelper.getService((BundleContext)TestActivator.context, IPreferencesService.class);
    }

    public void testInvalidProfile() {
        try {
            IAgentLocation agentLocation = (IAgentLocation)ProfilePreferencesTest.getAgent().getService(IAgentLocation.class);
            String locationString = EncodingUtils.encodeSlashes((String)agentLocation.getRootLocation().toString());
            Preferences node = this.prefServ.getRootNode().node("/profile/" + locationString + "/NonExistantProfile/testing");
            node.sync();
        }
        catch (BackingStoreException e) {
            ProfilePreferencesTest.fail("1.0", e);
        }
    }

    public void testInvalidFilterChars() {
        File folder = ProfilePreferencesTest.getTestData("Prefs", "/testData/ProfilePreferencesTest/with(invalid)chars/");
        URI location = folder.toURI();
        ProvisioningAgent agent = new ProvisioningAgent();
        agent.setLocation(location);
        agent.setBundleContext(TestActivator.getContext());
        IAgentLocation agentLocation = (IAgentLocation)agent.getService(IAgentLocation.class);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("locationURI", location.toString());
        ServiceRegistration reg = TestActivator.getContext().registerService(IProvisioningAgent.class, (Object)agent, props);
        try {
            IEclipsePreferences prefs = new ProfileScope(agentLocation, "TestProfile").getNode("org.eclipse.equinox.p2.ui.sdk");
            ProfilePreferencesTest.assertEquals((String)"1.0", (String)"always", (String)prefs.get("allowNonOKPlan", ""));
        }
        finally {
            reg.unregister();
        }
    }

    public void testProfilePreference() {
        Preferences pref = null;
        String key = "Test";
        String value = "Value";
        IAgentLocation agentLocation = (IAgentLocation)ProfilePreferencesTest.getAgent().getService(IAgentLocation.class);
        String locationString = EncodingUtils.encodeSlashes((String)agentLocation.getRootLocation().toString());
        try {
            pref = this.prefServ.getRootNode().node("/profile/" + locationString + "/_SELF_/testing");
        }
        catch (IllegalArgumentException e) {
            ProfilePreferencesTest.fail((String)"IllegalArgumentException when accessing preferences for self profile");
        }
        pref.put(key, value);
        ProfilePreferencesTest.assertTrue((String)"Unable to retrieve value from preferences", (boolean)value.equals(pref.get(key, null)));
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            ProfilePreferencesTest.fail((String)("Unable to write to preferences: " + e.getMessage()));
        }
        this.waitForSave();
        try {
            pref.parent().removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        this.waitForSave();
        pref = this.prefServ.getRootNode().node("/profile/" + locationString + "/_SELF_/testing");
        ProfilePreferencesTest.assertEquals((String)"Value not present after load", (String)value, (String)pref.get(key, null));
    }

    private void waitForSave() {
        try {
            Job.getJobManager().join(ProfilePreferences.PROFILE_SAVE_JOB_FAMILY, null);
        }
        catch (InterruptedException e) {
            ProfilePreferencesTest.fail("4.99", e);
        }
    }
}

