/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.engine.ISurrogateProfileHandler;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.ProfileParser;
import org.eclipse.equinox.internal.p2.engine.ProfileWriter;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.junit.Assert;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ProfileTest
extends AbstractProvisioningTest {
    private static final String PROFILE_NAME = "ProfileTest";
    private static final String PROFILE_TEST_TARGET = "profileTest";
    static final Version PROFILE_TEST_VERSION = Version.create((String)"0.0.1");
    private static final String PROFILE_TEST_ELEMENT = "test";
    public static final String PROFILES_ELEMENT = "profiles";

    public ProfileTest(String name) {
        super(name);
    }

    public ProfileTest() {
        super("");
    }

    public void testNullProfile() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            IProfile iProfile = this.createProfile(null);
        });
    }

    public void testEmptyProfile() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            IProfile iProfile = this.createProfile("");
        });
    }

    public void testAddRemoveProperty() throws ProvisionException {
        IProfileRegistry registry = this.getProfileRegistry();
        ProfileTest.assertNull((Object)registry.getProfile(PROFILE_NAME));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(PROFILE_TEST_ELEMENT, PROFILE_TEST_ELEMENT);
        Profile profile = (Profile)registry.addProfile(PROFILE_NAME, properties);
        ProfileTest.assertTrue((boolean)profile.getProperties().containsKey(PROFILE_TEST_ELEMENT));
        ProfileTest.assertEquals((String)PROFILE_TEST_ELEMENT, (String)profile.getProperty(PROFILE_TEST_ELEMENT));
        profile.removeProperty(PROFILE_TEST_ELEMENT);
        ProfileTest.assertNull((Object)profile.getProperty(PROFILE_TEST_ELEMENT));
        profile.addProperties(properties);
        ProfileTest.assertEquals((String)PROFILE_TEST_ELEMENT, (String)profile.getProperty(PROFILE_TEST_ELEMENT));
        profile.setProperty(PROFILE_TEST_ELEMENT, "newvalue");
        ProfileTest.assertEquals((String)"newvalue", (String)profile.getProperty(PROFILE_TEST_ELEMENT));
        registry.removeProfile(PROFILE_NAME);
        ProfileTest.assertNull((Object)registry.getProfile(PROFILE_NAME));
    }

    public void testAddRemoveIU() throws ProvisionException {
        IProfileRegistry registry = this.getProfileRegistry();
        ProfileTest.assertNull((Object)registry.getProfile(PROFILE_NAME));
        Profile profile = (Profile)registry.addProfile(PROFILE_NAME);
        ProfileTest.assertTrue((boolean)profile.query(QueryUtil.createIUAnyQuery(), null).isEmpty());
        profile.addInstallableUnit(ProfileTest.createIU(PROFILE_TEST_ELEMENT));
        ProfileTest.assertEquals((int)1, (int)ProfileTest.queryResultSize(profile.query(QueryUtil.createIUAnyQuery(), null)));
        profile.removeInstallableUnit(ProfileTest.createIU(PROFILE_TEST_ELEMENT));
        ProfileTest.assertTrue((boolean)profile.query(QueryUtil.createIUAnyQuery(), null).isEmpty());
        registry.removeProfile(PROFILE_NAME);
        ProfileTest.assertNull((Object)registry.getProfile(PROFILE_NAME));
    }

    public void testAddIUTwice() throws ProvisionException {
        IProfileRegistry registry = this.getProfileRegistry();
        ProfileTest.assertNull((Object)registry.getProfile(PROFILE_NAME));
        Profile profile = (Profile)registry.addProfile(PROFILE_NAME);
        ProfileTest.assertTrue((boolean)profile.query(QueryUtil.createIUAnyQuery(), null).isEmpty());
        profile.addInstallableUnit(ProfileTest.createIU(PROFILE_TEST_ELEMENT));
        ProfileTest.assertEquals((int)1, (int)ProfileTest.queryResultSize(profile.query(QueryUtil.createIUAnyQuery(), null)));
        profile.addInstallableUnit(ProfileTest.createIU(PROFILE_TEST_ELEMENT));
        ProfileTest.assertEquals((int)1, (int)ProfileTest.queryResultSize(profile.query(QueryUtil.createIUAnyQuery(), null)));
        registry.removeProfile(PROFILE_NAME);
        ProfileTest.assertNull((Object)registry.getProfile(PROFILE_NAME));
    }

    public void testAddRemoveIUProperty() throws ProvisionException {
        IProfileRegistry registry = this.getProfileRegistry();
        ProfileTest.assertNull((Object)registry.getProfile(PROFILE_NAME));
        Profile profile = (Profile)registry.addProfile(PROFILE_NAME);
        ProfileTest.assertTrue((boolean)profile.query(QueryUtil.createIUAnyQuery(), null).isEmpty());
        profile.addInstallableUnit(ProfileTest.createIU(PROFILE_TEST_ELEMENT));
        ProfileTest.assertNull((Object)profile.getInstallableUnitProperty(ProfileTest.createIU(PROFILE_TEST_ELEMENT), PROFILE_TEST_ELEMENT));
        ProfileTest.assertNull((Object)profile.removeInstallableUnitProperty(ProfileTest.createIU(PROFILE_TEST_ELEMENT), PROFILE_TEST_ELEMENT));
        HashMap<String, String> iuProperties = new HashMap<String, String>();
        iuProperties.put(PROFILE_TEST_ELEMENT, PROFILE_TEST_ELEMENT);
        profile.addInstallableUnitProperties(ProfileTest.createIU(PROFILE_TEST_ELEMENT), iuProperties);
        ProfileTest.assertEquals((String)PROFILE_TEST_ELEMENT, (String)profile.getInstallableUnitProperty(ProfileTest.createIU(PROFILE_TEST_ELEMENT), PROFILE_TEST_ELEMENT));
        profile.removeInstallableUnitProperty(ProfileTest.createIU(PROFILE_TEST_ELEMENT), PROFILE_TEST_ELEMENT);
        ProfileTest.assertNull((Object)profile.getInstallableUnitProperty(ProfileTest.createIU(PROFILE_TEST_ELEMENT), PROFILE_TEST_ELEMENT));
        ProfileTest.assertEquals((int)1, (int)ProfileTest.queryResultSize(profile.query(QueryUtil.createIUAnyQuery(), null)));
        registry.removeProfile(PROFILE_NAME);
        ProfileTest.assertNull((Object)registry.getProfile(PROFILE_NAME));
    }

    public void testAvailable() throws ProvisionException {
        IProfileRegistry registry = this.getProfileRegistry();
        ProfileTest.assertNull((Object)registry.getProfile(PROFILE_NAME));
        Profile profile = (Profile)registry.addProfile(PROFILE_NAME);
        ProfileTest.assertTrue((boolean)profile.available(QueryUtil.createIUAnyQuery(), null).isEmpty());
        profile.addInstallableUnit(ProfileTest.createIU(PROFILE_TEST_ELEMENT));
        ProfileTest.assertEquals((int)1, (int)ProfileTest.queryResultSize(profile.available(QueryUtil.createIUAnyQuery(), null)));
        profile.setSurrogateProfileHandler(new ISurrogateProfileHandler(){

            public IProfile createProfile(String id) {
                return null;
            }

            public boolean isSurrogate(IProfile p) {
                return false;
            }

            public IQueryResult<IInstallableUnit> queryProfile(IProfile p, IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
                return new Collector();
            }
        });
        ProfileTest.assertTrue((boolean)profile.available(QueryUtil.createIUAnyQuery(), null).isEmpty());
        ProfileTest.assertTrue((boolean)profile.snapshot().available(QueryUtil.createIUAnyQuery(), null).isEmpty());
        registry.removeProfile(PROFILE_NAME);
        ProfileTest.assertNull((Object)registry.getProfile(PROFILE_NAME));
    }

    class ProfileStringParser
    extends ProfileParser {
        private IProfile[] profiles;

        public ProfileStringParser(String bundleId) {
            super(bundleId);
            this.profiles = null;
        }

        public void parse(String profileString) throws IOException {
            this.status = null;
            try {
                XMLReader reader = this.getParser().getXMLReader();
                TestHandler testHandler = new TestHandler();
                reader.setContentHandler((ContentHandler)((Object)new ProfileDocHandler(ProfileTest.PROFILE_TEST_ELEMENT, testHandler)));
                reader.parse(new InputSource(new StringReader(profileString)));
                if (this.isValidXML()) {
                    this.profiles = testHandler.handledProfiles;
                }
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                ProfileTest.fail();
            }
        }

        protected String getErrorMessage() {
            return "Error parsing profile string";
        }

        protected Object getRootObject() {
            HashMap<String, IProfile> result = new HashMap<String, IProfile>();
            IProfile[] iProfileArray = this.profiles;
            int n = this.profiles.length;
            int n2 = 0;
            while (n2 < n) {
                IProfile profile = iProfileArray[n2];
                result.put(profile.getProfileId(), profile);
                ++n2;
            }
            return result;
        }

        private final class ProfileDocHandler
        extends XMLParser.DocHandler {
            public ProfileDocHandler(String rootName, XMLParser.RootHandler rootHandler) {
                super((XMLParser)ProfileStringParser.this, rootName, rootHandler);
            }

            public void processingInstruction(String target, String data) throws SAXException {
                Version profileTestVersion;
                if (ProfileTest.PROFILE_TEST_TARGET.equals(target) && !PROFILE_TEST_VERSION.equals(profileTestVersion = ProfileStringParser.this.extractPIVersion(target, data))) {
                    throw new SAXException("Bad profile test version.");
                }
            }
        }

        protected class ProfilesHandler
        extends XMLParser.AbstractHandler {
            private final Map<String, ProfileParser.ProfileHandler> profileHandlers;

            public ProfilesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
                super((XMLParser)ProfileStringParser.this, (ContentHandler)parentHandler, ProfileTest.PROFILES_ELEMENT);
                String size = this.parseOptionalAttribute(attributes, "size");
                this.profileHandlers = size != null ? new HashMap<String, ProfileParser.ProfileHandler>(Integer.parseInt(size)) : new HashMap(4);
            }

            public IProfile[] getProfiles() {
                if (this.profileHandlers.isEmpty()) {
                    return new IProfile[0];
                }
                LinkedHashMap<String, IProfile> profileMap = new LinkedHashMap<String, IProfile>();
                for (String profileId : this.profileHandlers.keySet()) {
                    this.addProfile(profileId, profileMap);
                }
                return profileMap.values().toArray(new IProfile[profileMap.size()]);
            }

            private void addProfile(String profileId, Map<String, IProfile> profileMap) {
                if (profileMap.containsKey(profileId)) {
                    return;
                }
                ProfileParser.ProfileHandler profileHandler = this.profileHandlers.get(profileId);
                Profile parentProfile = null;
                String parentId = profileHandler.getParentId();
                if (parentId != null) {
                    this.addProfile(parentId, profileMap);
                    parentProfile = (Profile)profileMap.get(parentId);
                }
                Profile profile = new Profile(ProfileTest.getAgent(), profileId, parentProfile, profileHandler.getProperties());
                profile.setTimestamp(profileHandler.getTimestamp());
                IInstallableUnit[] ius = profileHandler.getInstallableUnits();
                if (ius != null) {
                    IInstallableUnit[] iInstallableUnitArray = ius;
                    int n = ius.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IInstallableUnit iu = iInstallableUnitArray[n2];
                        profile.addInstallableUnit(iu);
                        Map iuProperties = profileHandler.getIUProperties(iu);
                        if (iuProperties != null) {
                            for (Map.Entry entry : iuProperties.entrySet()) {
                                String key = (String)entry.getKey();
                                String value = (String)entry.getValue();
                                profile.setInstallableUnitProperty(iu, key, value);
                            }
                        }
                        ++n2;
                    }
                }
                profileMap.put(profileId, (IProfile)profile);
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("profile")) {
                    new ProfilesProfileHandler(this, attributes, this.profileHandlers);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        public class ProfilesProfileHandler
        extends ProfileParser.ProfileHandler {
            private final Map<String, ProfileParser.ProfileHandler> profileHandlers;

            public ProfilesProfileHandler(ProfilesHandler profilesHandler, Attributes attributes, Map<String, ProfileParser.ProfileHandler> profileHandlers) {
                super((ProfileParser)ProfileStringParser.this);
                this.profileHandlers = profileHandlers;
                this.parentHandler = profilesHandler;
                ProfileStringParser.this.xmlReader.setContentHandler((ContentHandler)((Object)this));
                this.handleRootAttributes(attributes);
            }

            protected void finished() {
                if (ProfileStringParser.this.isValidXML()) {
                    this.profileHandlers.put(this.getProfileId(), this);
                }
            }
        }

        final class TestHandler
        extends XMLParser.RootHandler {
            private ProfilesHandler profilesHandler;
            IProfile[] handledProfiles;

            TestHandler() {
                super((XMLParser)ProfileStringParser.this);
            }

            protected void handleRootAttributes(Attributes attributes) {
            }

            public void startElement(String name, Attributes attributes) {
                if (ProfileTest.PROFILES_ELEMENT.equals(name)) {
                    if (this.profilesHandler == null) {
                        this.profilesHandler = new ProfilesHandler((XMLParser.AbstractHandler)this, attributes);
                    } else {
                        ProfileStringParser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else {
                    this.invalidElement(name, attributes);
                }
            }

            protected void finished() {
                if (ProfileStringParser.this.isValidXML() && this.profilesHandler != null) {
                    this.handledProfiles = this.profilesHandler.getProfiles();
                }
            }
        }
    }

    class ProfileStringWriter
    extends ProfileWriter {
        public ProfileStringWriter(ByteArrayOutputStream stream) {
            super((OutputStream)stream, new XMLWriter.ProcessingInstruction[]{XMLWriter.ProcessingInstruction.makeTargetVersionInstruction((String)ProfileTest.PROFILE_TEST_TARGET, (Version)PROFILE_TEST_VERSION)});
        }

        public void writeTest(IProfile[] profiles) {
            this.start(ProfileTest.PROFILE_TEST_ELEMENT);
            this.writeProfiles(profiles);
            this.end(ProfileTest.PROFILE_TEST_ELEMENT);
            this.flush();
        }

        public void writeProfiles(IProfile[] profiles) {
            if (profiles.length > 0) {
                this.start(ProfileTest.PROFILES_ELEMENT);
                this.attribute("size", profiles.length);
                IProfile[] iProfileArray = profiles;
                int n = profiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IProfile profile = iProfileArray[n2];
                    this.writeProfile(profile);
                    ++n2;
                }
                this.end(ProfileTest.PROFILES_ELEMENT);
            }
        }
    }
}

