/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorEvent;
import org.eclipse.equinox.internal.p2.engine.CollectEvent;
import org.eclipse.equinox.internal.p2.engine.CommitOperationEvent;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitEvent;
import org.eclipse.equinox.internal.p2.engine.PhaseEvent;
import org.eclipse.equinox.internal.p2.engine.RollbackOperationEvent;
import org.eclipse.equinox.internal.p2.metadata.TouchpointData;
import org.eclipse.equinox.internal.p2.metadata.TouchpointInstruction;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.RemoveRepositoryAction;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ProvisioningEventTest
extends AbstractProvisioningTest {
    private IEngine engine;
    private File testProvisioning;

    @Override
    @Before
    public void setUp() throws Exception {
        this.engine = this.getEngine();
        this.testProvisioning = new File(System.getProperty("java.io.tmpdir"), "testProvisioning");
        ProvisioningEventTest.delete(this.testProvisioning);
        this.testProvisioning.mkdir();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.engine = null;
        ProvisioningEventTest.delete(this.testProvisioning);
    }

    @Test
    public void testCollectEvent() throws ProvisionException, OperationCanceledException, InterruptedException {
        class ProvTestListener
        implements ProvisioningListener {
            int requestsNumber = 0;
            boolean called = false;
            boolean mirrorEevent = false;
            CountDownLatch latch = new CountDownLatch(1);

            ProvTestListener() {
            }

            public void notify(EventObject o) {
                if (o instanceof CollectEvent) {
                    if (((CollectEvent)o).getType() == 1 && ((CollectEvent)o).getRepository() == null) {
                        this.called = true;
                        IArtifactRequest[] requests = ((CollectEvent)o).getDownloadRequests();
                        this.requestsNumber = requests.length;
                    }
                } else if (o instanceof MirrorEvent) {
                    this.mirrorEevent = true;
                    System.out.println(((MirrorEvent)o).getDownloadStatus());
                } else if (o instanceof CommitOperationEvent || o instanceof RollbackOperationEvent) {
                    this.latch.countDown();
                }
            }
        }
        ProvTestListener listener = new ProvTestListener();
        this.getEventBus().addListener((ProvisioningListener)listener);
        try {
            URI repoLoc = ProvisioningEventTest.getTestData("Load test data.", "/testData/testRepos/updateSite").toURI();
            IProfile profile = this.createProfile("test");
            IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)ProvisioningEventTest.getAgent(), (IProfile)profile);
            bundlePool.removeAll((IProgressMonitor)new NullProgressMonitor());
            ProvisioningContext context = new ProvisioningContext(ProvisioningEventTest.getAgent());
            context.setArtifactRepositories(new URI[]{repoLoc});
            context.setMetadataRepositories(new URI[]{repoLoc});
            IProvisioningPlan plan = this.engine.createPlan(profile, context);
            IQueryResult allIUs = ProvisioningEventTest.getMetadataRepositoryManager().loadRepository(repoLoc, null).query(QueryUtil.ALL_UNITS, null);
            for (IInstallableUnit iu : allIUs.toSet()) {
                plan.addInstallableUnit(iu);
            }
            IStatus status = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
            ProvisioningEventTest.assertTrue((String)"Provisioning was failed.", (boolean)status.isOK());
            listener.latch.await(10L, TimeUnit.SECONDS);
            ProvisioningEventTest.assertTrue((String)"Collect event wasn't dispatched.", (boolean)listener.called);
            ProvisioningEventTest.assertEquals((String)"Collect event didn't report expected artifacts to be downloaded.", (int)19, (int)listener.requestsNumber);
            ProvisioningEventTest.assertTrue((String)"Mirror event wasn't dispatched.", (boolean)listener.mirrorEevent);
        }
        finally {
            this.getEventBus().removeListener((ProvisioningListener)listener);
        }
    }

    @Test
    public void testPhaseEvent() throws ProvisionException, OperationCanceledException, InterruptedException {
        String[] phaseSets = new String[]{"collect", "checkTrust", "install", "configure"};
        class ProvTestListener
        implements ProvisioningListener {
            String publishUnWantedPhaseEvent = null;
            int publishUnWantedPhaseType = 0;
            List<String> phaseStartEventToBePublised;
            List<String> phaseEndEventToBePublised;
            CountDownLatch latch;

            ProvTestListener(String[] stringArray) {
                this.phaseStartEventToBePublised = new ArrayList<String>(Arrays.asList(stringArray));
                this.phaseEndEventToBePublised = new ArrayList<String>(Arrays.asList(stringArray));
                this.latch = new CountDownLatch(1);
            }

            public void notify(EventObject o) {
                if (o instanceof PhaseEvent) {
                    PhaseEvent event = (PhaseEvent)o;
                    if (event.getType() == 1) {
                        if (!this.phaseStartEventToBePublised.remove(event.getPhaseId())) {
                            this.publishUnWantedPhaseEvent = event.getPhaseId();
                        }
                    } else if (event.getType() == 2) {
                        if (!this.phaseEndEventToBePublised.remove(event.getPhaseId())) {
                            this.publishUnWantedPhaseEvent = event.getPhaseId();
                        }
                    } else {
                        this.publishUnWantedPhaseType = event.getType();
                    }
                } else if (o instanceof CommitOperationEvent || o instanceof RollbackOperationEvent) {
                    this.latch.countDown();
                }
            }
        }
        ProvTestListener listener = new ProvTestListener(phaseSets);
        this.getEventBus().addListener((ProvisioningListener)listener);
        try {
            URI repoLoc = ProvisioningEventTest.getTestData("Load test data.", "/testData/testRepos/updateSite").toURI();
            IProfile profile = this.createProfile("test");
            ProvisioningContext context = new ProvisioningContext(ProvisioningEventTest.getAgent());
            context.setArtifactRepositories(new URI[]{repoLoc});
            context.setMetadataRepositories(new URI[]{repoLoc});
            IProvisioningPlan plan = this.engine.createPlan(profile, context);
            IQueryResult allIUs = ProvisioningEventTest.getMetadataRepositoryManager().loadRepository(repoLoc, null).query(QueryUtil.ALL_UNITS, null);
            for (IInstallableUnit iu : allIUs.toSet()) {
                plan.addInstallableUnit(iu);
            }
            IStatus status = this.engine.perform(plan, PhaseSetFactory.createPhaseSetIncluding((String[])phaseSets), (IProgressMonitor)new NullProgressMonitor());
            ProvisioningEventTest.assertTrue((String)"Provisioning was failed.", (boolean)status.isOK());
            listener.latch.await(10L, TimeUnit.SECONDS);
            ProvisioningEventTest.assertNull((String)"Published phase event with unwanted phase id.", (Object)listener.publishUnWantedPhaseEvent);
            ProvisioningEventTest.assertEquals((String)"Published unwanted type of phase event.", (int)0, (int)listener.publishUnWantedPhaseType);
            ProvisioningEventTest.assertEquals((String)"Expected Phase start event is not published.", new ArrayList(0), listener.phaseStartEventToBePublised);
            ProvisioningEventTest.assertEquals((String)"Expected Phase end event is not published.", new ArrayList(0), listener.phaseEndEventToBePublised);
        }
        finally {
            this.getEventBus().removeListener((ProvisioningListener)listener);
        }
    }

    @Test
    public void testConfigureUnConfigureEvent() throws InterruptedException {
        String iuId = "test";
        class ProvTestListener
        implements ProvisioningListener {
            int preConfigureEvent = 0;
            int postConfigureEvent = 0;
            int preUnConfigureEvent = 0;
            int postUnConfigureEvent = 0;
            CountDownLatch latch = new CountDownLatch(2);

            ProvTestListener() {
            }

            public void notify(EventObject o) {
                if (o instanceof InstallableUnitEvent) {
                    InstallableUnitEvent event = (InstallableUnitEvent)o;
                    if (event.getPhase().equals("configure") && event.isConfigure() && event.getInstallableUnit().getId().equals("test")) {
                        if (event.isPre()) {
                            ++this.preConfigureEvent;
                        } else if (event.isPost()) {
                            ++this.postConfigureEvent;
                        }
                    } else if (event.getPhase().equals("unconfigure") && event.isUnConfigure() && event.getInstallableUnit().getId().equals("test")) {
                        if (event.isPre()) {
                            ++this.preUnConfigureEvent;
                        } else if (event.isPost()) {
                            ++this.postUnConfigureEvent;
                        }
                    }
                } else if (o instanceof CommitOperationEvent || o instanceof RollbackOperationEvent) {
                    this.latch.countDown();
                }
            }
        }
        ProvTestListener listener = new ProvTestListener();
        this.getEventBus().addListener((ProvisioningListener)listener);
        try {
            IProfile profile = this.createProfile("testConfigureEvent");
            IProvisioningPlan plan = this.engine.createPlan(profile, null);
            String testLocation = "https://download.eclipse.org/releases/2021-09";
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("agent", ProvisioningEventTest.getAgent());
            args.put("location", "https://download.eclipse.org/releases/2021-09");
            args.put("type", Integer.toString(1));
            args.put("enabled", "true");
            new RemoveRepositoryAction().execute(args);
            HashMap<String, TouchpointInstruction> data = new HashMap<String, TouchpointInstruction>();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("location", "https://download.eclipse.org/releases/2021-09");
            parameters.put("type", Integer.toString(1));
            parameters.put("name", "Juno");
            parameters.put("enabled", "true");
            data.put("configure", new TouchpointInstruction(TouchpointInstruction.encodeAction((String)"addRepository", parameters), null));
            IInstallableUnit testIU = this.createResolvedIU(ProvisioningEventTest.createEclipseIU("test", Version.create((String)"1.0.0"), new IRequirement[0], (ITouchpointData)new TouchpointData(data)));
            plan.addInstallableUnit(testIU);
            IStatus result = this.engine.perform(plan, PhaseSetFactory.createDefaultPhaseSet(), (IProgressMonitor)new NullProgressMonitor());
            ProvisioningEventTest.assertTrue((String)"0.2", (boolean)result.isOK());
            Set installedIUs = profile.available(QueryUtil.ALL_UNITS, null).toUnmodifiableSet();
            ProvisioningEventTest.assertEquals((String)"0.3", (int)1, (int)installedIUs.size());
            plan = this.engine.createPlan(profile, null);
            plan.removeInstallableUnit(testIU);
            result = this.engine.perform(plan, PhaseSetFactory.createDefaultPhaseSet(), (IProgressMonitor)new NullProgressMonitor());
            ProvisioningEventTest.assertTrue((String)"0.4", (boolean)result.isOK());
            listener.latch.await(10L, TimeUnit.SECONDS);
            ProvisioningEventTest.assertEquals((String)"0.5", (int)1, (int)listener.preConfigureEvent);
            ProvisioningEventTest.assertEquals((String)"0.6", (int)1, (int)listener.postConfigureEvent);
            ProvisioningEventTest.assertEquals((String)"0.7", (int)1, (int)listener.preUnConfigureEvent);
            ProvisioningEventTest.assertEquals((String)"0.8", (int)1, (int)listener.postUnConfigureEvent);
        }
        finally {
            this.getEventBus().removeListener((ProvisioningListener)listener);
        }
    }

    @Test
    public void testConfigureUndoEvent() throws InterruptedException {
        String iuId = "test";
        String failureIU = "alwaysFail";
        class ProvTestListener
        implements ProvisioningListener {
            int preConfigureEvent = 0;
            int postConfigureEvent = 0;
            int preUnConfigureEventForUndo = 0;
            int postUnConfigureEventForUndo = 0;
            CountDownLatch latch = new CountDownLatch(1);

            ProvTestListener() {
            }

            public void notify(EventObject o) {
                if (o instanceof InstallableUnitEvent) {
                    InstallableUnitEvent event = (InstallableUnitEvent)o;
                    if (event.getPhase().equals("configure") && event.getInstallableUnit().getId().equals("test")) {
                        if (event.isConfigure() && event.isPre()) {
                            ++this.preConfigureEvent;
                        } else if (event.isConfigure() && event.isPost()) {
                            ++this.postConfigureEvent;
                        } else if (event.isUnConfigure() && event.isPre()) {
                            ++this.preUnConfigureEventForUndo;
                        } else if (event.isUnConfigure() && event.isPost()) {
                            ++this.postUnConfigureEventForUndo;
                        }
                    } else if (event.getPhase().equals("configure") && event.getInstallableUnit().getId().equals("alwaysFail")) {
                        if (event.isConfigure() && event.isPre()) {
                            ++this.preConfigureEvent;
                        } else if (event.isConfigure() && event.isPost()) {
                            ++this.postConfigureEvent;
                        } else if (event.isUnConfigure() && event.isPre()) {
                            ++this.preUnConfigureEventForUndo;
                        } else if (event.isUnConfigure() && event.isPost()) {
                            ++this.postUnConfigureEventForUndo;
                        }
                    }
                } else if (o instanceof CommitOperationEvent || o instanceof RollbackOperationEvent) {
                    this.latch.countDown();
                }
            }
        }
        ProvTestListener listener = new ProvTestListener();
        this.getEventBus().addListener((ProvisioningListener)listener);
        try {
            String customTouchPoint = "<extension point=\"org.eclipse.equinox.p2.engine.actions\"> <action class=\"org.eclipse.equinox.p2.tests.engine.ProvisioningEventTest.AlwaysFail\" name=\"alwaysFail\" touchpointType=\"org.eclipse.equinox.p2.osgi\" touchpointVersion=\"1.0.0\" version=\"1.0.0\"></action></extension>";
            ByteArrayInputStream input = new ByteArrayInputStream("<extension point=\"org.eclipse.equinox.p2.engine.actions\"> <action class=\"org.eclipse.equinox.p2.tests.engine.ProvisioningEventTest.AlwaysFail\" name=\"alwaysFail\" touchpointType=\"org.eclipse.equinox.p2.osgi\" touchpointVersion=\"1.0.0\" version=\"1.0.0\"></action></extension>".getBytes());
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.addContribution((InputStream)input, (IContributor)new RegistryContributor("org.eclipse.equinox.p2.test", "p2 tests", null, null), false, "Always Fail TouchPoint Action", null, ((ExtensionRegistry)registry).getTemporaryUserToken());
            IProfile profile = this.createProfile("testConfigureEvent");
            IProvisioningPlan plan = this.engine.createPlan(profile, null);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("configure", MetadataFactory.createTouchpointInstruction((String)"instructionparsertest.goodAction()", null));
            IInstallableUnit testIU = this.createResolvedIU(ProvisioningEventTest.createIU("test", Version.create((String)"1.0.0"), null, new IRequirement[0], BUNDLE_CAPABILITY, NO_PROPERTIES, ITouchpointType.NONE, (ITouchpointData)new TouchpointData(data), false));
            plan.addInstallableUnit(testIU);
            data = new HashMap(1);
            data.put("configure", new TouchpointInstruction("alwaysFail();", null));
            plan.addInstallableUnit(this.createResolvedIU(ProvisioningEventTest.createEclipseIU("alwaysFail", Version.create((String)"1.0.0"), new IRequirement[0], (ITouchpointData)new TouchpointData(data))));
            IStatus result = this.engine.perform(plan, PhaseSetFactory.createDefaultPhaseSet(), (IProgressMonitor)new NullProgressMonitor());
            ProvisioningEventTest.assertFalse((boolean)result.isOK());
            listener.latch.await(10L, TimeUnit.SECONDS);
            ProvisioningEventTest.assertEquals((String)"0.5", (int)2, (int)listener.preConfigureEvent);
            ProvisioningEventTest.assertEquals((String)"0.6", (int)1, (int)listener.postConfigureEvent);
            ProvisioningEventTest.assertEquals((String)"0.7", (int)1, (int)listener.preUnConfigureEventForUndo);
            ProvisioningEventTest.assertEquals((String)"0.8", (int)2, (int)listener.postUnConfigureEventForUndo);
        }
        finally {
            this.getEventBus().removeListener((ProvisioningListener)listener);
        }
    }

    public static class AlwaysFail
    extends ProvisioningAction {
        public IStatus execute(Map<String, Object> parameters) {
            boolean a = true;
            if (a) {
                throw new NullPointerException("no reason");
            }
            return null;
        }

        public IStatus undo(Map<String, Object> parameters) {
            return null;
        }
    }
}

