/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.net.URI;
import java.util.EventObject;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.core.ProvisioningAgent;
import org.eclipse.equinox.internal.p2.engine.CommitOperationEvent;
import org.eclipse.equinox.internal.p2.engine.RollbackOperationEvent;
import org.eclipse.equinox.internal.p2.repository.DownloadProgressEvent;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.testserver.helper.AbstractTestServerClientCase;
import org.junit.Test;

public class ProvisioningEventTest2
extends AbstractTestServerClientCase {
    @Test
    public void testDownloadEventFromMultipleAgents() throws ProvisionException, OperationCanceledException, InterruptedException {
        ProvisioningAgent newAgent = new ProvisioningAgent();
        newAgent.setBundleContext(TestActivator.getContext());
        IProvisioningEventBus eventBus = (IProvisioningEventBus)newAgent.getService(IProvisioningEventBus.class);
        class DownloadProvisiongEventListener
        implements ProvisioningListener {
            boolean notifiedDownloadProgressEvent = false;
            CountDownLatch latch = new CountDownLatch(1);

            DownloadProvisiongEventListener() {
            }

            public void notify(EventObject o) {
                if (o instanceof DownloadProgressEvent) {
                    this.notifiedDownloadProgressEvent = true;
                } else if (o instanceof CommitOperationEvent || o instanceof RollbackOperationEvent) {
                    this.latch.countDown();
                }
            }
        }
        DownloadProvisiongEventListener provListener = new DownloadProvisiongEventListener();
        DownloadProvisiongEventListener provListener1 = new DownloadProvisiongEventListener();
        eventBus.addListener((ProvisioningListener)provListener);
        IProvisioningEventBus eventBus2 = (IProvisioningEventBus)ProvisioningEventTest2.getAgent().getService(IProvisioningEventBus.class);
        try {
            URI repoLoc = URI.create(this.getBaseURL() + "/public/emptyJarRepo");
            String name = "testProfile";
            IProfileRegistry profileRegistry = (IProfileRegistry)ProvisioningEventTest2.getAgent().getService(IProfileRegistry.class);
            profileRegistry.removeProfile("testProfile");
            IProfile profile = profileRegistry.addProfile("testProfile", null);
            IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)ProvisioningEventTest2.getAgent(), (IProfile)profile);
            bundlePool.removeAll((IProgressMonitor)new NullProgressMonitor());
            ProvisioningContext context = new ProvisioningContext(ProvisioningEventTest2.getAgent());
            context.setArtifactRepositories(new URI[]{repoLoc});
            context.setMetadataRepositories(new URI[]{repoLoc});
            IEngine engine = (IEngine)ProvisioningEventTest2.getAgent().getService(IEngine.class);
            IProvisioningPlan plan = engine.createPlan(profile, context);
            IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)ProvisioningEventTest2.getAgent().getService(IMetadataRepositoryManager.class);
            IQueryResult allIUs = metaManager.loadRepository(repoLoc, null).query(QueryUtil.ALL_UNITS, null);
            for (IInstallableUnit iu : allIUs.toSet()) {
                plan.addInstallableUnit(iu);
            }
            eventBus2.addListener((ProvisioningListener)provListener1);
            IStatus status = engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
            ProvisioningEventTest2.assertTrue((String)"Provisioning was failed.", (boolean)status.isOK());
            provListener1.latch.await(10L, TimeUnit.SECONDS);
            ProvisioningEventTest2.assertTrue((String)"Listener1 is NOT notified by DownloadProgressEvent.", (boolean)provListener1.notifiedDownloadProgressEvent);
            ProvisioningEventTest2.assertFalse((String)"Listener should NOT be notified by DownloadProgressEvent.", (boolean)provListener.notifiedDownloadProgressEvent);
        }
        finally {
            eventBus2.removeListener((ProvisioningListener)provListener1);
        }
    }
}

