/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.engine.spi.Value;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class VariableTest3
extends AbstractProvisioningTest {
    private IInstallableUnit createIUWithVariable() {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId("artifactWithZip");
        description.setVersion(Version.create((String)"1.0.0"));
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "test.actionForVariableTesting3( arg1: val1 ); test.actionForVariableTesting3 ( arg1: ${lastResult}); test.actionForVariableTesting3( arg1: ${lastResult} );");
        description.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    public void testLastResultIsReinitialized() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.getTempFolder().getAbsolutePath());
        IProfile profile = this.createProfile(this.getName(), properties);
        Iterator<IInstallableUnit> ius = VariableTest3.getInstallableUnits(profile);
        VariableTest3.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.getEngine().createPlan(profile, null);
        plan.addInstallableUnit(this.createIUWithVariable());
        Action.expectedInputValues.add("val1");
        Action.expectedReturnValues.add("returnValue1");
        Action.expectedInputValues.add("returnValue1");
        Action.expectedReturnValues.add(Value.NO_VALUE);
        Action.expectedInputValues.add(null);
        Action.expectedReturnValues.add("unusedValue");
        IStatus result = this.getEngine().perform(plan, PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{"install"}), (IProgressMonitor)new NullProgressMonitor());
        VariableTest3.assertOK(result);
    }

    public static class Action
    extends ProvisioningAction {
        public static Object result;
        public static ArrayList<Object> expectedInputValues;
        public static ArrayList<Object> expectedReturnValues;
        public static int invocationCounter;

        static {
            expectedInputValues = new ArrayList();
            expectedReturnValues = new ArrayList();
            invocationCounter = 0;
        }

        public IStatus execute(Map<String, Object> parameters) {
            VariableTest3.assertEquals((Object)expectedInputValues.get(invocationCounter), (Object)parameters.get("arg1"));
            result = expectedReturnValues.get(invocationCounter);
            ++invocationCounter;
            return Status.OK_STATUS;
        }

        public Value<Object> getResult() {
            if (Value.NO_VALUE == result) {
                return Value.NO_VALUE;
            }
            return new Value(result);
        }

        public IStatus undo(Map<String, Object> parameters) {
            return null;
        }
    }
}

