/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.extensionlocation;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepositoryFactory;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ExtensionLocationMetadataRepositoryFactoryTest
extends AbstractProvisioningTest {
    private File tempDirectory;
    private ExtensionLocationMetadataRepositoryFactory factory;

    public ExtensionLocationMetadataRepositoryFactoryTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        ExtensionLocationMetadataRepositoryFactoryTest.delete(this.tempDirectory);
        super.tearDown();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String tempDir = System.getProperty("java.io.tmpdir");
        this.tempDirectory = new File(tempDir, "extensionlocationtest");
        ExtensionLocationMetadataRepositoryFactoryTest.delete(this.tempDirectory);
        this.tempDirectory.mkdirs();
        this.factory = new ExtensionLocationMetadataRepositoryFactory();
        this.factory.setAgent(ExtensionLocationMetadataRepositoryFactoryTest.getAgent());
    }

    public void testNonFileURL() {
        try {
            URI nonFileURL = new URI("http://www.eclipse.org");
            this.factory.load(nonFileURL, 0, this.getMonitor());
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"0.1");
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.assertEquals((String)"0.2", (int)1000, (int)e.getStatus().getCode());
        }
        catch (URISyntaxException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail("0.3", e);
        }
    }

    public void testNonExistentFile() {
        File directory = new File(this.tempDirectory, "nonexistent");
        ExtensionLocationMetadataRepositoryFactoryTest.delete(directory);
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"0.1");
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.assertEquals((String)"0.2", (int)1000, (int)e.getStatus().getCode());
        }
    }

    public void testNotDirectory() {
        File file = new File(this.tempDirectory, "exists.file");
        try {
            file.createNewFile();
            this.factory.load(file.toURI(), 0, this.getMonitor());
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"0.1");
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.assertEquals((String)"0.2", (int)1000, (int)e.getStatus().getCode());
        }
        catch (MalformedURLException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail("0.3", e);
        }
        catch (IOException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail("0.4", e);
        }
    }

    public void testNoFeatureOrPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"0.1");
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.assertEquals((String)"0.2", (int)1000, (int)e.getStatus().getCode());
        }
    }

    public void testEmptyFeatureAndPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        new File(directory, "plugins").mkdir();
        new File(directory, "features").mkdir();
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"0.1");
        }
    }

    public void testEmptyFeaturesDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        new File(directory, "features").mkdir();
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"0.1");
        }
    }

    public void testEmptyPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        new File(directory, "plugins").mkdir();
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"0.1");
        }
    }

    public void testEclipseBaseEmptyFeatureAndPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        File eclipseDirectory = new File(directory, "eclipse");
        eclipseDirectory.mkdir();
        new File(eclipseDirectory, "plugins").mkdir();
        new File(eclipseDirectory, "features").mkdir();
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"0.1");
        }
    }

    public void testNotEclipseBaseEmptyFeatureAndPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        File eclipseDirectory = new File(directory, "noteclipse");
        eclipseDirectory.mkdir();
        new File(eclipseDirectory, "plugins").mkdir();
        new File(eclipseDirectory, "features").mkdir();
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"0.1");
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.assertEquals((String)"0.2", (int)1000, (int)e.getStatus().getCode());
        }
    }

    public void testNormalFeaturesandPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        ExtensionLocationMetadataRepositoryFactoryTest.copy("1.0", ExtensionLocationMetadataRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
        URI location = directory.toURI();
        try {
            IMetadataRepository repo = this.factory.load(location, 0, this.getMonitor());
            if (ExtensionLocationMetadataRepositoryFactoryTest.queryResultSize(repo.query(QueryUtil.createIUAnyQuery(), null)) != 3) {
                ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"2.99");
            }
        }
        catch (ProvisionException ex) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"2.0");
        }
    }

    public void testNormalFeaturesDirectory() {
        File directory = new File(this.tempDirectory, "exists/features");
        directory.mkdirs();
        File features = new File(directory, "features");
        features.mkdir();
        ExtensionLocationMetadataRepositoryFactoryTest.copy("1.0", ExtensionLocationMetadataRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation/features"), features);
        URI location = directory.toURI();
        try {
            IMetadataRepository repo = this.factory.load(location, 0, this.getMonitor());
            if (ExtensionLocationMetadataRepositoryFactoryTest.queryResultSize(repo.query(QueryUtil.createIUAnyQuery(), null)) != 2) {
                ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"3.0");
            }
        }
        catch (ProvisionException ex) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"2.0");
        }
    }

    public void testNormalPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists/plugins");
        directory.mkdirs();
        File plugins = new File(directory, "plugins");
        plugins.mkdir();
        ExtensionLocationMetadataRepositoryFactoryTest.copy("1.0", ExtensionLocationMetadataRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation/plugins"), plugins);
        URI location = directory.toURI();
        try {
            IMetadataRepository repo = this.factory.load(location, 0, this.getMonitor());
            if (ExtensionLocationMetadataRepositoryFactoryTest.queryResultSize(repo.query(QueryUtil.createIUAnyQuery(), null)) != 1) {
                ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"3.0");
            }
        }
        catch (ProvisionException ex) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"2.0");
        }
    }

    public void testEclipseBaseNormalFeaturesandPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        File eclipseDirectory = new File(directory, "eclipse");
        ExtensionLocationMetadataRepositoryFactoryTest.copy("1.0", ExtensionLocationMetadataRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), eclipseDirectory);
        try {
            IMetadataRepository repo = this.factory.load(directory.toURI(), 0, this.getMonitor());
            if (ExtensionLocationMetadataRepositoryFactoryTest.queryResultSize(repo.query(QueryUtil.createIUAnyQuery(), null)) != 3) {
                ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"3.0");
            }
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"2.0");
        }
    }

    public void testEclipseBaseModifiableRepository() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        File eclipseDirectory = new File(directory, "eclipse");
        ExtensionLocationMetadataRepositoryFactoryTest.copy("1.0", ExtensionLocationMetadataRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), eclipseDirectory);
        try {
            IMetadataRepository repo = this.factory.load(directory.toURI(), 1, this.getMonitor());
            ExtensionLocationMetadataRepositoryFactoryTest.assertNull((String)"3.0", (Object)repo);
        }
        catch (ProvisionException e) {
            ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"2.0");
        }
    }

    public void testUpdateSiteXMLURL() {
        block2: {
            File site = ExtensionLocationMetadataRepositoryFactoryTest.getTestData("0.1", "/testData/updatesite/site");
            try {
                this.factory.load(site.toURI(), 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testXXXSiteXXXXMLURL() {
        block2: {
            File site = ExtensionLocationMetadataRepositoryFactoryTest.getTestData("0.1", "/testData/updatesite/xxxsitexxx");
            try {
                this.factory.load(site.toURI(), 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testArtifactsXMLFeaturesandPluginsDirectory() throws IOException {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File artifactsXML = new File(directory, "artifacts.xml");
            artifactsXML.createNewFile();
            ExtensionLocationMetadataRepositoryFactoryTest.copy("1.0", ExtensionLocationMetadataRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
            URI location = directory.toURI();
            try {
                this.factory.load(location, 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testArtifactsXMLFeaturesandPluginsDirectoryWithExtensionLocation() throws IOException {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File artifactsXML = new File(directory, "artifacts.xml");
            artifactsXML.createNewFile();
            ExtensionLocationMetadataRepositoryFactoryTest.copy("1.0", ExtensionLocationMetadataRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
            File extensionLocation = new File(this.tempDirectory.getAbsolutePath() + ".eclipseextension");
            URI location = extensionLocation.toURI();
            try {
                this.factory.load(location, 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testContentXMLFeaturesandPluginsDirectory() throws IOException {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File contentXML = new File(directory, "content.xml");
            contentXML.createNewFile();
            ExtensionLocationMetadataRepositoryFactoryTest.copy("1.0", ExtensionLocationMetadataRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
            URI location = directory.toURI();
            try {
                this.factory.load(location, 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testCompositeArtifactsXMLFeaturesandPluginsDirectory() throws IOException {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File compositeArtifactsXML = new File(directory, "compositeArtifacts.xml");
            compositeArtifactsXML.createNewFile();
            ExtensionLocationMetadataRepositoryFactoryTest.copy("1.0", ExtensionLocationMetadataRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
            URI location = directory.toURI();
            try {
                this.factory.load(location, 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testCompositeContentXMLFeaturesandPluginsDirectory() throws IOException {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File compositeContentXML = new File(directory, "compositeContent.xml");
            compositeContentXML.createNewFile();
            ExtensionLocationMetadataRepositoryFactoryTest.copy("1.0", ExtensionLocationMetadataRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
            URI location = directory.toURI();
            try {
                this.factory.load(location, 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationMetadataRepositoryFactoryTest.fail((String)"1.0");
    }
}

