/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.full;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractEnd2EndTest
extends AbstractProvisioningTest {
    private IMetadataRepositoryManager metadataRepoManager;
    private IArtifactRepositoryManager artifactRepoManager;
    private IDirector director;
    private ServiceTracker fwAdminTracker;
    private IProvisioningAgent end2endAgent = null;

    @Override
    protected void setUp() throws Exception {
        ServiceReference sr = TestActivator.context.getServiceReference(IProvisioningAgentProvider.class);
        IProvisioningAgentProvider agentFactory = (IProvisioningAgentProvider)TestActivator.context.getService(sr);
        this.end2endAgent = agentFactory.createAgent(this.getTempFolder().toURI());
        this.metadataRepoManager = (IMetadataRepositoryManager)this.end2endAgent.getService(IMetadataRepositoryManager.class);
        this.artifactRepoManager = (IArtifactRepositoryManager)this.end2endAgent.getService(IArtifactRepositoryManager.class);
        this.director = (IDirector)this.end2endAgent.getService(IDirector.class);
    }

    protected IProfile createProfile(String profileId, String installFolder) {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.end2endAgent.getService(IProfileRegistry.class);
        if (profileRegistry == null) {
            throw new RuntimeException("Profile registry service not available");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("org.eclipse.equinox.p2.installFolder", installFolder);
        EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)TestActivator.getContext(), EnvironmentInfo.class);
        if (info != null) {
            properties.put("org.eclipse.equinox.p2.environments", "osgi.os=" + info.getOS() + ",osgi.ws=" + info.getWS() + ",osgi.arch=" + info.getOSArch());
        }
        properties.put("org.eclipse.update.install.features", "true");
        properties.put("org.eclipse.equinox.p2.cache", installFolder);
        try {
            return profileRegistry.addProfile(profileId, properties);
        }
        catch (ProvisionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void testInstallSDK() {
        File installFolder = TestActivator.getContext().getDataFile(AbstractEnd2EndTest.class.getName());
        IProfile profile2 = this.createProfile("End2EndProfile", installFolder.getAbsolutePath());
        URI repositoryLocation = this.getRepositoryLocation();
        try {
            this.metadataRepoManager.addRepository(repositoryLocation);
            this.metadataRepoManager.setEnabled(repositoryLocation, true);
            this.metadataRepoManager.loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            this.artifactRepoManager.addRepository(repositoryLocation);
            this.artifactRepoManager.setEnabled(repositoryLocation, true);
        }
        catch (ProvisionException e) {
            AbstractEnd2EndTest.fail("Exception loading the repository.", e);
        }
        this.installPlatform(profile2, installFolder);
        this.installBogusIU(profile2, installFolder);
        this.installPlatformSource(profile2, installFolder);
        this.attemptToUninstallRCP(profile2, installFolder);
        this.rollbackPlatformSource(profile2, installFolder);
    }

    private void attemptToUninstallRCP(IProfile profile2, File installFolder) {
        IQueryResult collect = profile2.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        AbstractEnd2EndTest.assertEquals((int)1, (int)AbstractEnd2EndTest.queryResultSize(collect));
        ProfileChangeRequest request = new ProfileChangeRequest(profile2);
        request.removeInstallableUnits(new IInstallableUnit[]{(IInstallableUnit)collect.iterator().next()});
        IStatus s = this.director.provision((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor());
        AbstractEnd2EndTest.assertOK("Can not uninstall RCP", s);
        AbstractEnd2EndTest.assertEquals((int)1, (int)AbstractEnd2EndTest.queryResultSize(profile2.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor())));
    }

    protected void uninstallPlatform(IProfile profile2, File installFolder) {
        System.out.println("Uninstall the platform");
        IQueryResult collect = profile2.query(QueryUtil.createIUQuery((String)this.getPlatform().getId()), (IProgressMonitor)new NullProgressMonitor());
        AbstractEnd2EndTest.assertEquals((int)1, (int)AbstractEnd2EndTest.queryResultSize(collect));
        ProfileChangeRequest request = new ProfileChangeRequest(profile2);
        request.removeInstallableUnits(new IInstallableUnit[]{(IInstallableUnit)collect.iterator().next()});
        IStatus s = this.director.provision((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor());
        AbstractEnd2EndTest.assertOK("Can not uninstall platform", s);
    }

    private void rollbackPlatformSource(IProfile profile2, File installFolder) {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.end2endAgent.getService(IProfileRegistry.class);
        long[] timestamps = profileRegistry.listProfileTimestamps(profile2.getProfileId());
        AbstractEnd2EndTest.assertEquals((int)3, (int)timestamps.length);
        IProfile revertProfile = profileRegistry.getProfile(profile2.getProfileId(), timestamps[1]);
        IStatus s = this.director.revert(profile2, revertProfile, new ProvisioningContext(AbstractEnd2EndTest.getAgent()), (IProgressMonitor)new NullProgressMonitor());
        AbstractEnd2EndTest.assertTrue((boolean)s.isOK());
        this.validateInstallContent(installFolder);
        AbstractEnd2EndTest.assertFalse((boolean)new File(installFolder, "configuration/org.eclipse.equinox.source/source.info").exists());
    }

    private void installPlatformSource(IProfile profile2, File installFolder) {
        VersionedId source = this.getPlatformSource();
        IInstallableUnit toInstall = this.getIU(source.getId(), source.getVersion());
        ProfileChangeRequest request = new ProfileChangeRequest(profile2);
        request.addInstallableUnits(new IInstallableUnit[]{toInstall});
        IStatus s = this.director.provision((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor());
        if (!s.isOK()) {
            AbstractEnd2EndTest.fail((String)("Installation of the " + source.getId() + " " + String.valueOf(source.getVersion()) + " failed."));
        }
        AbstractEnd2EndTest.assertProfileContainsAll("Platform source feature", profile2, new IInstallableUnit[]{toInstall});
        AbstractEnd2EndTest.assertTrue((boolean)new File(installFolder, "configuration/org.eclipse.equinox.source").exists());
    }

    private void installBogusIU(IProfile profile, File installFolder) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        iud.setId("org.eclipse.equinox.p2.tests.bogusIU.end2end");
        iud.setVersion(Version.create((String)"1.0.0"));
        iud.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.equinox.p2.tests.bogusIU.end2end", (Version)Version.create((String)"1.0.0"))});
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("install", "org.eclipse.equinox.p2.osgi.removeJvmArg(programArg:-XX:+UnlockDiagnosticVMOptions);");
        iud.addTouchpointData(MetadataFactory.createTouchpointData(data));
        IInstallableUnit bogusIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
        iud.setTouchpointType(MetadataFactory.createTouchpointType((String)"org.eclipse.equinox.p2.osgi", (Version)Version.create((String)"1.0.0")));
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{bogusIU});
        IStatus s = this.director.provision((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor());
        AbstractEnd2EndTest.assertNotOK(s);
    }

    private void installPlatform(IProfile profile2, File installFolder) {
        VersionedId platform = this.getPlatform();
        ProfileChangeRequest request = new ProfileChangeRequest(profile2);
        IInstallableUnit platformIU = this.getIU(platform.getId(), platform.getVersion());
        request.addInstallableUnits(new IInstallableUnit[]{platformIU});
        IStatus s = this.director.provision((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor());
        if (!s.isOK()) {
            LogHelper.log((IStatus)s);
            AbstractEnd2EndTest.fail((String)("Installation of the " + platform.getId() + " " + String.valueOf(platform.getVersion()) + " failed. " + s.toString()));
        }
        AbstractEnd2EndTest.assertProfileContainsAll("Platform profile", profile2, new IInstallableUnit[]{platformIU});
        this.validateInstallContent(installFolder);
        AbstractEnd2EndTest.assertFalse((boolean)new File(installFolder, "configuration/org.eclipse.equinox.source").exists());
    }

    public IInstallableUnit getIU(String id, Version v) {
        IQuery query = QueryUtil.createIUQuery((String)id, (Version)v);
        Iterator it = this.metadataRepoManager.query(query, null).iterator();
        if (it.hasNext()) {
            return (IInstallableUnit)it.next();
        }
        Throwable failure = null;
        int i = 0;
        while (i < 3) {
            try {
                IMetadataRepository repo = this.metadataRepoManager.loadRepository(this.getRepositoryLocation(), null);
                it = repo.query(query, null).iterator();
                if (it.hasNext()) {
                    return (IInstallableUnit)it.next();
                }
            }
            catch (ProvisionException e) {
                failure = e;
            }
            ++i;
        }
        if (failure == null) {
            failure = new RuntimeException("IU not found");
        }
        AbstractEnd2EndTest.fail("Failed to obtain " + id + " version: " + String.valueOf(v) + " from: " + String.valueOf(this.getRepositoryLocation()), failure);
        return null;
    }

    protected abstract void validateInstallContent(File var1);

    protected abstract URI getRepositoryLocation();

    protected abstract VersionedId getPlatform();

    protected abstract VersionedId getPlatformSource();

    protected void assertContains(String message, String[] source, String searched) {
        String[] stringArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.equals(searched)) {
                return;
            }
            ++n2;
        }
        AbstractEnd2EndTest.fail((String)(message + " " + searched));
    }

    protected FrameworkAdmin getEquinoxFrameworkAdmin() {
        String FILTER_OBJECTCLASS = "(objectClass=" + FrameworkAdmin.class.getName() + ")";
        String filterFwName = "(org.eclipse.equinox.frameworkhandler.framework.name=Equinox)";
        String filterLauncherName = "(org.eclipse.equinox.frameworkhandler.launcher.name=Eclipse.exe)";
        String filterFwAdmin = "(&" + FILTER_OBJECTCLASS + "(org.eclipse.equinox.frameworkhandler.framework.name=Equinox)(org.eclipse.equinox.frameworkhandler.launcher.name=Eclipse.exe))";
        String FWK_ADMIN_EQ = "org.eclipse.equinox.frameworkadmin.equinox";
        Bundle b = Platform.getBundle((String)FWK_ADMIN_EQ);
        if (b == null) {
            AbstractEnd2EndTest.fail((String)("Bundle: " + FWK_ADMIN_EQ + " is required for this test"));
        }
        try {
            b.start();
        }
        catch (BundleException e) {
            AbstractEnd2EndTest.fail((String)"Can't start framework admin");
        }
        if (this.fwAdminTracker == null) {
            try {
                Filter filter = TestActivator.getContext().createFilter(filterFwAdmin);
                this.fwAdminTracker = new ServiceTracker(TestActivator.getContext(), filter, null);
                this.fwAdminTracker.open();
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
        return (FrameworkAdmin)this.fwAdminTracker.getService();
    }

    protected static String getLauncherName(String name, String os) {
        IPath path;
        EnvironmentInfo info;
        if (os == null && (info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)TestActivator.getContext(), EnvironmentInfo.class)) != null) {
            os = info.getOS();
        }
        if (os.equals("win32")) {
            path = IPath.fromOSString((String)name);
            if ("exe".equals(path.getFileExtension())) {
                return name;
            }
            return name + ".exe";
        }
        if (os.equals("macosx")) {
            path = IPath.fromOSString((String)name);
            if ("app".equals(path.getFileExtension())) {
                return name;
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(name.substring(0, 1).toUpperCase());
            buffer.append(name.substring(1));
            buffer.append(".app/Contents/MacOS/");
            buffer.append(name.toLowerCase());
            return buffer.toString();
        }
        return name;
    }
}

