/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.generator;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.p2.publisher.compatibility.GeneratorApplication;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSitePublisherApplication;
import org.eclipse.equinox.internal.simpleconfigurator.utils.URIUtil;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAndBundlesPublisherApplication;
import org.eclipse.equinox.p2.publisher.eclipse.InstallPublisherApplication;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class GeneratorTests
extends AbstractProvisioningTest {
    public void test233240_artifactsDeleted() throws Exception {
        File rootFolder = this.getTestFolder("artifactsDeleted");
        File plugins = new File(rootFolder, "plugins");
        plugins.mkdir();
        int limit = 3;
        int i = 0;
        while (i < limit) {
            BundleContext context = TestActivator.getContext();
            Bundle bundle = context.getBundle((long)i);
            File bundleFile = (File)FileLocator.getBundleFileLocation((Bundle)bundle).get();
            if (!bundleFile.isFile()) {
                ++limit;
            } else {
                GeneratorTests.copy("1.0 Populating input bundles.", bundleFile, new File(plugins, bundle.getSymbolicName() + "_" + String.valueOf(bundle.getVersion()) + ".jar"));
            }
            ++i;
        }
        String[] arguments = new String[]{"-metadataRepository", rootFolder.toURL().toExternalForm().toString(), "-artifactRepository", rootFolder.toURL().toExternalForm().toString(), "-source", rootFolder.getAbsolutePath(), "-publishArtifacts", "-noDefaultIUs"};
        TestGeneratorApplication application = new TestGeneratorApplication();
        GeneratorTests.assertEquals((Object)0, (Object)application.go(arguments));
        GeneratorTests.assertTrue((String)"2.0 - initial artifact repo existance", (boolean)new File(rootFolder, "artifacts.xml").exists());
        GeneratorTests.assertTrue((String)"2.1 - initial artifact repo contents", (plugins.listFiles().length > 0 ? 1 : 0) != 0);
        application = new TestGeneratorApplication();
        StringBuilder buffer = new StringBuilder();
        try {
            application.go(arguments, buffer);
            GeneratorTests.fail((String)"3.0 - Expected Illegal Argument Exception not thrown.");
        }
        catch (IllegalArgumentException e) {
            GeneratorTests.assertTrue((String)"3.0 - Expected Illegal Argument", (boolean)e.getMessage().equals(NLS.bind((String)Messages.exception_artifactRepoNoAppendDestroysInput, (Object)rootFolder.toURI())));
        }
        String outputString = buffer.toString();
        GeneratorTests.assertTrue((boolean)outputString.contains("Not appending to artifact repository"));
        GeneratorTests.assertTrue((boolean)outputString.contains("may destroy input files."));
        GeneratorTests.assertTrue((String)"3.1 - artifact repo existance", (boolean)new File(rootFolder, "artifacts.xml").exists());
        arguments = new String[]{"-metadataRepository", rootFolder.toURL().toExternalForm().toString(), "-artifactRepository", rootFolder.toURL().toExternalForm().toString(), "-updateSite", rootFolder.getAbsolutePath(), "-publishArtifacts", "-noDefaultIUs"};
        GeneratorTests.assertEquals((Object)0, (Object)application.go(arguments));
        GeneratorTests.assertTrue((String)"4.0 - artifact repo existance", (boolean)new File(rootFolder, "artifacts.xml").exists());
        GeneratorTests.assertTrue((String)"4.1 - artifact repo contents", (plugins.listFiles().length > 0 ? 1 : 0) != 0);
        GeneratorTests.assertEquals((int)3, (int)new File(rootFolder, "plugins").list().length);
        GeneratorTests.delete(rootFolder);
    }

    public void testBasicUpdateSite() throws Exception {
        File rootFolder = this.getTestFolder("basicUpdateSite");
        File updateSite = GeneratorTests.getTestData("1.0 finding update site", "testData/testRepos/updateSite");
        GeneratorTests.copy("2.0 copying update site", updateSite, rootFolder);
        new File(rootFolder, "content.xml").delete();
        new File(rootFolder, "artifacts.xml").delete();
        String[] arguments = new String[]{"-updateSite", rootFolder.getAbsolutePath(), "-site", new File(rootFolder, "site.xml").getAbsolutePath(), "-metadataRepository", URIUtil.toUnencodedString((URI)rootFolder.toURI()), "-artifactRepository", URIUtil.toUnencodedString((URI)rootFolder.toURI()), "-metadataRepositoryName", "Basic Metadata Test Site", "-artifactRepositoryName", "Basic Artifact Test Site", "-compress", "-noDefaultIUs"};
        TestGeneratorApplication app = new TestGeneratorApplication();
        app.go(arguments);
        GeneratorTests.assertTrue((boolean)new File(rootFolder, "artifacts.jar").exists());
        GeneratorTests.assertTrue((boolean)new File(rootFolder, "content.jar").exists());
        IMetadataRepository metadataRepo = this.loadMetadataRepository(rootFolder.toURI());
        GeneratorTests.assertEquals((String)metadataRepo.getName(), (String)"Basic Metadata Test Site");
        File siteXml = new File(rootFolder, "site.xml");
        IInstallableUnit iu = this.getIU(metadataRepo, URIUtil.toUnencodedString((URI)siteXml.toURI()) + ".More Examples");
        GeneratorTests.assertNotNull((Object)iu);
        GeneratorTests.assertEquals((int)iu.getRequirements().size(), (int)3);
        GeneratorTests.assertEquals((String)iu.getProperty("org.eclipse.equinox.p2.type.category"), (String)"true");
        GeneratorTests.assertEquals((String)iu.getProperty("org.eclipse.equinox.p2.name"), (String)"More Fine Examples");
        iu = this.getIU(metadataRepo, URIUtil.toUnencodedString((URI)siteXml.toURI()) + ".Examples");
        GeneratorTests.assertNotNull((Object)iu);
        GeneratorTests.assertEquals((int)iu.getRequirements().size(), (int)5);
        GeneratorTests.assertEquals((String)iu.getProperty("org.eclipse.equinox.p2.type.category"), (String)"true");
        GeneratorTests.assertEquals((String)iu.getProperty("org.eclipse.equinox.p2.name"), (String)"Platform Examples");
        IArtifactRepository artifactRepo = this.loadArtifactRepository(rootFolder.toURI());
        GeneratorTests.assertEquals((String)artifactRepo.getName(), (String)"Basic Artifact Test Site");
    }

    protected class TestGeneratorApplication
    extends GeneratorApplication {
        protected TestGeneratorApplication() {
        }

        protected Object launchApplication(Map<String, Object> applicationMap) {
            try {
                String appId = (String)applicationMap.get("app.id");
                if ("org.eclipse.equinox.p2.publisher.UpdateSitePublisher".equals(appId)) {
                    UpdateSitePublisherApplication app = new UpdateSitePublisherApplication();
                    return app.run((String[])applicationMap.get("application.args"));
                }
                if ("org.eclipse.equinox.p2.publisher.FeaturesAndBundlesPublisher".equals(appId)) {
                    FeaturesAndBundlesPublisherApplication app = new FeaturesAndBundlesPublisherApplication();
                    return app.run((String[])applicationMap.get("application.args"));
                }
                if ("org.eclipse.equinox.p2.publisher.InstallPublisher".equals(appId)) {
                    InstallPublisherApplication app = new InstallPublisherApplication();
                    return app.run((String[])applicationMap.get("application.args"));
                }
            }
            catch (Exception e) {
                return e;
            }
            return null;
        }

        public Object go(String[] arguments) throws Exception {
            return this.go(arguments, new StringBuilder());
        }

        public Object go(String[] arguments, StringBuilder buffer) throws Exception {
            Object result = null;
            PrintStream out = System.out;
            PrintStream err = System.err;
            try {
                PrintStream stream = new PrintStream(new StringBufferStream(buffer));
                System.setOut(stream);
                System.setErr(stream);
                result = this.run(arguments);
            }
            finally {
                System.setOut(out);
                System.setErr(err);
            }
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            return result;
        }
    }
}

