/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.jarprocessor;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.jarprocessor.verifier.Verifier;
import org.eclipse.equinox.internal.p2.jarprocessor.verifier.VerifyStep;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.internal.provisional.equinox.p2.jarprocessor.JarProcessor;
import org.eclipse.internal.provisional.equinox.p2.jarprocessor.JarProcessorExecutor;

public class JarProcessorTests
extends AbstractProvisioningTest {
    public void testVerifyStep() throws Exception {
        if (!VerifyStep.canVerify()) {
            return;
        }
        File workingDir = this.getTestFolder("testVerifyStep");
        Verifier verifier = new Verifier(){

            public void verify(File workingDirectory, String[] input) {
                this.options = new JarProcessorExecutor.Options();
                this.options.verbose = false;
                this.options.pack = false;
                this.options.outputDir = workingDirectory.toString();
                this.options.input = workingDirectory;
                JarProcessor processor = new JarProcessor();
                processor.setWorkingDirectory(workingDirectory.getAbsolutePath());
                FileFilter filter = pathname -> {
                    String name = pathname.getName();
                    return pathname.isFile() && name.endsWith(".jar") && !name.contains("source") && name.startsWith("org.eclipse.equinox.p2");
                };
                String[] stringArray = input;
                int n = input.length;
                int n2 = 0;
                while (n2 < n) {
                    String filename = stringArray[n2];
                    File inputFile = new File(filename);
                    if (inputFile.exists()) {
                        try {
                            this.process(inputFile, filter, true, processor, null);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
        };
        String install = Platform.getInstallLocation().getURL().getPath();
        File plugins = new File(install, "plugins");
        PrintStream oldOut = System.out;
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (PrintStream newOut = new PrintStream(new FileOutputStream(String.valueOf(workingDir) + "/out.out"));){
                System.setOut(newOut);
                verifier.verify(workingDir, new String[]{plugins.getAbsolutePath()});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            System.setOut(oldOut);
        }
    }
}

