/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Assert;
import org.junit.Test;

public class ArtifactKeyParsingTest {
    @Test
    public void testSerialize() {
        ArtifactKey key = new ArtifactKey("classifier", "identifier", Version.create((String)"1.0"));
        Assert.assertEquals((Object)"classifier,identifier,1.0.0", (Object)key.toExternalForm());
    }

    @Test
    public void testSerializeEmptyClassifier() {
        ArtifactKey key = new ArtifactKey("", "identifier", Version.create((String)"1.0"));
        Assert.assertEquals((Object)",identifier,1.0.0", (Object)key.toExternalForm());
    }

    @Test
    public void testDeserialize() {
        IArtifactKey key = ArtifactKey.parse((String)"classifier,identifier,1.0.0");
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"classifier", (Object)key.getClassifier());
        Assert.assertEquals((Object)"identifier", (Object)key.getId());
        Assert.assertEquals((Object)Version.create((String)"1.0"), (Object)key.getVersion());
    }

    @Test
    public void testDeserializeEmptyClassifier() {
        IArtifactKey key = ArtifactKey.parse((String)",identifier,1.0.0");
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"", (Object)key.getClassifier());
        Assert.assertEquals((Object)"identifier", (Object)key.getId());
        Assert.assertEquals((Object)Version.create((String)"1.0"), (Object)key.getVersion());
    }

    @Test
    public void testDeserializeEmptyIdentifier() {
        IArtifactKey key = ArtifactKey.parse((String)"classifier,,1.0.0");
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"classifier", (Object)key.getClassifier());
        Assert.assertEquals((Object)"", (Object)key.getId());
        Assert.assertEquals((Object)Version.create((String)"1.0"), (Object)key.getVersion());
    }

    @Test
    public void testDeserializeEmptyVersion() {
        IArtifactKey key = ArtifactKey.parse((String)"classifier,identifier,");
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"classifier", (Object)key.getClassifier());
        Assert.assertEquals((Object)"identifier", (Object)key.getId());
        Assert.assertEquals((Object)Version.create((String)"0.0"), (Object)key.getVersion());
    }

    @Test
    public void testDeserializeEmptyEverything() {
        IArtifactKey key = ArtifactKey.parse((String)",,");
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"", (Object)key.getClassifier());
        Assert.assertEquals((Object)"", (Object)key.getId());
        Assert.assertEquals((Object)Version.create((String)"0.0"), (Object)key.getVersion());
    }

    @Test
    public void testDeserializeTooFewPartsI() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            IArtifactKey iArtifactKey = ArtifactKey.parse((String)"");
        });
    }

    @Test
    public void testDeserializeTooManyPartsI() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            IArtifactKey iArtifactKey = ArtifactKey.parse((String)",,,,");
        });
    }

    @Test
    public void testDeserializeTooFewPartsII() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            IArtifactKey iArtifactKey = ArtifactKey.parse((String)"classifier");
        });
    }
}

