/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import java.util.Arrays;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class InstallableUnitPatchTest
extends AbstractProvisioningTest {
    public void testLifeCycleRequirement() {
        MetadataFactory.InstallableUnitPatchDescription iu = new MetadataFactory.InstallableUnitPatchDescription();
        iu.setId("P");
        iu.setVersion(Version.create((String)"1.0.0"));
        iu.setApplicabilityScope((IRequirement[][])new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}});
        IRequirement lRequirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"L", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false);
        iu.setLifeCycle(lRequirement);
        iu.setRequirements((IRequirement[])NO_REQUIRES);
        IInstallableUnitPatch p1 = MetadataFactory.createInstallableUnitPatch((MetadataFactory.InstallableUnitPatchDescription)iu);
        InstallableUnitPatchTest.assertEquals((String)"patch requirement must contains the lifecycle, so size must be equal to 1", (int)1, (int)p1.getRequirements().size());
        InstallableUnitPatchTest.assertEquals((String)"patch requirement must contains the lifecycle", (Object)lRequirement, p1.getRequirements().iterator().next());
        MetadataFactory.InstallableUnitPatchDescription iu2 = new MetadataFactory.InstallableUnitPatchDescription();
        iu2.setId("P2");
        iu2.setVersion(Version.create((String)"1.0.0"));
        iu2.setApplicabilityScope((IRequirement[][])new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A2", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}});
        IRequirement l2Requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"L2", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false);
        iu2.setLifeCycle(l2Requirement);
        IRequirement r = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"R", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false);
        iu2.setRequirements(new IRequirement[]{r});
        IInstallableUnitPatch p2 = MetadataFactory.createInstallableUnitPatch((MetadataFactory.InstallableUnitPatchDescription)iu2);
        InstallableUnitPatchTest.assertEquals((String)"patch requirement must contains the lifecycle and the requirement, so size must be equal to 2", (int)2, (int)p2.getRequirements().size());
        InstallableUnitPatchTest.assertContains("patch requirement must contains the lifecycle", p2.getRequirements().iterator(), Arrays.asList(l2Requirement, r));
    }
}

