/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import java.util.HashMap;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ProvidedCapabilityTest
extends AbstractProvisioningTest {
    public void testEquals() {
        IProvidedCapability cap = MetadataFactory.createProvidedCapability((String)"namespace", (String)"name", (Version)DEFAULT_VERSION);
        IProvidedCapability equal = MetadataFactory.createProvidedCapability((String)"namespace", (String)"name", (Version)DEFAULT_VERSION);
        IProvidedCapability notEqual = MetadataFactory.createProvidedCapability((String)"namespace", (String)"name", (Version)Version.createOSGi((int)2, (int)0, (int)0));
        ProvidedCapabilityTest.assertEquals((String)"1.0", (Object)cap, (Object)equal);
        ProvidedCapabilityTest.assertFalse((String)"1.1", (boolean)cap.equals((Object)notEqual));
        ProvidedCapabilityTest.assertFalse((String)"1.1", (boolean)notEqual.equals((Object)cap));
    }

    public void testProperties_Unmodifiable() {
        String namespace = "aNamespace";
        String name = "name";
        Version version = Version.createOSGi((int)2, (int)0, (int)0);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(namespace, name);
        properties.put("version", (String)version);
        IProvidedCapability capability1 = MetadataFactory.createProvidedCapability((String)namespace, properties);
        IProvidedCapability capability2 = MetadataFactory.createProvidedCapability((String)namespace, (String)name, (Version)version);
        ProvidedCapabilityTest.assertEquals((Object)capability1, (Object)capability2);
        try {
            capability1.getProperties().put("key", "value");
            ProvidedCapabilityTest.fail((String)"properties must be unmodifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            capability2.getProperties().put("key", "value");
            ProvidedCapabilityTest.fail((String)"properties must be unmodifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testProperties_Immutable() {
        String namespace = "aNamespace";
        String name = "name";
        Version version = Version.createOSGi((int)2, (int)0, (int)0);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(namespace, name);
        properties.put("version", (String)version);
        IProvidedCapability capability1 = MetadataFactory.createProvidedCapability((String)namespace, properties);
        IProvidedCapability capability2 = MetadataFactory.createProvidedCapability((String)namespace, (String)name, (Version)version);
        properties.put("version", (String)Version.createOSGi((int)9, (int)9, (int)9));
        ProvidedCapabilityTest.assertEquals((Object)capability1, (Object)capability2);
    }

    public void testProperties_NoVersion() {
        String namespace = "aNamespace";
        String name = "name";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(namespace, name);
        IProvidedCapability capability1 = MetadataFactory.createProvidedCapability((String)namespace, properties);
        IProvidedCapability capability2 = MetadataFactory.createProvidedCapability((String)namespace, (String)name, null);
        ProvidedCapabilityTest.assertEquals((Object)capability1, (Object)capability2);
    }
}

