/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.junit.Assert;
import org.junit.Test;

public class RequirementToString {
    @Test
    public void testRequirementWithEmptyRange() {
        IRequirement req = MetadataFactory.createRequirement((String)"expectedNameSpace", (String)"expectedName", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"expectedNameSpace; expectedName 0.0.0", (Object)req.toString());
    }

    @Test
    public void testStandardRequirement() {
        IRequirement req = MetadataFactory.createRequirement((String)"expectedNameSpace", (String)"expectedName", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"expectedNameSpace; expectedName [1.0.0,2.0.0)", (Object)req.toString());
    }

    @Test
    public void testPropertiesRequirement() {
        IRequirement req = MetadataFactory.createRequirement((String)"expectedNameSpace", (String)"(key=val)", null, (int)1, (int)1, (boolean)true);
        Assert.assertEquals((Object)"expectedNameSpace; (key=val)", (Object)req.toString());
    }

    @Test
    public void testFancyRequirement() {
        Object[] expressionParameters = new Object[]{"expectedId1", "expectedVersion1", "expectedId2", "expectedVersion2"};
        IMatchExpression iuMatcher = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)"(id == $0 && version == $1) || (id == $2 && version == $3)"), expressionParameters);
        IRequirement req = MetadataFactory.createRequirement((IMatchExpression)iuMatcher, null, (int)1, (int)1, (boolean)true);
        Assert.assertEquals((Object)"id == $0 && version == $1 || id == $2 && version == $3 (expectedId1, expectedVersion1, expectedId2, expectedVersion2)", (Object)req.toString().trim());
    }
}

