/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.ExpressionParseException;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class FilterTest {
    @Test
    public void testComparable() throws Exception {
        IFilterExpression f1 = ExpressionUtil.parseLDAP((String)"(comparable=42)");
        Map<String, SampleComparable> hash = new HashMap<String, SampleComparable>();
        Comparable<SampleComparable> comp = new SampleComparable("42");
        hash.put("comparable", (SampleComparable)comp);
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        comp = 42L;
        hash.put("comparable", (SampleComparable)comp);
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        Assert.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        IFilterExpression f2 = ExpressionUtil.parseLDAP((String)"(comparable=42)");
        hash = new Hashtable();
        comp = new SampleComparable("42");
        hash.put("comparable", (SampleComparable)comp);
        Assert.assertTrue((String)"does not match filter", (boolean)f2.match(hash));
        Assert.assertTrue((String)"does not match filter", (boolean)f2.match((ServiceReference)new DictionaryServiceReference(hash)));
        comp = 42L;
        hash.put("comparable", (SampleComparable)comp);
        Assert.assertTrue((String)"does not match filter", (boolean)f2.match(hash));
        Assert.assertTrue((String)"does not match filter", (boolean)f2.match((ServiceReference)new DictionaryServiceReference(hash)));
        Assert.assertEquals((String)"not equal", (Object)f1, (Object)f2);
    }

    @Test
    public void testFilterEquality() {
        IFilterExpression f1 = ExpressionUtil.parseLDAP((String)"( a = bedroom  )");
        IFilterExpression f2 = ExpressionUtil.parseLDAP((String)" (a= bedroom  ) ");
        Assert.assertEquals((String)"not equal", (Object)"(a= bedroom  )", (Object)f1.toString());
        Assert.assertEquals((String)"not equal", (Object)"(a= bedroom  )", (Object)f2.toString());
        Assert.assertEquals((String)"not equal", (Object)f1, (Object)f2);
        Assert.assertEquals((String)"not equal", (Object)f2, (Object)f1);
        Assert.assertEquals((String)"not equal", (long)f1.hashCode(), (long)f2.hashCode());
        f1 = ExpressionUtil.parseLDAP((String)"(status =\\28o*\\5c\\29\\2a)");
        Assert.assertEquals((String)"not equal", (Object)"(status=\\28o*\\5c\\29\\2a)", (Object)f1.toString());
        f1 = ExpressionUtil.parseLDAP((String)"(|(a=1)(&(a=1)(b=1)))");
        f2 = ExpressionUtil.parseLDAP((String)"(a=1)");
        f1 = ExpressionUtil.parseLDAP((String)"(|(&(os=macos)(ws=cocoa)(arch=x86))(&(ws=cocoa)(os=macos)(arch=ppc)))");
        f2 = ExpressionUtil.parseLDAP((String)"(&(os=macos)(ws=cocoa)(|(arch=x86)(arch=ppc)))");
        Assert.assertEquals((String)("not equal: f1:" + f1.toString() + ", f2:" + f1.toString()), (Object)f1, (Object)f2);
        f1 = ExpressionUtil.parseLDAP((String)"(&(|(x=a)(y=b)(z=a))(|(x=a)(y=b)(z=b)))");
        f2 = ExpressionUtil.parseLDAP((String)"(|(x=a)(y=b)(&(z=a)(z=b)))");
        Assert.assertEquals((String)("not equal: f1:" + f1.toString() + ", f2:" + f1.toString()), (Object)f1, (Object)f2);
        f1 = ExpressionUtil.parseLDAP((String)"(&(a=1)(|(a=1)(b=1)))");
        f2 = ExpressionUtil.parseLDAP((String)"(a=1)");
        f1 = ExpressionUtil.parseLDAP((String)"(|(a=1)(&(a=1)(b=1)))");
        f2 = ExpressionUtil.parseLDAP((String)"(a=1)");
        Assert.assertEquals((String)("not equal: f1:" + f1.toString() + ", f2:" + f1.toString()), (Object)f1, (Object)f2);
    }

    @Test
    public void testFilterMatching() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("room", "bedroom");
        ((Dictionary)props).put("channel", 34);
        ((Dictionary)props).put("status", "(on\\)*");
        ((Dictionary)props).put("max record time", 150L);
        ((Dictionary)props).put("canrecord", "true(x)");
        ((Dictionary)props).put("shortvalue", (short)1000);
        ((Dictionary)props).put("bytevalue", (byte)10);
        ((Dictionary)props).put("floatvalue", Float.valueOf(1.01f));
        ((Dictionary)props).put("doublevalue", 2.01);
        ((Dictionary)props).put("charvalue", Character.valueOf('A'));
        ((Dictionary)props).put("booleanvalue", Boolean.FALSE);
        ((Dictionary)props).put("listvalue", Arrays.asList(1, 2, 3));
        ((Dictionary)props).put("versionlistvalue", Arrays.asList(Version.create((String)"1"), Version.create((String)"2"), Version.create((String)"3")));
        ((Dictionary)props).put("weirdvalue", new Hashtable());
        ((Dictionary)props).put("bigintvalue", new BigInteger("4123456"));
        ((Dictionary)props).put("bigdecvalue", new BigDecimal("4.123456"));
        this.assertMatch("(room=*)", props);
        this.assertNoMatch("(rooom=*)", props);
        this.assertMatch("(room=bedroom)", props);
        this.assertMatch("(room~= B E D R O O M )", props);
        this.assertNoMatch("(room=abc)", props);
        this.assertMatch(" ( room >=aaaa)", props);
        this.assertNoMatch("(room <=aaaa)", props);
        this.assertMatch("  ( room =b*) ", props);
        this.assertMatch("  ( room =*m) ", props);
        this.assertMatch("(room=bed*room)", props);
        this.assertMatch("  ( room =b*oo*m) ", props);
        this.assertMatch("  ( room =*b*oo*m*) ", props);
        this.assertNoMatch("  ( room =b*b*  *m*) ", props);
        this.assertMatch("  (& (room =bedroom) (channel = 34))", props);
        this.assertNoMatch("  (&  (room =b*)  (room =*x) (channel=34))", props);
        this.assertMatch("(| (room =bed*)(channel=222)) ", props);
        this.assertMatch("(| (room =boom*)(channel=34)) ", props);
        this.assertMatch("  (! (room =ab*b*oo*m*) ) ", props);
        this.assertMatch("  (status =\\(o*\\\\\\)\\*) ", props);
        this.assertMatch("  (status =\\28o*\\5c\\29\\2a) ", props);
        this.assertMatch("  (status =\\28o*\\5C\\29\\2A) ", props);
        this.assertMatch("  (canRecord =true\\(x\\)) ", props);
        this.assertMatch("(max Record Time <=150) ", props);
        this.assertMatch("(shortValue >= 100) ", props);
        this.assertMatch("  (  &  (  byteValue <= 100  )  (  byteValue >= 10  )  )  ", props);
        this.assertMatch("(bigIntValue = 4123456) ", props);
        this.assertMatch("(bigDecValue = 4.123456) ", props);
        this.assertMatch("(floatValue >= 1.0) ", props);
        this.assertMatch("(doubleValue <= 2.011) ", props);
        this.assertMatch("(charValue ~= a) ", props);
        this.assertMatch("(booleanValue = false) ", props);
        this.assertMatch("(listvalue>=0)", props);
        this.assertMatch("(listvalue=3)", props);
        this.assertMatch("(!(listvalue>=4))", props);
        this.assertMatch("(versionlistvalue>=0)", props);
        this.assertMatch("(versionlistvalue=3)", props);
        this.assertMatch("(!(versionlistvalue>=4))", props);
        this.assertMatch("(& (| (room =d*m) (room =bed*) (room=abc)) (! (channel=999)))", props);
        this.assertNoMatch("(room=bedroom)", null);
        this.assertNoMatch("(weirdValue = 100) ", props);
    }

    @Test
    public void testFilterParserErrors() {
        this.assertParseError("()");
        this.assertParseError("(=foo)");
        this.assertParseError("(");
        this.assertParseError("(abc = ))");
        this.assertParseError("(& (abc = xyz) (& (345))");
        this.assertParseError("  (room = b**oo!*m*) ) ");
        this.assertParseError("  (room = b**oo)*m*) ) ");
        this.assertParseError("  (room = *=b**oo*m*) ) ");
        this.assertParseError("  (room = =b**oo*m*) ) ");
    }

    private void assertMatch(String query, Dictionary<String, Object> props) {
        this.expectMatch(query, props, true);
    }

    private void assertNoMatch(String query, Dictionary<String, Object> props) {
        this.expectMatch(query, props, false);
    }

    private void expectMatch(String query, Dictionary<String, Object> props, boolean match) {
        IFilterExpression f = ExpressionUtil.parseLDAP((String)query);
        Assert.assertEquals((Object)match, (Object)f.match(props));
        DictionaryServiceReference ref = new DictionaryServiceReference((Map)((Object)props));
        Assert.assertEquals((Object)match, (Object)f.match((ServiceReference)ref));
    }

    private void assertParseError(String query) {
        try {
            ExpressionUtil.parseLDAP((String)query);
            Assert.fail((String)"expected exception");
        }
        catch (ExpressionParseException expressionParseException) {
            // empty catch block
        }
    }

    private static class DictionaryServiceReference
    implements ServiceReference {
        private final Map<String, ? extends Object> dictionary;
        private final String[] keys;

        DictionaryServiceReference(Map<String, ? extends Object> dictionary) {
            if (dictionary == null) {
                this.dictionary = null;
                this.keys = new String[0];
                return;
            }
            this.dictionary = dictionary;
            ArrayList<String> keyList = new ArrayList<String>(dictionary.size());
            for (String key : dictionary.keySet()) {
                for (String string : keyList) {
                    if (!key.equalsIgnoreCase(string)) continue;
                    throw new IllegalArgumentException();
                }
                keyList.add(key);
            }
            this.keys = keyList.toArray(new String[keyList.size()]);
        }

        public int compareTo(Object reference) {
            throw new UnsupportedOperationException();
        }

        public Bundle getBundle() {
            return null;
        }

        public Object getProperty(String k) {
            String[] stringArray = this.keys;
            int n = this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.equalsIgnoreCase(k)) {
                    return this.dictionary.get(key);
                }
                ++n2;
            }
            return null;
        }

        public String[] getPropertyKeys() {
            return (String[])this.keys.clone();
        }

        public Bundle[] getUsingBundles() {
            throw new UnsupportedOperationException();
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            throw new UnsupportedOperationException();
        }

        public Dictionary<String, Object> getProperties() {
            return new Hashtable<String, Object>(this.dictionary);
        }

        public Object adapt(Class type) {
            return null;
        }
    }

    private static class SampleComparable
    implements Comparable<SampleComparable> {
        private int value = -1;

        public SampleComparable(String value) {
            this.value = Integer.parseInt(value);
        }

        public boolean equals(Object o) {
            return o instanceof SampleComparable && this.value == ((SampleComparable)o).value;
        }

        @Override
        public int compareTo(SampleComparable o) {
            return this.value - o.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

