/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class BatchExecuteMetadataRepositoryTest
extends AbstractProvisioningTest {
    private File repositoryFile = null;
    private URI repositoryURI = null;

    protected Collection<IInstallableUnit> createIUInCollection(String id, Version version) {
        IInstallableUnit iu = BatchExecuteMetadataRepositoryTest.createIU(id, version);
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(1);
        result.add(iu);
        return result;
    }

    boolean fileContainsString(URI location, String string) throws IOException {
        StringBuilder buffer = new StringBuilder();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(location)));){
            while (reader.ready()) {
                buffer.append(reader.readLine());
            }
            return buffer.toString().contains(string);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testAdd() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            LocalMetadataRepository repo = (LocalMetadataRepository)BatchExecuteMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            URI contentXML = new URI(this.repositoryFile.toURI().toString() + "/content.xml");
            IStatus status = repo.executeBatch(monitor -> {
                repo.addInstallableUnits(this.createIUInCollection("foo", Version.emptyVersion));
                try {
                    BatchExecuteMetadataRepositoryTest.assertFalse((String)"1.0", (boolean)this.fileContainsString(contentXML, "foo"));
                }
                catch (IOException e) {
                    BatchExecuteMetadataRepositoryTest.fail((String)"0.99");
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteMetadataRepositoryTest.assertTrue((boolean)status.isOK());
            BatchExecuteMetadataRepositoryTest.assertTrue((String)"1.0", (boolean)this.fileContainsString(contentXML, "foo"));
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"2.0", (int)1, (int)repo.query(QueryUtil.createIUQuery((String)"foo"), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testMultiAdd() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            LocalMetadataRepository repo = (LocalMetadataRepository)BatchExecuteMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            URI contentXML = new URI(this.repositoryFile.toURI().toString() + "/content.xml");
            IStatus status = repo.executeBatch(monitor -> {
                repo.addInstallableUnits(this.createIUInCollection("foo", Version.emptyVersion));
                repo.addInstallableUnits(this.createIUInCollection("bar", Version.emptyVersion));
                repo.addInstallableUnits(this.createIUInCollection("baz", Version.emptyVersion));
                try {
                    BatchExecuteMetadataRepositoryTest.assertFalse((String)"1.0", (boolean)this.fileContainsString(contentXML, "foo"));
                    BatchExecuteMetadataRepositoryTest.assertFalse((String)"1.0", (boolean)this.fileContainsString(contentXML, "bar"));
                    BatchExecuteMetadataRepositoryTest.assertFalse((String)"1.0", (boolean)this.fileContainsString(contentXML, "baz"));
                }
                catch (IOException e) {
                    BatchExecuteMetadataRepositoryTest.fail((String)"0.99");
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteMetadataRepositoryTest.assertTrue((boolean)status.isOK());
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"1.0", (int)1, (int)repo.query(QueryUtil.createIUQuery((String)"foo"), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"1.1", (int)1, (int)repo.query(QueryUtil.createIUQuery((String)"bar"), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"1.2", (int)1, (int)repo.query(QueryUtil.createIUQuery((String)"baz"), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteMetadataRepositoryTest.assertTrue((String)"2.0", (boolean)this.fileContainsString(contentXML, "foo"));
            BatchExecuteMetadataRepositoryTest.assertTrue((String)"2.1", (boolean)this.fileContainsString(contentXML, "bar"));
            BatchExecuteMetadataRepositoryTest.assertTrue((String)"2.2", (boolean)this.fileContainsString(contentXML, "baz"));
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testMultiAddWithException() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            LocalMetadataRepository repo = (LocalMetadataRepository)BatchExecuteMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            URI contentXML = new URI(this.repositoryFile.toURI().toString() + "/content.xml");
            IStatus status = repo.executeBatch(monitor -> {
                repo.addInstallableUnits(this.createIUInCollection("foo", Version.emptyVersion));
                repo.addInstallableUnits(this.createIUInCollection("bar", Version.emptyVersion));
                throw new RuntimeException();
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteMetadataRepositoryTest.assertFalse((boolean)status.isOK());
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"1.0", (int)1, (int)repo.query(QueryUtil.createIUQuery((String)"foo"), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"1.1", (int)1, (int)repo.query(QueryUtil.createIUQuery((String)"bar"), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteMetadataRepositoryTest.assertTrue((String)"2.0", (boolean)this.fileContainsString(contentXML, "foo"));
            BatchExecuteMetadataRepositoryTest.assertTrue((String)"2.1", (boolean)this.fileContainsString(contentXML, "bar"));
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testAddAndRemove() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            LocalMetadataRepository repo = (LocalMetadataRepository)BatchExecuteMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            URI contentXML = new URI(this.repositoryFile.toURI().toString() + "/content.xml");
            IStatus status = repo.executeBatch(monitor -> {
                Collection<IInstallableUnit> foo = this.createIUInCollection("foo", Version.emptyVersion);
                repo.addInstallableUnits(foo);
                repo.addInstallableUnits(this.createIUInCollection("bar", Version.emptyVersion));
                repo.removeInstallableUnits(foo);
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteMetadataRepositoryTest.assertTrue((boolean)status.isOK());
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"1.0", (int)0, (int)repo.query(QueryUtil.createIUQuery((String)"foo"), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"1.1", (int)1, (int)repo.query(QueryUtil.createIUQuery((String)"bar"), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteMetadataRepositoryTest.assertFalse((String)"2.0", (boolean)this.fileContainsString(contentXML, "foo"));
            BatchExecuteMetadataRepositoryTest.assertTrue((String)"2.1", (boolean)this.fileContainsString(contentXML, "bar"));
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testMultiAddAndRemove() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            LocalMetadataRepository repo = (LocalMetadataRepository)BatchExecuteMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            URI contentXML = new URI(this.repositoryFile.toURI().toString() + "/content.xml");
            IStatus status = repo.executeBatch(monitor -> {
                repo.addInstallableUnits(this.createIUInCollection("1", Version.emptyVersion));
                repo.addInstallableUnits(this.createIUInCollection("2", Version.emptyVersion));
                repo.addInstallableUnits(this.createIUInCollection("3", Version.emptyVersion));
                Collection<IInstallableUnit> foo = this.createIUInCollection("foo", Version.emptyVersion);
                repo.addInstallableUnits(foo);
                repo.addInstallableUnits(this.createIUInCollection("bar", Version.emptyVersion));
                repo.removeInstallableUnits(foo);
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteMetadataRepositoryTest.assertTrue((boolean)status.isOK());
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"1.0", (int)4, (int)repo.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()).toSet().size());
            BatchExecuteMetadataRepositoryTest.assertFalse((String)"2.0", (boolean)this.fileContainsString(contentXML, "foo"));
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingOK() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            LocalMetadataRepository repo = (LocalMetadataRepository)BatchExecuteMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            IStatus status = repo.executeBatch(monitor -> {}, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteMetadataRepositoryTest.assertTrue((boolean)status.isOK());
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingExceptionsSimple() {
        try {
            FailingSimpleMetadataRepository simpleMetadataRepository = new FailingSimpleMetadataRepository();
            IStatus status = simpleMetadataRepository.executeBatch(monitor -> {
                throw new RuntimeException("bar");
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteMetadataRepositoryTest.assertFalse((boolean)status.isOK());
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"foo", (String)status.getException().getMessage());
            BatchExecuteMetadataRepositoryTest.assertEquals((int)1, (int)status.getChildren().length);
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"bar", (String)status.getChildren()[0].getMessage());
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingSaveExceptionSimple() {
        try {
            FailingSimpleMetadataRepository simpleMetadataRepository = new FailingSimpleMetadataRepository();
            IStatus status = simpleMetadataRepository.executeBatch(monitor -> {}, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteMetadataRepositoryTest.assertFalse((boolean)status.isOK());
            BatchExecuteMetadataRepositoryTest.assertEquals((String)"foo", (String)status.getException().getMessage());
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingTrackSaving() {
        try {
            TrackSavignSimpleMetadataRepository simpleMetadataRepository = new TrackSavignSimpleMetadataRepository();
            simpleMetadataRepository.executeBatch(monitor -> {}, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteMetadataRepositoryTest.assertTrue((boolean)simpleMetadataRepository.didSave);
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testBatchProcessingTrackSavingException() {
        try {
            TrackSavignSimpleMetadataRepository simpleMetadataRepository = new TrackSavignSimpleMetadataRepository();
            simpleMetadataRepository.executeBatch(monitor -> {
                throw new RuntimeException();
            }, (IProgressMonitor)new NullProgressMonitor());
            BatchExecuteMetadataRepositoryTest.assertTrue((boolean)simpleMetadataRepository.didSave);
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testDisableSaveFlagResetSimple() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            LocalMetadataRepository repo = (LocalMetadataRepository)BatchExecuteMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            repo.executeBatch(monitor -> {
                throw new RuntimeException();
            }, (IProgressMonitor)new NullProgressMonitor());
            Field field = LocalMetadataRepository.class.getDeclaredField("disableSave");
            field.setAccessible(true);
            boolean disableSave = field.getBoolean(repo);
            BatchExecuteMetadataRepositoryTest.assertFalse((String)"1.0", (boolean)disableSave);
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    public void testDisableSaveFlagDuringExecutionSimple() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            HashMap properties = new HashMap();
            LocalMetadataRepository repo = (LocalMetadataRepository)BatchExecuteMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            repo.executeBatch(monitor -> {
                try {
                    Field field = LocalMetadataRepository.class.getDeclaredField("disableSave");
                    field.setAccessible(true);
                    boolean disableSave = field.getBoolean(repo);
                    BatchExecuteMetadataRepositoryTest.assertTrue((String)"1.0", (boolean)disableSave);
                }
                catch (SecurityException e1) {
                    BatchExecuteMetadataRepositoryTest.fail((String)("1.1" + e1.getMessage()));
                }
                catch (NoSuchFieldException e2) {
                    BatchExecuteMetadataRepositoryTest.fail((String)("1.2" + e2.getMessage()));
                }
                catch (IllegalArgumentException e3) {
                    BatchExecuteMetadataRepositoryTest.fail((String)("1.2" + e3.getMessage()));
                }
                catch (IllegalAccessException e4) {
                    BatchExecuteMetadataRepositoryTest.fail((String)("1.2" + e4.getMessage()));
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            BatchExecuteMetadataRepositoryTest.fail("Test failed", e);
        }
    }

    class FailingSimpleMetadataRepository
    extends LocalMetadataRepository {
        boolean executeBatch;

        public FailingSimpleMetadataRepository() {
            super(BatchExecuteMetadataRepositoryTest.getAgent());
            this.executeBatch = false;
        }

        public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
            this.executeBatch = true;
            return super.executeBatch(runnable, monitor);
        }

        public void save() {
            if (this.executeBatch) {
                throw new RuntimeException("foo");
            }
        }
    }

    class TrackSavignSimpleMetadataRepository
    extends LocalMetadataRepository {
        boolean executeBatch;
        public boolean didSave;

        public TrackSavignSimpleMetadataRepository() {
            super(BatchExecuteMetadataRepositoryTest.getAgent());
            this.executeBatch = false;
            this.didSave = false;
        }

        public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
            this.executeBatch = true;
            return super.executeBatch(runnable, monitor);
        }

        public void save() {
            if (this.executeBatch) {
                this.didSave = true;
            }
        }
    }
}

