/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.core.CompoundQueryableTest;

public class CompositeMetadataRepositoryTest
extends AbstractProvisioningTest {
    private static final String TEST_KEY = "TestKey";
    private static final String TEST_VALUE = "TestValue";
    protected File repoLocation;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.repoLocation = new File(this.getTempFolder(), "CompositeMetadataRepositoryTest");
        AbstractProvisioningTest.delete(this.repoLocation);
    }

    @Override
    protected void tearDown() throws Exception {
        CompositeMetadataRepositoryTest.getMetadataRepositoryManager().removeRepository(this.repoLocation.toURI());
        CompositeMetadataRepositoryTest.delete(this.repoLocation);
        super.tearDown();
    }

    public void testCompressedRepositoryCreation() {
        this.createRepo(true);
        File[] files = this.repoLocation.listFiles();
        boolean jarFilePresent = false;
        boolean xmlFilePresent = false;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if ("compositeContent.jar".equalsIgnoreCase(file.getName())) {
                jarFilePresent = true;
            }
            if ("compositeContent.xml".equalsIgnoreCase(file.getName())) {
                xmlFilePresent = true;
            }
            ++n2;
        }
        if (!jarFilePresent) {
            CompositeMetadataRepositoryTest.fail((String)"Repository did not create JAR for compositeContent.xml");
        }
        if (xmlFilePresent) {
            CompositeMetadataRepositoryTest.fail((String)"Repository should not create compositeContent.xml");
        }
    }

    public void testUncompressedRepositoryCreation() {
        this.createRepo(false);
        File[] files = this.repoLocation.listFiles();
        boolean jarFilePresent = false;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if ("compositeContent.jar".equalsIgnoreCase(file.getName())) {
                jarFilePresent = true;
            }
            ++n2;
        }
        if (jarFilePresent) {
            CompositeMetadataRepositoryTest.fail((String)"Repository should not create JAR for compositeContent.xml");
        }
    }

    public void testAddInstallableUnits() {
        CompositeMetadataRepository compRepo = this.createRepo(false);
        try {
            MetadataFactory.InstallableUnitDescription descriptor = new MetadataFactory.InstallableUnitDescription();
            descriptor.setId("testIuId");
            descriptor.setVersion(Version.create((String)"3.2.1"));
            IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
            compRepo.addInstallableUnits(Arrays.asList(iu));
            CompositeMetadataRepositoryTest.fail((String)"Should not be able to insert InstallableUnit");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoveInstallableUnits() {
        CompositeMetadataRepository compRepo = this.createRepo(false);
        try {
            IQueryResult queryResult = compRepo.query(QueryUtil.createIUAnyQuery(), null);
            compRepo.removeInstallableUnits((Collection)queryResult.toSet());
            CompositeMetadataRepositoryTest.fail((String)"Should not be able to remove InstallableUnit");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoveAll() {
        CompositeMetadataRepository compRepo = this.createRepo(false);
        try {
            compRepo.removeAll();
            CompositeMetadataRepositoryTest.fail((String)"Should not be able to removeAll()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetProperties() {
        IMetadataRepositoryManager manager = CompositeMetadataRepositoryTest.getMetadataRepositoryManager();
        IMetadataRepository repo = null;
        try {
            repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.compositeRepository", null);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.fail("Cannot create repository: ", e);
        }
        Map properties = repo.getProperties();
        try {
            properties.put(TEST_KEY, TEST_VALUE);
            CompositeMetadataRepositoryTest.fail((String)"Should not allow setting property");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testSetProperty() {
        IMetadataRepositoryManager manager = CompositeMetadataRepositoryTest.getMetadataRepositoryManager();
        IMetadataRepository repo = null;
        try {
            repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.compositeRepository", null);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.fail("Cannot create repository: ", e);
        }
        Map properties = repo.getProperties();
        CompositeMetadataRepositoryTest.assertTrue((String)"1.0", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
        repo.setProperty(TEST_KEY, TEST_VALUE);
        CompositeMetadataRepositoryTest.assertTrue((String)"1.1", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
        properties = repo.getProperties();
        CompositeMetadataRepositoryTest.assertTrue((String)"1.2", (boolean)properties.containsKey(TEST_KEY));
        try {
            repo = manager.loadRepository(this.repoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.fail("Cannot load repository: ", e);
        }
        properties = repo.getProperties();
        CompositeMetadataRepositoryTest.assertTrue((String)"1.3", (boolean)properties.containsKey(TEST_KEY));
        repo.setProperty(TEST_KEY, null);
        properties = repo.getProperties();
        CompositeMetadataRepositoryTest.assertTrue((String)"1.4", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
    }

    public void testAddChild() {
        CompositeMetadataRepository compRepo = this.createRepo(false);
        CompositeMetadataRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child = CompositeMetadataRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        IMetadataRepositoryManager metadataRepositoryManager = CompositeMetadataRepositoryTest.getMetadataRepositoryManager();
        IMetadataRepository repo = null;
        try {
            repo = metadataRepositoryManager.loadRepository(child.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.fail("Unable to load repository for verification", e);
        }
        CompositeMetadataRepositoryTest.assertContentEquals("Verifying contents", (IMetadataRepository)compRepo, repo);
    }

    public void testRemoveChild() {
        CompositeMetadataRepository compRepo = this.createRepo(false);
        CompositeMetadataRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child = CompositeMetadataRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        compRepo.removeChild(child.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size after remove", (int)0, (int)compRepo.getChildren().size());
    }

    public void testAddRepeatChild() {
        CompositeMetadataRepository compRepo = this.createRepo(false);
        CompositeMetadataRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child = CompositeMetadataRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        compRepo.addChild(child.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size after repeat entry", (int)1, (int)compRepo.getChildren().size());
    }

    public void testAddMultipleChildren() {
        CompositeMetadataRepository compRepo = this.createRepo(false);
        CompositeMetadataRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child1 = CompositeMetadataRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child1.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        File child2 = CompositeMetadataRepositoryTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        compRepo.addChild(child2.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size with 2 children", (int)2, (int)compRepo.getChildren().size());
        IMetadataRepositoryManager metadataRepositoryManager = CompositeMetadataRepositoryTest.getMetadataRepositoryManager();
        IMetadataRepository repo1 = null;
        IMetadataRepository repo2 = null;
        try {
            repo1 = metadataRepositoryManager.loadRepository(child1.toURI(), null);
            repo2 = metadataRepositoryManager.loadRepository(child2.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.fail("Unable to load repositories for verification", e);
        }
        CompositeMetadataRepositoryTest.assertContains("Assert child1's content is in composite repo", repo1, (IMetadataRepository)compRepo);
        CompositeMetadataRepositoryTest.assertContains("Assert child2's content is in composite repo", repo2, (IMetadataRepository)compRepo);
        CompositeMetadataRepositoryTest.assertEquals((String)"Assert correct number of IUs", (int)this.getNumUnique((IQueryResult<IInstallableUnit>)repo1.query(QueryUtil.createIUAnyQuery(), null), (IQueryResult<IInstallableUnit>)repo2.query(QueryUtil.createIUAnyQuery(), null)), (int)compRepo.query(QueryUtil.createIUAnyQuery(), null).toUnmodifiableSet().size());
    }

    public void testRemoveNonexistantChild() {
        CompositeMetadataRepository compRepo = this.createRepo(false);
        CompositeMetadataRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child = CompositeMetadataRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        File invalidChild = CompositeMetadataRepositoryTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        compRepo.removeChild(invalidChild.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size after remove", (int)1, (int)compRepo.getChildren().size());
    }

    public void testRemoveAllChildren() {
        CompositeMetadataRepository compRepo = this.createRepo(false);
        CompositeMetadataRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child1 = CompositeMetadataRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child1.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        File child2 = CompositeMetadataRepositoryTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        compRepo.addChild(child2.toURI());
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size with 2 children", (int)2, (int)compRepo.getChildren().size());
        compRepo.removeAllChildren();
        CompositeMetadataRepositoryTest.assertEquals((String)"Children size after removeAllChildren", (int)0, (int)compRepo.getChildren().size());
    }

    public void testLoadingRepositoryRemote() {
        CompositeMetadataRepository compRepo;
        block7: {
            File knownGoodRepoLocation = CompositeMetadataRepositoryTest.getTestData("0.1", "/testData/metadataRepo/composite/good.remote");
            compRepo = null;
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream()));
                    compRepo = (CompositeMetadataRepository)CompositeMetadataRepositoryTest.getMetadataRepositoryManager().loadRepository(knownGoodRepoLocation.toURI(), null);
                }
                catch (ProvisionException e) {
                    CompositeMetadataRepositoryTest.fail("0.99", e);
                    System.setOut(out);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        List children = compRepo.getChildren();
        try {
            URI child1 = URIUtil.fromString((String)"http://www.eclipse.org/foo");
            CompositeMetadataRepositoryTest.assertTrue((String)"1.0", (boolean)children.contains(child1));
            URI child2 = URIUtil.fromString((String)"http://www.eclipse.org/bar");
            CompositeMetadataRepositoryTest.assertTrue((String)"1.1", (boolean)children.contains(child2));
            CompositeMetadataRepositoryTest.assertEquals((String)"1.2", (int)2, (int)children.size());
        }
        catch (URISyntaxException e) {
            CompositeMetadataRepositoryTest.fail("1.99", e);
        }
        CompositeMetadataRepositoryTest.assertEquals((String)"2.0", (String)"metadata name", (String)compRepo.getName());
        Map properties = compRepo.getProperties();
        CompositeMetadataRepositoryTest.assertEquals((String)"2.1", (int)3, (int)properties.size());
        String timestamp = (String)properties.get("p2.timestamp");
        CompositeMetadataRepositoryTest.assertNotNull((String)"2.2", (Object)timestamp);
        CompositeMetadataRepositoryTest.assertEquals((String)"2.3", (String)"1234", (String)timestamp);
        String compressed = (String)properties.get("p2.compressed");
        CompositeMetadataRepositoryTest.assertNotNull((String)"2.4", (Object)compressed);
        CompositeMetadataRepositoryTest.assertFalse((String)"2.5", (boolean)Boolean.parseBoolean(compressed));
    }

    public void testLoadingRepositoryLocal() {
        File testData = CompositeMetadataRepositoryTest.getTestData("0.5", "/testData/metadataRepo/composite/good.local");
        CompositeMetadataRepositoryTest.copy("0.6", testData, this.repoLocation);
        CompositeMetadataRepository compRepo = null;
        try {
            compRepo = (CompositeMetadataRepository)CompositeMetadataRepositoryTest.getMetadataRepositoryManager().loadRepository(this.repoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.fail("0.9", e);
        }
        List children = compRepo.getChildren();
        URI child1 = URIUtil.append((URI)compRepo.getLocation(), (String)"one");
        CompositeMetadataRepositoryTest.assertTrue((String)"1.0", (boolean)children.contains(child1));
        URI child2 = URIUtil.append((URI)compRepo.getLocation(), (String)"two");
        CompositeMetadataRepositoryTest.assertTrue((String)"1.1", (boolean)children.contains(child2));
        CompositeMetadataRepositoryTest.assertEquals((String)"1.2", (int)2, (int)children.size());
        CompositeMetadataRepositoryTest.assertEquals((String)"2.0", (String)"metadata name", (String)compRepo.getName());
        Map properties = compRepo.getProperties();
        CompositeMetadataRepositoryTest.assertEquals((String)"2.1", (int)2, (int)properties.size());
        String timestamp = (String)properties.get("p2.timestamp");
        CompositeMetadataRepositoryTest.assertNotNull((String)"2.2", (Object)timestamp);
        CompositeMetadataRepositoryTest.assertEquals((String)"2.3", (String)"1234", (String)timestamp);
        String compressed = (String)properties.get("p2.compressed");
        CompositeMetadataRepositoryTest.assertNotNull((String)"2.4", (Object)compressed);
        CompositeMetadataRepositoryTest.assertFalse((String)"2.5", (boolean)Boolean.parseBoolean(compressed));
    }

    public void testCompressedPersistence() {
        this.persistenceTest(true);
    }

    public void testUncompressedPersistence() {
        this.persistenceTest(false);
    }

    public void testSyntaxErrorWhileParsing() {
        File badCompositeContent = CompositeMetadataRepositoryTest.getTestData("1", "/testData/metadataRepo/composite/Bad/syntaxError");
        StringBuilder buffer = new StringBuilder();
        PrintStream err = System.err;
        try {
            try {
                System.setErr(new PrintStream(new StringBufferStream(buffer)));
                CompositeMetadataRepositoryTest.getMetadataRepositoryManager().loadRepository(badCompositeContent.toURI(), null);
                CompositeMetadataRepositoryTest.fail((String)"Expected ProvisionException has not been thrown");
            }
            catch (ProvisionException e) {
                CompositeMetadataRepositoryTest.assertTrue((boolean)buffer.toString().contains("The element type \"children\" must be terminated by the matching end-tag \"</children>\"."));
                System.setErr(err);
            }
        }
        finally {
            System.setErr(err);
        }
    }

    public void testMissingRequireattributeWhileParsing() {
        CompositeMetadataRepository compRepo;
        block5: {
            File badCompositeContent = CompositeMetadataRepositoryTest.getTestData("0.1", "/testData/metadataRepo/composite/Bad/missingRequiredAttribute");
            CompositeMetadataRepositoryTest.copy("0.2", badCompositeContent, this.repoLocation);
            compRepo = null;
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream()));
                    compRepo = (CompositeMetadataRepository)CompositeMetadataRepositoryTest.getMetadataRepositoryManager().loadRepository(this.repoLocation.toURI(), null);
                }
                catch (ProvisionException e) {
                    CompositeMetadataRepositoryTest.fail("1.99", e);
                    System.setOut(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        CompositeMetadataRepositoryTest.assertEquals((String)"2.0", (int)1, (int)compRepo.getChildren().size());
    }

    public void testEnabledAndSystemValues() {
        File repo1Location = this.getTestFolder(CompositeMetadataRepositoryTest.getUniqueString());
        File repo2Location = this.getTestFolder(CompositeMetadataRepositoryTest.getUniqueString());
        File compRepoLocation = this.getTestFolder(CompositeMetadataRepositoryTest.getUniqueString());
        CompositeMetadataRepository compRepo = null;
        try {
            CompositeMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(repo1Location.toURI(), "Repo 1", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
            CompositeMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(repo2Location.toURI(), "Repo 2", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
            CompositeMetadataRepositoryTest.getMetadataRepositoryManager().removeRepository(repo2Location.toURI());
            compRepo = (CompositeMetadataRepository)CompositeMetadataRepositoryTest.getMetadataRepositoryManager().createRepository(compRepoLocation.toURI(), "Composite Repo", "org.eclipse.equinox.p2.metadata.repository.compositeRepository", null);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.fail("Error creating repositories", e);
        }
        compRepo.addChild(repo1Location.toURI());
        compRepo.addChild(repo2Location.toURI());
        compRepo.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        CompositeMetadataRepositoryTest.assertTrue((String)"Ensuring previously loaded repo is enabled", (boolean)CompositeMetadataRepositoryTest.getMetadataRepositoryManager().isEnabled(repo1Location.toURI()));
        String repo1System = CompositeMetadataRepositoryTest.getMetadataRepositoryManager().getRepositoryProperty(repo1Location.toURI(), "p2.system");
        CompositeMetadataRepositoryTest.assertFalse((String)"Ensuring previously loaded repo is not system", (boolean)(repo1System != null ? repo1System.equals(Boolean.toString(true)) : true));
        CompositeMetadataRepositoryTest.assertFalse((String)"Ensuring not previously loaded repo is not enabled", (boolean)CompositeMetadataRepositoryTest.getMetadataRepositoryManager().isEnabled(repo2Location.toURI()));
        String repo2System = CompositeMetadataRepositoryTest.getMetadataRepositoryManager().getRepositoryProperty(repo2Location.toURI(), "p2.system");
        CompositeMetadataRepositoryTest.assertTrue((String)"Ensuring not previously loaded repo is system", (boolean)(repo2System != null ? repo2System.equals(Boolean.toString(true)) : false));
    }

    public void testGetLatestIU() {
        URI location2;
        URI location1;
        CompoundQueryableTest.CompoundQueryTestProgressMonitor monitor = new CompoundQueryableTest.CompoundQueryTestProgressMonitor();
        try {
            location1 = TestData.getFile("metadataRepo", "multipleversions1").toURI();
            location2 = TestData.getFile("metadataRepo", "multipleversions2").toURI();
        }
        catch (Exception e) {
            CompositeMetadataRepositoryTest.fail("0.99", e);
            return;
        }
        CompositeMetadataRepository compositeRepo = this.createRepo(false);
        compositeRepo.addChild(location1);
        compositeRepo.addChild(location2);
        IQueryResult queryResult = compositeRepo.query(QueryUtil.createLatestIUQuery(), (IProgressMonitor)monitor);
        CompositeMetadataRepositoryTest.assertEquals((String)"1.0", (int)1, (int)CompositeMetadataRepositoryTest.queryResultSize(queryResult));
        CompositeMetadataRepositoryTest.assertEquals((String)"1.1", (Object)Version.createOSGi((int)3, (int)0, (int)0), (Object)((IInstallableUnit)queryResult.iterator().next()).getVersion());
        CompositeMetadataRepositoryTest.assertTrue((String)"1.2", (boolean)monitor.isDone());
        CompositeMetadataRepositoryTest.assertTrue((String)"1.3", (boolean)monitor.isWorkDone());
    }

    public void testGetLatestIULessThan3() {
        URI location2;
        URI location1;
        CompoundQueryableTest.CompoundQueryTestProgressMonitor monitor = new CompoundQueryableTest.CompoundQueryTestProgressMonitor();
        try {
            location1 = TestData.getFile("metadataRepo", "multipleversions1").toURI();
            location2 = TestData.getFile("metadataRepo", "multipleversions2").toURI();
        }
        catch (Exception e) {
            CompositeMetadataRepositoryTest.fail("0.99", e);
            return;
        }
        CompositeMetadataRepository compositeRepo = this.createRepo(false);
        compositeRepo.addChild(location1);
        compositeRepo.addChild(location2);
        IQuery cQuery = QueryUtil.createLatestQuery((IQuery)new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit candidate) {
                return candidate.getVersion().compareTo((Object)Version.createOSGi((int)3, (int)0, (int)0)) < 0;
            }
        });
        IQueryResult queryResult = compositeRepo.query(cQuery, (IProgressMonitor)monitor);
        CompositeMetadataRepositoryTest.assertEquals((String)"1.0", (int)1, (int)CompositeMetadataRepositoryTest.queryResultSize(queryResult));
        CompositeMetadataRepositoryTest.assertEquals((String)"1.1", (Object)Version.createOSGi((int)2, (int)2, (int)0), (Object)((IInstallableUnit)queryResult.iterator().next()).getVersion());
        CompositeMetadataRepositoryTest.assertTrue((String)"1.2", (boolean)monitor.isDone());
        CompositeMetadataRepositoryTest.assertTrue((String)"1.3", (boolean)monitor.isWorkDone());
    }

    private void persistenceTest(boolean compressed) {
        CompositeMetadataRepository compRepo = this.createRepo(compressed);
        File child1 = CompositeMetadataRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child1.toURI());
        File child2 = CompositeMetadataRepositoryTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        compRepo.addChild(child2.toURI());
        IMetadataRepositoryManager metadataRepositoryManager = CompositeMetadataRepositoryTest.getMetadataRepositoryManager();
        metadataRepositoryManager.removeRepository(this.repoLocation.toURI());
        compRepo = null;
        IMetadataRepository repo = null;
        try {
            repo = metadataRepositoryManager.loadRepository(this.repoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.fail("Could not load repository after removal", e);
        }
        CompositeMetadataRepositoryTest.assertTrue((String)"loaded repository was of type CompositeMetadataRepository", (boolean)(repo instanceof CompositeMetadataRepository));
        compRepo = (CompositeMetadataRepository)repo;
        IMetadataRepository repo1 = null;
        IMetadataRepository repo2 = null;
        try {
            repo1 = metadataRepositoryManager.loadRepository(child1.toURI(), null);
            repo2 = metadataRepositoryManager.loadRepository(child2.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.fail("Unable to load repositories for verification", e);
        }
        CompositeMetadataRepositoryTest.assertContains("Assert child1's content is in composite repo", repo1, (IMetadataRepository)compRepo);
        CompositeMetadataRepositoryTest.assertContains("Assert child2's content is in composite repo", repo2, (IMetadataRepository)compRepo);
        CompositeMetadataRepositoryTest.assertEquals((String)"Assert correct number of IUs", (int)this.getNumUnique((IQueryResult<IInstallableUnit>)repo1.query(QueryUtil.createIUAnyQuery(), null), (IQueryResult<IInstallableUnit>)repo2.query(QueryUtil.createIUAnyQuery(), null)), (int)compRepo.query(QueryUtil.createIUAnyQuery(), null).toUnmodifiableSet().size());
    }

    private CompositeMetadataRepository createRepo(boolean compressed) {
        IMetadataRepositoryManager metadataRepositoryManager = CompositeMetadataRepositoryTest.getMetadataRepositoryManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", compressed ? "true" : "false");
        IMetadataRepository repo = null;
        try {
            repo = metadataRepositoryManager.createRepository(this.repoLocation.toURI(), "metadata name", "org.eclipse.equinox.p2.metadata.repository.compositeRepository", properties);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.fail((String)"Could not create repository");
        }
        if (!(repo instanceof CompositeMetadataRepository)) {
            CompositeMetadataRepositoryTest.fail((String)"Repository is not a CompositeMetadataRepository");
        }
        return (CompositeMetadataRepository)repo;
    }

    private int getNumUnique(IQueryResult<IInstallableUnit> c1, IQueryResult<IInstallableUnit> c2) {
        Set set1 = c1.toUnmodifiableSet();
        Set set2 = c2.toUnmodifiableSet();
        int numKeys = set1.size() + set2.size();
        for (IInstallableUnit iu1 : set1) {
            for (IInstallableUnit iu2 : set2) {
                if (!CompositeMetadataRepositoryTest.isEqual(iu1, iu2)) continue;
                --numKeys;
            }
        }
        return numKeys;
    }

    public void testNonLocalRepo() {
        PrintStream out = System.out;
        try {
            try {
                System.setOut(new PrintStream(new StringBufferStream()));
                URI location = new URI("http://eclipse.org/equinox/in/memory");
                URI childOne = new URI("http://eclipse.org/equinox/in/memory/one");
                URI childTwo = new URI("http://eclipse.org/equinox/in/memory/two");
                URI childThree = new URI("http://eclipse.org/equinox/in/memory/three");
                CompositeMetadataRepository repository = this.createRepository(location, "in memory test");
                repository.addChild(childOne);
                repository.addChild(childTwo);
                repository.addChild(childThree);
                CompositeMetadataRepositoryTest.assertEquals((String)"1.0", (int)3, (int)repository.getChildren().size());
                repository.removeChild(childTwo);
                CompositeMetadataRepositoryTest.assertEquals((String)"1.1", (int)2, (int)repository.getChildren().size());
                repository.addChild(childOne);
                CompositeMetadataRepositoryTest.assertEquals((String)"1.2", (int)2, (int)repository.getChildren().size());
                repository.addChild(new URI("one"));
                CompositeMetadataRepositoryTest.assertEquals((String)"1.3", (int)2, (int)repository.getChildren().size());
            }
            catch (URISyntaxException e) {
                CompositeMetadataRepositoryTest.fail("99.0", e);
                System.setOut(out);
            }
        }
        finally {
            System.setOut(out);
        }
    }

    protected CompositeMetadataRepository createRepository(URI location, String name) {
        CompositeMetadataRepositoryFactory factory = new CompositeMetadataRepositoryFactory();
        factory.setAgent(CompositeMetadataRepositoryTest.getAgent());
        return (CompositeMetadataRepository)factory.create(location, name, CompositeMetadataRepository.REPOSITORY_TYPE, null);
    }

    public void testRelativeChildren() {
        File one = CompositeMetadataRepositoryTest.getTestData("0.0", "testData/testRepos/simple.1");
        File two = CompositeMetadataRepositoryTest.getTestData("0.1", "testData/testRepos/simple.2");
        File temp = this.getTempFolder();
        CompositeMetadataRepositoryTest.copy("0.2", one, new File(temp, "one"));
        CompositeMetadataRepositoryTest.copy("0.3", two, new File(temp, "two"));
        URI location = new File(temp, "comp").toURI();
        CompositeMetadataRepository repository = this.createRepository(location, "test");
        try {
            repository.addChild(new URI("../one"));
            repository.addChild(new URI("../two"));
        }
        catch (URISyntaxException e) {
            CompositeMetadataRepositoryTest.fail("1.99", e);
        }
        List children = repository.getChildren();
        CompositeMetadataRepositoryTest.assertEquals((String)"2.0", (int)2, (int)children.size());
        IQueryResult queryResult = repository.query(QueryUtil.createIUAnyQuery(), this.getMonitor());
        CompositeMetadataRepositoryTest.assertEquals((String)"2.1", (int)2, (int)CompositeMetadataRepositoryTest.queryResultSize(queryResult));
        CompositeRepositoryState state = repository.toState();
        URI[] childURIs = state.getChildren();
        CompositeMetadataRepositoryTest.assertNotNull((String)"3.0", (Object)childURIs);
        CompositeMetadataRepositoryTest.assertEquals((String)"3.1", (int)2, (int)childURIs.length);
        CompositeMetadataRepositoryTest.assertFalse((String)"3.2", (boolean)childURIs[0].isAbsolute());
        CompositeMetadataRepositoryTest.assertFalse((String)"3.3", (boolean)childURIs[1].isAbsolute());
        CompositeMetadataRepositoryTest.delete(temp);
    }

    public void testRelativeRemoveChild() {
        PrintStream out = System.out;
        try {
            try {
                System.setOut(new PrintStream(new StringBufferStream()));
                URI location = new URI("http://eclipse.org/equinox/in/memory");
                URI one = new URI("one");
                URI two = new URI("two");
                CompositeMetadataRepository repository = this.createRepository(location, "in memory test");
                repository.addChild(one);
                repository.addChild(two);
                List children = repository.getChildren();
                CompositeMetadataRepositoryTest.assertEquals((String)"1.0", (int)2, (int)children.size());
                repository.removeChild((URI)children.iterator().next());
                CompositeMetadataRepositoryTest.assertEquals((String)"1.1", (int)1, (int)repository.getChildren().size());
                repository.removeChild(two);
                CompositeMetadataRepositoryTest.assertEquals((String)"1.2", (int)0, (int)repository.getChildren().size());
            }
            catch (URISyntaxException e) {
                CompositeMetadataRepositoryTest.fail("99.0", e);
                System.setOut(out);
            }
        }
        finally {
            System.setOut(out);
        }
    }

    public void testFailingChildFailsCompleteRepository() throws ProvisionException, OperationCanceledException {
        boolean exception = false;
        IMetadataRepository repo = null;
        IMetadataRepositoryManager manager = CompositeMetadataRepositoryTest.getMetadataRepositoryManager();
        File repoFile = CompositeMetadataRepositoryTest.getTestData("Atomic composite with missing child", "/testData/metadataRepo/composite/missingChild/atomicLoading");
        URI correctChildURI = URIUtil.append((URI)repoFile.toURI(), (String)"one");
        URI repoURI = repoFile.getAbsoluteFile().toURI();
        File alreadyLoadedChildFile = CompositeMetadataRepositoryTest.getTestData("Atomic composite with missing child", "/testData/metadataRepo/composite/missingChild/atomicLoading/three");
        IMetadataRepository alreadyLoadedChild = manager.loadRepository(alreadyLoadedChildFile.toURI(), null);
        CompositeMetadataRepositoryTest.assertNotNull((Object)alreadyLoadedChild);
        URI previouslyAddedChildURI = URIUtil.append((URI)repoFile.toURI(), (String)"three");
        CompositeMetadataRepositoryTest.assertFalse((String)"Child one should not be available in repo manager", (boolean)manager.contains(correctChildURI));
        try {
            repo = manager.loadRepository(repoFile.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeMetadataRepositoryTest.assertFalse((String)"Exception message should not contain the location of failing child", (boolean)e.getMessage().contains(URIUtil.append((URI)repoURI, (String)"two").toString()));
            CompositeMetadataRepositoryTest.assertTrue((String)("Exception message should contain the composite repository location " + String.valueOf(repoURI) + ": " + e.getMessage()), (boolean)e.getMessage().contains(repoURI.toString()));
            exception = true;
        }
        CompositeMetadataRepositoryTest.assertNull((Object)repo);
        CompositeMetadataRepositoryTest.assertTrue((String)"an exception should have been reported", (boolean)exception);
        CompositeMetadataRepositoryTest.assertFalse((String)"Successfully loaded child should be removed when composite loading mode is set to atomic", (boolean)manager.contains(correctChildURI));
        CompositeMetadataRepositoryTest.assertTrue((String)"Periously loaded child should remain in repo manager", (boolean)manager.contains(previouslyAddedChildURI));
    }

    public void testFailingChildLoadsCompleteRepository() {
        boolean exception = false;
        IMetadataRepository repo = null;
        IMetadataRepositoryManager manager = CompositeMetadataRepositoryTest.getMetadataRepositoryManager();
        File repoFile = CompositeMetadataRepositoryTest.getTestData("Composite with missing child", "/testData/metadataRepo/composite/missingChild/nonAtomicLoading");
        URI correctChildURI = URIUtil.append((URI)repoFile.toURI(), (String)"one");
        CompositeMetadataRepositoryTest.assertFalse((String)"Child should not be available in repo manager", (boolean)manager.contains(correctChildURI));
        try {
            repo = manager.loadRepository(repoFile.toURI(), null);
        }
        catch (ProvisionException e) {
            exception = true;
        }
        CompositeMetadataRepositoryTest.assertNotNull((Object)repo);
        CompositeMetadataRepositoryTest.assertFalse((String)"an exception should have been reported", (boolean)exception);
        CompositeMetadataRepositoryTest.assertTrue((String)"Successfully loaded child should be available in repo manager", (boolean)manager.contains(URIUtil.append((URI)repo.getLocation(), (String)"one")));
    }
}

