/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestData;
import org.junit.Test;

public class JarURLMetadataRepositoryTest
extends AbstractProvisioningTest {
    private IMetadataRepositoryManager manager;
    private File testRepoJar;

    public JarURLMetadataRepositoryTest(String name) {
        super(name);
    }

    public JarURLMetadataRepositoryTest() {
        this("");
    }

    @Override
    protected void setUp() throws Exception {
        this.manager = JarURLMetadataRepositoryTest.getMetadataRepositoryManager();
    }

    @Override
    protected void tearDown() throws Exception {
        this.manager = null;
        if (this.testRepoJar != null) {
            FileUtils.deleteAll((File)this.testRepoJar.getParentFile());
        }
    }

    @Test
    public void testZipFileRepository() throws IOException, ProvisionException, OperationCanceledException {
        File zip = TestData.getFile("bug369834", "f-TestBuild-group.group.group.zip");
        URI location = URIUtil.toJarURI((URI)zip.toURI(), (IPath)IPath.EMPTY);
        IMetadataRepository repo = this.manager.loadRepository(location, null);
        JarURLMetadataRepositoryTest.assertTrue((!repo.query(QueryUtil.createIUAnyQuery(), null).isEmpty() ? 1 : 0) != 0);
    }

    public void testJarURLRepository() throws ProvisionException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File testRepo = new File(tempDir, "testRepo");
        FileUtils.deleteAll((File)testRepo);
        testRepo.mkdir();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "true");
        IMetadataRepository repo = this.manager.createRepository(testRepo.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        MetadataFactory.InstallableUnitDescription descriptor = new MetadataFactory.InstallableUnitDescription();
        descriptor.setId("testIuId");
        descriptor.setVersion(Version.create((String)"3.2.1"));
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        repo.addInstallableUnits(Arrays.asList(iu));
        this.testRepoJar = new File(testRepo, "content.jar");
        JarURLMetadataRepositoryTest.assertTrue((boolean)this.testRepoJar.exists());
        this.testRepoJar.deleteOnExit();
        URI jarRepoLocation = null;
        try {
            jarRepoLocation = new URI("jar:" + String.valueOf(this.testRepoJar.toURI()) + "!/");
        }
        catch (URISyntaxException e) {
            JarURLMetadataRepositoryTest.fail((String)e.getMessage());
        }
        repo = this.manager.loadRepository(jarRepoLocation, null);
        JarURLMetadataRepositoryTest.assertTrue((!repo.query(QueryUtil.createIUAnyQuery(), null).isEmpty() ? 1 : 0) != 0);
        URI[] local = this.manager.getKnownRepositories(4);
        boolean found = false;
        URI[] uRIArray = local;
        int n = local.length;
        int n2 = 0;
        while (n2 < n) {
            URI element = uRIArray[n2];
            if (element.equals(jarRepoLocation)) {
                found = true;
            }
            ++n2;
        }
        JarURLMetadataRepositoryTest.assertTrue((boolean)found);
        this.manager.removeRepository(jarRepoLocation);
    }
}

