/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.junit.Assert;

public class LocalMetadataRepositoryTest
extends AbstractProvisioningTest {
    private static final String TEST_KEY = "TestKey";
    private static final String TEST_VALUE = "TestValue";
    protected File repoLocation;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String tempDir = System.getProperty("java.io.tmpdir");
        this.repoLocation = new File(tempDir, "LocalMetadataRepositoryTest");
        AbstractProvisioningTest.delete(this.repoLocation);
        this.repoLocation.mkdir();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalMetadataRepositoryTest.getMetadataRepositoryManager().removeRepository(this.repoLocation.toURI());
        LocalMetadataRepositoryTest.delete(this.repoLocation);
        super.tearDown();
    }

    private IMetadataRepository createTestRepository(IMetadataRepositoryManager manager, Map<String, String> properties) throws ProvisionException {
        return manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
    }

    private IMetadataRepository createTestRepository(Map<String, String> properties) throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        return this.createTestRepository(manager, properties);
    }

    public void testCompressedRepository() throws ProvisionException {
        IMetadataRepository repo = this.createTestRepository(Map.of("p2.compressed", "true"));
        MetadataFactory.InstallableUnitDescription descriptor = new MetadataFactory.InstallableUnitDescription();
        descriptor.setId("testIuId");
        descriptor.setVersion(Version.create((String)"3.2.1"));
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        repo.addInstallableUnits(Arrays.asList(iu));
        File[] files = this.repoLocation.listFiles();
        boolean jarFilePresent = false;
        boolean xmlFilePresent = false;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if ("content.jar".equalsIgnoreCase(file.getName())) {
                jarFilePresent = true;
            }
            if ("content.xml".equalsIgnoreCase(file.getName())) {
                xmlFilePresent = true;
            }
            ++n2;
        }
        LocalMetadataRepositoryTest.assertTrue((String)"Repository did not create JAR for content.xml", (boolean)jarFilePresent);
        LocalMetadataRepositoryTest.assertFalse((String)"Repository should not create content.xml", (boolean)xmlFilePresent);
    }

    public void testGetProperties() throws ProvisionException {
        IMetadataRepository repo = this.createTestRepository(null);
        Map properties = repo.getProperties();
        Assert.assertThrows(RuntimeException.class, () -> {
            String string = properties.put(TEST_KEY, TEST_VALUE);
        });
    }

    public void testSetProperty() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        IMetadataRepository repo = this.createTestRepository(manager, null);
        Map properties = repo.getProperties();
        LocalMetadataRepositoryTest.assertTrue((String)"1.0", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
        repo.setProperty(TEST_KEY, TEST_VALUE);
        LocalMetadataRepositoryTest.assertTrue((String)"1.1", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
        properties = repo.getProperties();
        LocalMetadataRepositoryTest.assertTrue((String)"1.2", (boolean)properties.containsKey(TEST_KEY));
        repo = manager.loadRepository(this.repoLocation.toURI(), null);
        properties = repo.getProperties();
        LocalMetadataRepositoryTest.assertTrue((String)"1.3", (boolean)properties.containsKey(TEST_KEY));
        repo.setProperty(TEST_KEY, null);
        properties = repo.getProperties();
        LocalMetadataRepositoryTest.assertTrue((String)"1.4", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
    }

    public void testAddRemoveIUs() throws ProvisionException {
        IMetadataRepository repo = this.createTestRepository(null);
        IInstallableUnit iu = LocalMetadataRepositoryTest.createIU("foo");
        repo.addInstallableUnits(Arrays.asList(iu));
        IQueryResult result = repo.query(QueryUtil.createIUQuery(null), this.getMonitor());
        LocalMetadataRepositoryTest.assertEquals((String)"1.0", (int)1, (int)LocalMetadataRepositoryTest.queryResultSize(result));
        repo.removeAll();
        result = repo.query(QueryUtil.createIUQuery(null), this.getMonitor());
        LocalMetadataRepositoryTest.assertTrue((String)"1.1", (boolean)result.isEmpty());
    }

    public void testRemoveByQuery() throws ProvisionException {
        IMetadataRepository repo = this.createTestRepository(null);
        IInstallableUnit iu = LocalMetadataRepositoryTest.createIU("foo");
        IInstallableUnit iu2 = LocalMetadataRepositoryTest.createIU("bar");
        repo.addInstallableUnits(Arrays.asList(iu, iu2));
        IQueryResult result = repo.query(QueryUtil.createIUQuery(null), this.getMonitor());
        LocalMetadataRepositoryTest.assertEquals((String)"1.0", (int)2, (int)LocalMetadataRepositoryTest.queryResultSize(result));
        repo.removeInstallableUnits(Arrays.asList(iu));
        result = repo.query(QueryUtil.createIUQuery(null), this.getMonitor());
        LocalMetadataRepositoryTest.assertEquals((String)"1.1", (int)1, (int)LocalMetadataRepositoryTest.queryResultSize(result));
        repo.removeInstallableUnits(Arrays.asList(iu2));
        result = repo.query(QueryUtil.createIUQuery(null), this.getMonitor());
        LocalMetadataRepositoryTest.assertTrue((String)"1.2", (boolean)result.isEmpty());
    }

    public void testUncompressedRepository() throws ProvisionException {
        File[] files;
        IMetadataRepository repo = this.createTestRepository(Map.of("p2.compressed", "false"));
        MetadataFactory.InstallableUnitDescription descriptor = new MetadataFactory.InstallableUnitDescription();
        descriptor.setId("testIuId");
        descriptor.setVersion(Version.create((String)"3.2.1"));
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        repo.addInstallableUnits(Arrays.asList(iu));
        File[] fileArray = files = this.repoLocation.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if ("content.jar".equalsIgnoreCase(file.getName())) {
                LocalMetadataRepositoryTest.fail((String)"Repository should not create JAR for content.xml");
            }
            ++n2;
        }
    }

    public void testLoadSelfReference() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        URI repoURI = this.repoLocation.toURI();
        IMetadataRepository repo = this.createTestRepository(manager, Map.of("p2.compressed", "false"));
        repo.addReferences(List.of(new RepositoryReference(repoURI, "testNick", 0, 0)));
        int[] callCount = new int[1];
        boolean[] wasEnabled = new boolean[1];
        SynchronousProvisioningListener listener = o -> {
            void event;
            if (!(o instanceof RepositoryEvent)) {
                return;
            }
            RepositoryEvent repositoryEvent = (RepositoryEvent)o;
            if (event.getKind() != 0) {
                return;
            }
            if (!event.getRepositoryLocation().equals(repoURI)) {
                return;
            }
            blArray[0] = event.isRepositoryEnabled();
            nArray[0] = callCount[0] + 1;
        };
        IProvisioningEventBus eventBus = this.getEventBus();
        eventBus.addListener((ProvisioningListener)listener);
        try {
            manager.removeRepository(repoURI);
            repo = manager.loadRepository(repoURI, null);
            LocalMetadataRepositoryTest.assertTrue((String)"1.0", (boolean)manager.isEnabled(repoURI));
            LocalMetadataRepositoryTest.assertTrue((String)"1.1", (boolean)wasEnabled[0]);
            LocalMetadataRepositoryTest.assertEquals((String)"1.2", (int)1, (int)callCount[0]);
        }
        finally {
            eventBus.removeListener((ProvisioningListener)listener);
        }
    }

    public void testRefreshSelfReference() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        URI repoURL = this.repoLocation.toURI();
        IMetadataRepository repo = this.createTestRepository(manager, Map.of("p2.compressed", "false"));
        repo.addReferences(List.of(new RepositoryReference(repoURL, "testNick", 0, 0)));
        if (!manager.isEnabled(repoURL)) {
            manager.setEnabled(repoURL, true);
        }
        int[] callCount = new int[1];
        boolean[] wasEnabled = new boolean[1];
        SynchronousProvisioningListener listener = o -> {
            void event;
            if (!(o instanceof RepositoryEvent)) {
                return;
            }
            RepositoryEvent repositoryEvent = (RepositoryEvent)o;
            if (event.getKind() != 0) {
                return;
            }
            if (!event.getRepositoryLocation().equals(repoURL)) {
                return;
            }
            blArray[0] = event.isRepositoryEnabled();
            nArray[0] = callCount[0] + 1;
        };
        this.getEventBus().addListener((ProvisioningListener)listener);
        try {
            manager.refreshRepository(repoURL, null);
            LocalMetadataRepositoryTest.assertTrue((String)"1.0", (boolean)manager.isEnabled(repoURL));
            LocalMetadataRepositoryTest.assertTrue((String)"1.1", (boolean)wasEnabled[0]);
            LocalMetadataRepositoryTest.assertEquals((String)"1.2", (int)1, (int)callCount[0]);
        }
        finally {
            this.getEventBus().removeListener((ProvisioningListener)listener);
        }
    }

    public void testAddReference() throws ProvisionException {
        IMetadataRepository repo = this.createTestRepository(null);
        RepositoryReference reference = new RepositoryReference(URI.create("https://foo.bar.org"), "aName", 0, 0);
        repo.addReferences(List.of(reference));
        LocalMetadataRepositoryTest.assertEquals(Set.of(reference), (Object)repo.getReferences());
    }

    public void testRemoveReference() throws ProvisionException {
        IMetadataRepository repo = this.createTestRepository(null);
        RepositoryReference ref1 = new RepositoryReference(URI.create("https://foo.bar1.org"), "aName1", 0, 0);
        RepositoryReference ref2 = new RepositoryReference(URI.create("https://foo.bar2.org"), "aName2", 0, 0);
        repo.addReferences(List.of(ref1, ref2));
        LocalMetadataRepositoryTest.assertEquals(Set.of(ref1, ref2), (Object)repo.getReferences());
        repo.removeReferences(List.of(ref1));
        LocalMetadataRepositoryTest.assertEquals(Set.of(ref2), (Object)repo.getReferences());
    }

    public void testUniqueURIs() throws ProvisionException, OperationCanceledException {
        IMetadataRepository repo = LocalMetadataRepositoryTest.getMetadataRepositoryManager().loadRepository(LocalMetadataRepositoryTest.getTestData("test data bug 278668", "testData/bug278668").toURI(), null);
        URI last = null;
        for (IInstallableUnit iu : repo.query(QueryUtil.ALL_UNITS, null)) {
            Collection licenses = iu.getLicenses();
            for (ILicense license : licenses) {
                URI uri = license.getLocation();
                if (last == null) {
                    last = uri;
                    continue;
                }
                LocalMetadataRepositoryTest.assertSame((String)"License URIs must be the same object", (Object)last, (Object)uri);
            }
        }
    }
}

