/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;

public class SPIMetadataRepositoryTest
extends AbstractProvisioningTest {
    protected File repoLocation;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String tempDir = System.getProperty("java.io.tmpdir");
        this.repoLocation = new File(tempDir, "SPILocalMetadataRepositoryTest");
        AbstractProvisioningTest.delete(this.repoLocation);
        this.repoLocation.mkdir();
    }

    @Override
    protected void tearDown() throws Exception {
        SPIMetadataRepositoryTest.getMetadataRepositoryManager().removeRepository(this.repoLocation.toURI());
        SPIMetadataRepositoryTest.delete(this.repoLocation);
        super.tearDown();
    }

    public void testSPIMetadataIU() throws ProvisionException {
        IMetadataRepositoryManager manager = SPIMetadataRepositoryTest.getMetadataRepositoryManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "true");
        IMetadataRepository repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        repo.addInstallableUnits(Arrays.asList(new SPIInstallableUnit("foo", Version.createOSGi((int)1, (int)1, (int)1))));
        IQueryResult queryResult = repo.query((IQuery)new AllAcceptingQuery(), (IProgressMonitor)new NullProgressMonitor());
        SPIMetadataRepositoryTest.assertEquals((int)1, (int)SPIMetadataRepositoryTest.queryResultSize(queryResult));
        SPIMetadataRepositoryTest.assertTrue((String)"Repo contains SPI IU)", (boolean)(queryResult.iterator().next() instanceof SPIInstallableUnit));
        repo = manager.refreshRepository(this.repoLocation.toURI(), null);
        queryResult = repo.query((IQuery)new AllAcceptingQuery(), (IProgressMonitor)new NullProgressMonitor());
        SPIMetadataRepositoryTest.assertEquals((int)1, (int)SPIMetadataRepositoryTest.queryResultSize(queryResult));
        SPIMetadataRepositoryTest.assertTrue((String)"Refreshed repo contains default IU", (boolean)(queryResult.iterator().next() instanceof InstallableUnit));
    }

    public void testProvidedCapabilitywithSPI_IU() throws ProvisionException {
        IMetadataRepositoryManager manager = SPIMetadataRepositoryTest.getMetadataRepositoryManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "true");
        IMetadataRepository repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        IProvidedCapability providedCapability = MetadataFactory.createProvidedCapability((String)"foo", (String)"bar", (Version)Version.createOSGi((int)1, (int)0, (int)0));
        SPIInstallableUnit spiInstallableUnit = new SPIInstallableUnit("foo", Version.createOSGi((int)1, (int)1, (int)1));
        spiInstallableUnit.addProvidedCapability(providedCapability);
        repo.addInstallableUnits(Arrays.asList(spiInstallableUnit));
        IQueryResult queryResult = repo.query((IQuery)new AllAcceptingQuery(), (IProgressMonitor)new NullProgressMonitor());
        SPIMetadataRepositoryTest.assertEquals((int)1, (int)SPIMetadataRepositoryTest.queryResultSize(queryResult));
        IInstallableUnit spiUnit = (IInstallableUnit)queryResult.iterator().next();
        SPIMetadataRepositoryTest.assertTrue((String)"Repo contains SPI IU)", (boolean)(spiUnit instanceof SPIInstallableUnit));
        SPIMetadataRepositoryTest.assertEquals((int)spiUnit.getProvidedCapabilities().size(), (int)1);
        SPIMetadataRepositoryTest.assertTrue((boolean)(spiUnit.getProvidedCapabilities().iterator().next() instanceof ProvidedCapability));
        repo = manager.refreshRepository(this.repoLocation.toURI(), null);
        queryResult = repo.query((IQuery)new AllAcceptingQuery(), (IProgressMonitor)new NullProgressMonitor());
        SPIMetadataRepositoryTest.assertEquals((int)1, (int)SPIMetadataRepositoryTest.queryResultSize(queryResult));
        IInstallableUnit defaultUnit = (IInstallableUnit)queryResult.iterator().next();
        SPIMetadataRepositoryTest.assertTrue((String)"Repo contains SPI IU)", (boolean)(defaultUnit instanceof InstallableUnit));
        SPIMetadataRepositoryTest.assertEquals((int)spiUnit.getProvidedCapabilities().size(), (int)1);
        SPIMetadataRepositoryTest.assertTrue((boolean)(spiUnit.getProvidedCapabilities().iterator().next() instanceof ProvidedCapability));
    }

    public void testSPIRequiredCapability() throws ProvisionException {
        IMetadataRepositoryManager manager = SPIMetadataRepositoryTest.getMetadataRepositoryManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "true");
        IMetadataRepository repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        MetadataFactory.InstallableUnitDescription iuDescription = new MetadataFactory.InstallableUnitDescription();
        iuDescription.setId("foo");
        iuDescription.setVersion(Version.createOSGi((int)1, (int)1, (int)1));
        SPIRequiredCapability spiRequiredCapability = new SPIRequiredCapability("com.example", "bar", new VersionRange(Version.createOSGi((int)1, (int)0, (int)0), true, Version.createOSGi((int)2, (int)0, (int)0), true));
        ArrayList<SPIRequiredCapability> list = new ArrayList<SPIRequiredCapability>();
        list.add(spiRequiredCapability);
        iuDescription.addRequirements(list);
        repo.addInstallableUnits(Arrays.asList(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription)));
        IQueryResult queryResult = repo.query((IQuery)new AllAcceptingQuery(), (IProgressMonitor)new NullProgressMonitor());
        SPIMetadataRepositoryTest.assertEquals((int)1, (int)SPIMetadataRepositoryTest.queryResultSize(queryResult));
        IInstallableUnit unit = (IInstallableUnit)queryResult.iterator().next();
        SPIMetadataRepositoryTest.assertEquals((int)unit.getRequirements().size(), (int)1);
        SPIMetadataRepositoryTest.assertTrue((boolean)(unit.getRequirements().iterator().next() instanceof SPIRequiredCapability));
        repo = manager.refreshRepository(this.repoLocation.toURI(), null);
        queryResult = repo.query((IQuery)new AllAcceptingQuery(), (IProgressMonitor)new NullProgressMonitor());
        SPIMetadataRepositoryTest.assertEquals((int)1, (int)SPIMetadataRepositoryTest.queryResultSize(queryResult));
        unit = (IInstallableUnit)queryResult.iterator().next();
        SPIMetadataRepositoryTest.assertEquals((int)unit.getRequirements().size(), (int)1);
        SPIMetadataRepositoryTest.assertTrue((boolean)(unit.getRequirements().iterator().next() instanceof RequiredCapability));
        SPIMetadataRepositoryTest.assertTrue((boolean)((IRequiredCapability)unit.getRequirements().iterator().next()).getName().equals("bar"));
    }

    public void testSPIEquals() throws ProvisionException, URISyntaxException {
        IMetadataRepositoryManager manager = SPIMetadataRepositoryTest.getMetadataRepositoryManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "true");
        IMetadataRepository repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        MetadataFactory.InstallableUnitDescription iuDescription = new MetadataFactory.InstallableUnitDescription();
        MetadataFactory.InstallableUnitPatchDescription iuPatchDescription = new MetadataFactory.InstallableUnitPatchDescription();
        iuDescription.setId("foo");
        iuDescription.setVersion(Version.createOSGi((int)1, (int)1, (int)1));
        SPIRequiredCapability spiRequiredCapability1 = new SPIRequiredCapability("com.example", "bar", new VersionRange(Version.createOSGi((int)1, (int)0, (int)0), true, Version.createOSGi((int)2, (int)0, (int)0), true), "(bar=foo)", true, true, true);
        IRequiredCapability requiredCapability1 = (IRequiredCapability)MetadataFactory.createRequirement((String)"com.example2", (String)"foo", (VersionRange)new VersionRange(Version.createOSGi((int)1, (int)0, (int)0), true, Version.createOSGi((int)2, (int)0, (int)0), true), (String)"(bar=foo)", (boolean)false, (boolean)false, (boolean)false);
        SPIRequirementChange spiRequirementChange = new SPIRequirementChange(spiRequiredCapability1, requiredCapability1);
        iuPatchDescription.setRequirementChanges(new IRequirementChange[]{spiRequirementChange});
        SPIRequiredCapability spiRequiredCapability = new SPIRequiredCapability("com.example", "bar", new VersionRange(Version.createOSGi((int)1, (int)0, (int)0), true, Version.createOSGi((int)2, (int)0, (int)0), true), "(bar=foo)", true, true, true);
        SPIProvidedCapability spiProvidedCapability = new SPIProvidedCapability("bar", "foo", Version.createOSGi((int)1, (int)1, (int)1));
        SPITouchpointData spiTouchpointData = new SPITouchpointData();
        SPITouchpointInstruction spiTouchpointInstruction = new SPITouchpointInstruction("the body", "the import attribute");
        spiTouchpointData.addInstruction("foo", spiTouchpointInstruction);
        iuDescription.addTouchpointData((ITouchpointData)spiTouchpointData);
        SPILicense spiLicense = new SPILicense("body", new URI("http://example.com"));
        iuDescription.setLicenses(new ILicense[]{spiLicense});
        SPITouchpointType spiTouchpointType = new SPITouchpointType("foo", Version.createOSGi((int)3, (int)3, (int)3));
        iuDescription.setTouchpointType((ITouchpointType)spiTouchpointType);
        ArrayList<SPIRequiredCapability> requiredCapabilityList = new ArrayList<SPIRequiredCapability>();
        requiredCapabilityList.add(spiRequiredCapability);
        iuDescription.addRequirements(requiredCapabilityList);
        ArrayList<SPIProvidedCapability> providedCapabilityList = new ArrayList<SPIProvidedCapability>();
        providedCapabilityList.add(spiProvidedCapability);
        iuDescription.addProvidedCapabilities(providedCapabilityList);
        repo.addInstallableUnits(Arrays.asList(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription), MetadataFactory.createInstallableUnitPatch((MetadataFactory.InstallableUnitPatchDescription)iuPatchDescription)));
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            repo = manager.refreshRepository(this.repoLocation.toURI(), null);
        }
        finally {
            System.setOut(out);
        }
        IQueryResult queryResult = repo.query((IQuery)new AllAcceptingQuery(), (IProgressMonitor)new NullProgressMonitor());
        SPIMetadataRepositoryTest.assertEquals((int)2, (int)SPIMetadataRepositoryTest.queryResultSize(queryResult));
        Iterator iterator = queryResult.iterator();
        IInstallableUnit unit = null;
        IInstallableUnitPatch patchUnit = null;
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof IInstallableUnitPatch) {
                patchUnit = (IInstallableUnitPatch)o;
                continue;
            }
            if (!(o instanceof IInstallableUnit)) continue;
            unit = (IInstallableUnit)o;
        }
        SPIMetadataRepositoryTest.assertFalse((unit == null ? 1 : 0) != 0);
        SPIMetadataRepositoryTest.assertFalse((patchUnit == null ? 1 : 0) != 0);
        SPIMetadataRepositoryTest.assertEquals((int)unit.getRequirements().size(), (int)1);
        SPIMetadataRepositoryTest.assertEquals((int)unit.getProvidedCapabilities().size(), (int)1);
        SPIMetadataRepositoryTest.assertEquals((int)unit.getTouchpointData().size(), (int)1);
        SPIMetadataRepositoryTest.assertEquals((String)((IRequiredCapability)unit.getRequirements().iterator().next()).getNamespace(), (String)spiRequiredCapability.getNamespace());
        SPIMetadataRepositoryTest.assertEquals((String)((IRequiredCapability)unit.getRequirements().iterator().next()).getName(), (String)spiRequiredCapability.getName());
        SPIMetadataRepositoryTest.assertEquals((int)((IRequirement)unit.getRequirements().iterator().next()).getMin(), (int)spiRequiredCapability.getMin());
        SPIMetadataRepositoryTest.assertEquals((int)((IRequirement)unit.getRequirements().iterator().next()).getMax(), (int)spiRequiredCapability.getMax());
        SPIMetadataRepositoryTest.assertEquals(unit.getProvidedCapabilities().iterator().next(), (Object)spiProvidedCapability);
        SPIMetadataRepositoryTest.assertEquals(unit.getTouchpointData().iterator().next(), (Object)spiTouchpointData);
        SPIMetadataRepositoryTest.assertEquals((Object)unit.getTouchpointType(), (Object)spiTouchpointType);
        SPIMetadataRepositoryTest.assertEquals(unit.getLicenses().iterator().next(), (Object)spiLicense);
        SPIMetadataRepositoryTest.assertEquals((Object)spiProvidedCapability, unit.getProvidedCapabilities().iterator().next());
        SPIMetadataRepositoryTest.assertEquals((Object)spiTouchpointData, unit.getTouchpointData().iterator().next());
        SPIMetadataRepositoryTest.assertEquals((Object)spiTouchpointType, (Object)unit.getTouchpointType());
        SPIMetadataRepositoryTest.assertEquals((Object)spiLicense, unit.getLicenses().iterator().next());
        SPIMetadataRepositoryTest.assertEquals((int)patchUnit.getRequirementsChange().size(), (int)1);
        SPIMetadataRepositoryTest.assertEquals(patchUnit.getRequirementsChange().get(0), (Object)spiRequirementChange);
        SPIMetadataRepositoryTest.assertEquals((Object)spiRequirementChange, patchUnit.getRequirementsChange().get(0));
        SPIMetadataRepositoryTest.assertFalse((spiTouchpointData == unit.getTouchpointData().iterator().next() ? 1 : 0) != 0);
        SPIMetadataRepositoryTest.assertFalse((spiRequiredCapability == unit.getRequirements().iterator().next() ? 1 : 0) != 0);
        SPIMetadataRepositoryTest.assertFalse((spiProvidedCapability == unit.getProvidedCapabilities().iterator().next() ? 1 : 0) != 0);
        SPIMetadataRepositoryTest.assertFalse((spiTouchpointType == unit.getTouchpointType() ? 1 : 0) != 0);
        SPIMetadataRepositoryTest.assertFalse((spiLicense == unit.getLicenses().iterator().next() ? 1 : 0) != 0);
    }

    class AllAcceptingQuery
    extends MatchQuery {
        AllAcceptingQuery() {
        }

        public boolean isMatch(Object candidate) {
            return true;
        }
    }

    class SPIInstallableUnit
    implements IInstallableUnit {
        List<IArtifactKey> artifacts = new ArrayList<IArtifactKey>();
        List<IInstallableUnitFragment> fragments = new ArrayList<IInstallableUnitFragment>();
        List<IRequirement> requiredCapabilities = new ArrayList<IRequirement>();
        List<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        List<ITouchpointData> touchpointData = new ArrayList<ITouchpointData>();
        ICopyright copyright = null;
        IMatchExpression<IInstallableUnit> filter = null;
        String id = null;
        Collection<ILicense> license = null;
        Map<String, String> properties = new HashMap<String, String>();
        ITouchpointType touchpointType = null;
        IUpdateDescriptor updateDescriptor = null;
        Version version = null;
        boolean isFragment;
        boolean isResolved;
        boolean isSingleton;

        public SPIInstallableUnit(String id, Version version) {
            this.id = id;
            this.version = version;
        }

        public void addProvidedCapability(IProvidedCapability providedCapability) {
            this.providedCapabilities.add(providedCapability);
        }

        public Collection<IArtifactKey> getArtifacts() {
            return this.artifacts;
        }

        public ICopyright getCopyright() {
            return this.copyright;
        }

        public IMatchExpression<IInstallableUnit> getFilter() {
            return this.filter;
        }

        public Collection<IInstallableUnitFragment> getFragments() {
            return this.fragments;
        }

        public String getId() {
            return this.id;
        }

        public Collection<ILicense> getLicenses() {
            return this.license;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }

        public List<IProvidedCapability> getProvidedCapabilities() {
            return this.providedCapabilities;
        }

        public List<IRequirement> getRequirements() {
            return this.requiredCapabilities;
        }

        public Collection<ITouchpointData> getTouchpointData() {
            return this.touchpointData;
        }

        public ITouchpointType getTouchpointType() {
            if (this.touchpointType == null) {
                return ITouchpointType.NONE;
            }
            return this.touchpointType;
        }

        public IUpdateDescriptor getUpdateDescriptor() {
            return this.updateDescriptor;
        }

        public Version getVersion() {
            return this.version;
        }

        public boolean isFragment() {
            return this.isFragment;
        }

        public boolean isResolved() {
            return this.isResolved;
        }

        public boolean isSingleton() {
            return this.isSingleton;
        }

        public boolean satisfies(IRequirement candidate) {
            return candidate.isMatch((IInstallableUnit)this);
        }

        public IInstallableUnit unresolved() {
            return this;
        }

        public int compareTo(IInstallableUnit other) {
            if (this.getId().compareTo(other.getId()) == 0) {
                return this.getVersion().compareTo((Object)other.getVersion());
            }
            return this.getId().compareTo(other.getId());
        }

        public List<IRequirement> getMetaRequirements() {
            return Collections.emptyList();
        }

        public String getProperty(String key, String locale) {
            return this.getProperty(key);
        }

        public Collection<ILicense> getLicenses(String locale) {
            return this.license;
        }

        public ICopyright getCopyright(String locale) {
            return this.copyright;
        }
    }

    class SPILicense
    implements ILicense {
        private final String body;
        private final URI location;
        private String uuid;

        public SPILicense(String body, URI location) {
            this.body = body;
            this.location = location;
        }

        public String getBody() {
            return this.body;
        }

        public String getUUID() {
            if (this.uuid == null) {
                this.uuid = this.calculateLicenseDigest().toString(16);
            }
            return this.uuid;
        }

        public URI getLocation() {
            return this.location;
        }

        public boolean equals(Object obj) {
            ILicense other;
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof ILicense && (other = (ILicense)obj).getUUID().equals(this.getUUID());
        }

        private BigInteger calculateLicenseDigest() {
            String message = this.normalize(this.getBody());
            try {
                MessageDigest algorithm = MessageDigest.getInstance("MD5");
                algorithm.reset();
                algorithm.update(message.getBytes(StandardCharsets.UTF_8));
                byte[] digestBytes = algorithm.digest();
                return new BigInteger(1, digestBytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        private String normalize(String license) {
            String text = license.trim();
            StringBuilder result = new StringBuilder();
            int length = text.length();
            int i = 0;
            while (i < length) {
                char c = text.charAt(i);
                boolean foundWhitespace = false;
                while (Character.isWhitespace(c) && i < length) {
                    foundWhitespace = true;
                    c = text.charAt(++i);
                }
                if (foundWhitespace) {
                    result.append(' ');
                }
                if (i < length) {
                    result.append(c);
                }
                ++i;
            }
            return result.toString();
        }
    }

    class SPIProvidedCapability
    implements IProvidedCapability {
        private final String namespace;
        private final Map<String, Object> properties;

        public SPIProvidedCapability(String namespace, String name, Version version) {
            this.namespace = namespace;
            this.properties = new HashMap<String, Object>();
            this.properties.put(namespace, name);
            this.properties.put("version", version);
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object other) {
            void otherCapability;
            if (!(other instanceof IProvidedCapability)) {
                return false;
            }
            IProvidedCapability iProvidedCapability = (IProvidedCapability)other;
            if (!this.namespace.equals(otherCapability.getNamespace())) {
                return false;
            }
            return this.properties.equals(otherCapability.getProperties());
        }

        public String toString() {
            return this.namespace + "; " + String.valueOf(this.properties);
        }

        public String getName() {
            return (String)this.properties.get(this.namespace);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Version getVersion() {
            return (Version)this.properties.get("version");
        }

        public Map<String, Object> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }
    }

    class SPIRequiredCapability
    implements IRequiredCapability {
        private final IMatchExpression<IInstallableUnit> filter;
        private final String name;
        private final String namespace;
        private final VersionRange versionRange;
        private final boolean isGreedy;
        private final int min;
        private final int max;

        public SPIRequiredCapability(String namespace, String name, VersionRange versionRange) {
            this(namespace, name, versionRange, null, true, false, false);
        }

        public SPIRequiredCapability(String namespace, String name, VersionRange versionRange, String filter, boolean isGreedy, boolean isMultiple, boolean isOptional) {
            this.namespace = namespace;
            this.name = name;
            this.versionRange = versionRange;
            this.filter = filter == null ? null : InstallableUnit.parseFilter((String)filter);
            this.isGreedy = isGreedy;
            this.min = isOptional ? 0 : 1;
            this.max = isMultiple ? Integer.MAX_VALUE : 1;
        }

        public IMatchExpression<IInstallableUnit> getFilter() {
            return this.filter;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public VersionRange getRange() {
            return this.versionRange;
        }

        public boolean isGreedy() {
            return this.isGreedy;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IRequirement)) {
                return false;
            }
            IRequirement iRequirement = (IRequirement)obj;
            if (this.filter == null ? other.getFilter() != null : !this.filter.equals((Object)other.getFilter())) {
                return false;
            }
            return this.min == other.getMin() && this.max == other.getMax() && this.isGreedy == other.isGreedy() && this.getMatches().equals((Object)other.getMatches());
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public boolean isMatch(IInstallableUnit candidate) {
            return candidate.satisfies((IRequirement)this);
        }

        public IMatchExpression<IInstallableUnit> getMatches() {
            return RequiredCapability.createMatchExpressionFromRange((String)this.namespace, (String)this.name, (VersionRange)this.versionRange);
        }

        public String getDescription() {
            return "";
        }
    }

    class SPIRequirementChange
    implements IRequirementChange {
        private final IRequiredCapability applyOn;
        private final IRequiredCapability newValue;

        public SPIRequirementChange(IRequiredCapability applyOn2, IRequiredCapability newValue2) {
            if (applyOn2 == null && newValue2 == null) {
                throw new IllegalArgumentException();
            }
            this.applyOn = applyOn2;
            this.newValue = newValue2;
        }

        public IRequiredCapability applyOn() {
            return this.applyOn;
        }

        public IRequiredCapability newValue() {
            return this.newValue;
        }

        public boolean matches(IRequiredCapability toMatch) {
            if (!toMatch.getNamespace().equals(this.applyOn.getNamespace())) {
                return false;
            }
            if (!toMatch.getName().equals(this.applyOn.getName())) {
                return false;
            }
            if (toMatch.getRange().equals((Object)this.applyOn.getRange())) {
                return true;
            }
            return this.intersect(toMatch.getRange(), this.applyOn.getRange()) != null;
        }

        private VersionRange intersect(VersionRange r1, VersionRange r2) {
            Version resultMin = null;
            boolean resultMinIncluded = false;
            Version resultMax = null;
            boolean resultMaxIncluded = false;
            int minCompare = r1.getMinimum().compareTo((Object)r2.getMinimum());
            if (minCompare < 0) {
                resultMin = r2.getMinimum();
                resultMinIncluded = r2.getIncludeMinimum();
            } else if (minCompare > 0) {
                resultMin = r1.getMinimum();
                resultMinIncluded = r1.getIncludeMinimum();
            } else if (minCompare == 0) {
                resultMin = r1.getMinimum();
                resultMinIncluded = r1.getIncludeMinimum() && r2.getIncludeMinimum();
            }
            int maxCompare = r1.getMaximum().compareTo((Object)r2.getMaximum());
            if (maxCompare > 0) {
                resultMax = r2.getMaximum();
                resultMaxIncluded = r2.getIncludeMaximum();
            } else if (maxCompare < 0) {
                resultMax = r1.getMaximum();
                resultMaxIncluded = r1.getIncludeMaximum();
            } else if (maxCompare == 0) {
                resultMax = r1.getMaximum();
                resultMaxIncluded = r1.getIncludeMaximum() && r2.getIncludeMaximum();
            }
            int resultRangeComparison = resultMin.compareTo((Object)resultMax);
            if (resultRangeComparison < 0) {
                return new VersionRange(resultMin, resultMinIncluded, resultMax, resultMaxIncluded);
            }
            if (resultRangeComparison == 0 && resultMinIncluded == resultMaxIncluded) {
                return new VersionRange(resultMin, resultMinIncluded, resultMax, resultMaxIncluded);
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.applyOn == null ? 0 : this.applyOn.hashCode());
            result = 31 * result + (this.newValue == null ? 0 : this.newValue.hashCode());
            return result;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IRequirementChange)) {
                return false;
            }
            IRequirementChange iRequirementChange = (IRequirementChange)obj;
            if (this.applyOn == null ? other.applyOn() != null : !this.applyOn.equals(other.applyOn())) {
                return false;
            }
            return !(this.newValue == null ? other.newValue() != null : !this.newValue.equals(other.newValue()));
        }

        public String toString() {
            return String.valueOf(this.applyOn) + " --> " + String.valueOf(this.newValue);
        }
    }

    class SPITouchpointData
    implements ITouchpointData {
        Map<String, ITouchpointInstruction> instructions = new HashMap<String, ITouchpointInstruction>();

        SPITouchpointData() {
        }

        public ITouchpointInstruction getInstruction(String instructionKey) {
            return this.instructions.get(instructionKey);
        }

        public void addInstruction(String instructionKey, ITouchpointInstruction instruction) {
            this.instructions.put(instructionKey, instruction);
        }

        public Map<String, ITouchpointInstruction> getInstructions() {
            return this.instructions;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ITouchpointData)) {
                return false;
            }
            ITouchpointData iTouchpointData = (ITouchpointData)obj;
            return !(this.instructions == null ? other.getInstructions() != null : !this.instructions.equals(other.getInstructions()));
        }
    }

    class SPITouchpointInstruction
    implements ITouchpointInstruction {
        private final String body;
        private final String importAttribute;

        public SPITouchpointInstruction(String body, String importAttribute) {
            this.body = body;
            this.importAttribute = importAttribute;
        }

        public String getBody() {
            return this.body;
        }

        public String getImportAttribute() {
            return this.importAttribute;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ITouchpointInstruction)) {
                return false;
            }
            ITouchpointInstruction iTouchpointInstruction = (ITouchpointInstruction)obj;
            if (this.body == null ? other.getBody() != null : !this.body.equals(other.getBody())) {
                return false;
            }
            return !(this.importAttribute == null ? other.getImportAttribute() != null : !this.importAttribute.equals(other.getImportAttribute()));
        }
    }

    class SPITouchpointType
    implements ITouchpointType {
        private final String id;
        private final Version version;

        public SPITouchpointType(String id, Version version) {
            this.id = id;
            this.version = version;
        }

        public String getId() {
            return this.id;
        }

        public Version getVersion() {
            return this.version;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            if (this == obj) {
                return true;
            }
            if (super.equals(obj)) {
                return true;
            }
            if (obj == null || !(obj instanceof ITouchpointType)) {
                return false;
            }
            ITouchpointType iTouchpointType = (ITouchpointType)obj;
            return this.id.equals(other.getId()) && this.version.equals(other.getVersion());
        }
    }
}

