/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.repository.helpers.LocationProperties;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.osgi.framework.BundleContext;

public class SiteIndexFileTest
extends AbstractProvisioningTest {
    public void testSortOrderSimple() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), null);
        Assert.assertArrayEquals((Object[])new String[]{"first", "second", "third"}, (Object[])suffixes);
    }

    public void testSortOrderSimple2() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"first", "second", "third"});
        Assert.assertArrayEquals((Object[])new String[]{"first", "second", "third"}, (Object[])suffixes);
    }

    public void testSortOrderSimple3() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"first"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"first", "second", "third"});
        Assert.assertArrayEquals((Object[])new String[]{"first"}, (Object[])suffixes);
    }

    public void testSortOrderSimple4() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"first"});
        Assert.assertArrayEquals((Object[])new String[]{"first", "second", "third"}, (Object[])suffixes);
    }

    public void testSortOrderSimple5() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"foo", "bar"});
        Assert.assertArrayEquals((Object[])new String[]{"first", "second", "third"}, (Object[])suffixes);
    }

    public void testSortOrderReverse() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"third", "second", "first"});
        Assert.assertArrayEquals((Object[])new String[]{"third", "second", "first"}, (Object[])suffixes);
    }

    public void testSortOrderReverse2() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"third"});
        Assert.assertArrayEquals((Object[])new String[]{"third", "first", "second"}, (Object[])suffixes);
    }

    public void testSortOrderComplex() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"a", "b", "c", "d", "e", "f"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"b", "e", "f"});
        Assert.assertArrayEquals((Object[])new String[]{"b", "e", "f", "a", "c", "d"}, (Object[])suffixes);
    }

    public void testSortOrderAdditional() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"a", "b", "c", "d", "e", "f"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"first", "b", "second", "e", "third", "f"});
        Assert.assertArrayEquals((Object[])new String[]{"b", "e", "f", "a", "c", "d"}, (Object[])suffixes);
    }

    public void testSortOrderDuplicate() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"a", "b", "c", "d", "e", "f"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"a", "b", "a"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d", "e", "f"}, (Object[])suffixes);
    }

    public void testSortOrderStop() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"a", "b", "c", "d", "e", "f"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"a", "!"});
        Assert.assertArrayEquals((Object[])new String[]{"a"}, (Object[])suffixes);
    }

    public void testSortOrderStopEmpty() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        Object[] suffixes = new String[]{"a", "b", "c", "d", "e", "f"};
        suffixes = repositoryManager.sortSuffixes((String[])suffixes, new URI("http://foo"), new String[]{"!"});
        Assert.assertArrayEquals((Object[])new String[0], (Object[])suffixes);
    }

    public void testNoIndex() throws Exception {
        LocationProperties locationProperties = LocationProperties.create(null);
        SiteIndexFileTest.assertNotNull((Object)locationProperties);
        SiteIndexFileTest.assertFalse((boolean)locationProperties.exists());
    }

    public void testBadIndex1() throws Exception {
        File indexFile = TestData.getFile("metadataRepo/indexfiles", "badIndex.p2");
        InputStream inputStream = Files.newInputStream(indexFile.toPath(), new OpenOption[0]);
        PrintStream out = System.out;
        LocationProperties locationProperties = null;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            locationProperties = LocationProperties.create((InputStream)inputStream);
        }
        finally {
            System.setOut(out);
        }
        SiteIndexFileTest.assertNotNull((Object)locationProperties);
        SiteIndexFileTest.assertFalse((boolean)locationProperties.exists());
    }

    public void testBadIndex2() throws Exception {
        File indexFile = TestData.getFile("metadataRepo/indexfiles", "badIndex2.p2");
        InputStream inputStream = Files.newInputStream(indexFile.toPath(), new OpenOption[0]);
        LocationProperties locationProperties = LocationProperties.create((InputStream)inputStream);
        SiteIndexFileTest.assertNotNull((Object)locationProperties);
        SiteIndexFileTest.assertFalse((boolean)locationProperties.exists());
    }

    public void testSimpleIndexV1() throws Exception {
        File indexFile = TestData.getFile("metadataRepo/indexfiles", "simpleIndexV1.p2");
        InputStream inputStream = Files.newInputStream(indexFile.toPath(), new OpenOption[0]);
        LocationProperties locationProperties = LocationProperties.create((InputStream)inputStream);
        SiteIndexFileTest.assertNotNull((String)"1.0", (Object)locationProperties);
        SiteIndexFileTest.assertEquals((String)"1.1", (Object)Version.createOSGi((int)1, (int)0, (int)0), (Object)locationProperties.getVersion());
        SiteIndexFileTest.assertEquals((String)"1.2", (int)0, (int)locationProperties.getMetadataFactorySearchOrder().length);
    }

    public void testSimpleIndex2V1() throws Exception {
        File indexFile = TestData.getFile("metadataRepo/indexfiles", "simpleIndex2_V1.p2");
        InputStream inputStream = Files.newInputStream(indexFile.toPath(), new OpenOption[0]);
        LocationProperties locationProperties = LocationProperties.create((InputStream)inputStream);
        SiteIndexFileTest.assertNotNull((String)"1.0", (Object)locationProperties);
        SiteIndexFileTest.assertEquals((String)"1.1", (Object)Version.createOSGi((int)1, (int)0, (int)0), (Object)locationProperties.getVersion());
        SiteIndexFileTest.assertEquals((String)"1.2", (int)0, (int)locationProperties.getMetadataFactorySearchOrder().length);
    }

    public void testSimpleIndex3V1() throws Exception {
        File indexFile = TestData.getFile("metadataRepo/indexfiles", "simpleIndex3_V1.p2");
        InputStream inputStream = Files.newInputStream(indexFile.toPath(), new OpenOption[0]);
        LocationProperties locationProperties = LocationProperties.create((InputStream)inputStream);
        SiteIndexFileTest.assertNotNull((String)"1.0", (Object)locationProperties);
        SiteIndexFileTest.assertEquals((String)"1.1", (Object)Version.createOSGi((int)1, (int)0, (int)0), (Object)locationProperties.getVersion());
        Assert.assertArrayEquals((Object[])new String[]{"bar", "foo", "!"}, (Object[])locationProperties.getMetadataFactorySearchOrder());
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar", "!"}, (Object[])locationProperties.getArtifactFactorySearchOrder());
    }

    public void testSingleRepository1() throws Exception {
        URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test1").toURI();
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            MatcherAssert.assertThat((Object)repository, (Matcher)new IsInstanceOf(UpdateSiteMetadataRepository.class));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testSingleRepositoryWithQueryParams() throws Exception {
        URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test1").toURI();
        URI repositoryLocationWithParams = new URI(repositoryLocation.toString() + "?parameter=foo");
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocationWithParams, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testSingleRepository2() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test2").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof LocalMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testBadIndexFileInRepository() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "badtest1").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((repository instanceof LocalMetadataRepository || repository instanceof UpdateSiteMetadataRepository ? 1 : 0) != 0);
        }
        finally {
            System.setOut(out);
        }
    }

    public void testMultiRepository1() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test3").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testMultiRepository2() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test4").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testDuplicateEntries() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test5").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testStop1() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "stop1").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testStop2() throws Exception {
        URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "stop2").toURI();
        try {
            SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            return;
        }
        SiteIndexFileTest.fail((String)"We should have not been able to load the repository.");
    }

    public void testCompositeRepo() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "compositeRepo").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((String)"1.0", (boolean)(repository instanceof CompositeMetadataRepository));
            CompositeMetadataRepository compositeMetadataRepository = (CompositeMetadataRepository)repository;
            SiteIndexFileTest.assertEquals((String)"1.1", (int)2, (int)compositeMetadataRepository.getChildren().size());
            IMetadataRepository child1 = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository((URI)compositeMetadataRepository.getChildren().get(0), (IProgressMonitor)new NullProgressMonitor());
            IMetadataRepository child2 = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository((URI)compositeMetadataRepository.getChildren().get(1), (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((String)"1.2", (boolean)(child1 instanceof UpdateSiteMetadataRepository));
            SiteIndexFileTest.assertTrue((String)"1.2", (boolean)(child2 instanceof LocalMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testSimpleArtifact() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "artifactTest1").toURI();
            IArtifactRepository repository = SiteIndexFileTest.getArtifactRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof SimpleArtifactRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testSimpleArtifact2() throws Exception {
        URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "artifactTest2").toURI();
        try {
            SiteIndexFileTest.getArtifactRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            return;
        }
        SiteIndexFileTest.fail((String)"We should have not been able to load the repository.");
    }

    public void testFullRepository() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "fullRepository").toURI();
            IMetadataRepository metadataRepository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            IArtifactRepository artifactRepository = SiteIndexFileTest.getArtifactRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(metadataRepository instanceof UpdateSiteMetadataRepository));
            SiteIndexFileTest.assertTrue((boolean)(artifactRepository instanceof SimpleArtifactRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    class VisibleMetadataRepositoryManager
    extends MetadataRepositoryManager {
        public VisibleMetadataRepositoryManager() {
            super((IProvisioningAgent)ServiceHelper.getService((BundleContext)TestActivator.getContext(), IProvisioningAgent.class));
        }

        public String[] sortSuffixes(String[] suffixes, URI location, String[] preferredOrder) {
            return super.sortSuffixes(suffixes, location, preferredOrder);
        }
    }
}

