/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.io.IUDeserializer;
import org.eclipse.equinox.p2.metadata.io.IUSerializer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StandaloneSerializationTest {
    @Rule
    public TestName name = new TestName();

    @Test
    public void testNothingToWrite() throws IOException {
        File f = File.createTempFile(this.name.getMethodName(), "iu");
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream os = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            new IUSerializer(os).write(Collections.emptyList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((f.length() > 0L ? 1 : 0) != 0);
        f.delete();
    }

    @Test
    public void testNoContent() throws IOException {
        File f = File.createTempFile(this.name.getMethodName(), "iu");
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (OutputStream os = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            new IUSerializer(os).write(Collections.emptyList());
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        boolean exceptionRaised = false;
        try {
            throwable2 = null;
            Object var4_10 = null;
            try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                Collection ius = new IUDeserializer().read(is);
                Assert.assertEquals((long)0L, (long)ius.size());
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            Assert.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (IOException e) {
            exceptionRaised = true;
        }
        Assert.assertTrue((boolean)exceptionRaised);
        f.delete();
    }

    @Test
    public void testWritingThenLoading() throws FileNotFoundException, IOException {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("foo");
        iu.setVersion(Version.create((String)"1.0.0"));
        MetadataFactory.InstallableUnitDescription iu2 = new MetadataFactory.InstallableUnitDescription();
        iu2.setId("bar");
        iu2.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        ius.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu));
        ius.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu2));
        File f = File.createTempFile(this.name.getMethodName(), "iu");
        Throwable throwable = null;
        Object var6_8 = null;
        try (OutputStream os = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            new IUSerializer(os).write(ius);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        try {
            throwable = null;
            var6_8 = null;
            try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                Assert.assertEquals((long)2L, (long)new IUDeserializer().read(is).size());
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            f.delete();
        }
    }
}

