/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.junit.Test;

public class XZedRepositoryTest
extends AbstractProvisioningTest {
    @Test
    public void testLoadContentJarAndXZ() throws ProvisionException, OperationCanceledException {
        IMetadataRepository repo = XZedRepositoryTest.getMetadataRepositoryManager().loadRepository(XZedRepositoryTest.getTestData("xzedRepo", "testData/xzRepoTests/metadata/contentJarAndXZ").toURI(), null);
        IQueryResult units = repo.query(QueryUtil.createIUQuery((String)"testIU", (Version)Version.create((String)"2.0.0")), null);
        XZedRepositoryTest.assertEquals((int)1, (int)units.toSet().size());
    }

    @Test
    public void testLoadXzAndContentJar() throws ProvisionException, OperationCanceledException {
        IMetadataRepository repo = XZedRepositoryTest.getMetadataRepositoryManager().loadRepository(XZedRepositoryTest.getTestData("xzedRepo", "testData/xzRepoTests/metadata/xzAndContentJar").toURI(), null);
        IQueryResult units = repo.query(QueryUtil.createIUQuery((String)"iuFromXZ", (Version)Version.create((String)"2.0.0")), null);
        XZedRepositoryTest.assertEquals((int)1, (int)units.toSet().size());
    }

    @Test
    public void testLoadXzAndContentXML() throws ProvisionException, OperationCanceledException {
        IMetadataRepository repo = XZedRepositoryTest.getMetadataRepositoryManager().loadRepository(XZedRepositoryTest.getTestData("xzedRepo", "testData/xzRepoTests/metadata/xzAndContentXML").toURI(), null);
        IQueryResult units = repo.query(QueryUtil.createIUQuery((String)"iuFromXZ", (Version)Version.create((String)"2.0.0")), null);
        XZedRepositoryTest.assertEquals((int)1, (int)units.toSet().size());
    }

    @Test
    public void testLoadXzBusted() throws OperationCanceledException {
        boolean repoCanLoad = true;
        try {
            XZedRepositoryTest.getMetadataRepositoryManager().loadRepository(XZedRepositoryTest.getTestData("xzedRepo", "testData/xzRepoTests/metadata/xzBusted").toURI(), null);
        }
        catch (ProvisionException e) {
            repoCanLoad = false;
        }
        XZedRepositoryTest.assertFalse((boolean)repoCanLoad);
    }

    @Test
    public void testLoadXzOnly() throws ProvisionException, OperationCanceledException {
        IMetadataRepository repo = XZedRepositoryTest.getMetadataRepositoryManager().loadRepository(XZedRepositoryTest.getTestData("xzedRepo", "testData/xzRepoTests/metadata/xzOnly").toURI(), null);
        IQueryResult units = repo.query(QueryUtil.createIUQuery((String)"iuFromXZ", (Version)Version.create((String)"2.0.0")), null);
        XZedRepositoryTest.assertEquals((int)1, (int)units.toSet().size());
    }

    @Test
    public void testArtifactsJarAndXZ() throws ProvisionException, OperationCanceledException {
        IArtifactRepository repo = XZedRepositoryTest.getArtifactRepositoryManager().loadRepository(XZedRepositoryTest.getTestData("xzedRepo", "testData/xzRepoTests/artifacts/artifactsJarAndXZ").toURI(), null);
        IQueryResult units = repo.query((IQuery)new ArtifactKeyQuery("osgi.bundle", "aaPlugin", new VersionRange("[1.0.0, 1.0.0]")), null);
        XZedRepositoryTest.assertEquals((int)1, (int)units.toSet().size());
    }

    @Test
    public void testxzAndArtifactsJar() throws ProvisionException, OperationCanceledException {
        IArtifactRepository repo = XZedRepositoryTest.getArtifactRepositoryManager().loadRepository(XZedRepositoryTest.getTestData("xzedRepo", "testData/xzRepoTests/artifacts/xzAndArtifactsJar").toURI(), null);
        IQueryResult units = repo.query((IQuery)new ArtifactKeyQuery("osgi.bundle", "aaPluginFromXZ", new VersionRange("[1.0.0, 1.0.0]")), null);
        XZedRepositoryTest.assertEquals((int)1, (int)units.toSet().size());
    }

    @Test
    public void testxzAndArtifactsXML() throws ProvisionException, OperationCanceledException {
        IArtifactRepository repo = XZedRepositoryTest.getArtifactRepositoryManager().loadRepository(XZedRepositoryTest.getTestData("xzedRepo", "testData/xzRepoTests/artifacts/xzAndArtifactsXML").toURI(), null);
        IQueryResult units = repo.query((IQuery)new ArtifactKeyQuery("osgi.bundle", "aaPluginFromXZ", new VersionRange("[1.0.0, 1.0.0]")), null);
        XZedRepositoryTest.assertEquals((int)1, (int)units.toSet().size());
    }

    @Test
    public void testxzOnly() throws ProvisionException, OperationCanceledException {
        IArtifactRepository repo = XZedRepositoryTest.getArtifactRepositoryManager().loadRepository(XZedRepositoryTest.getTestData("xzedRepo", "testData/xzRepoTests/artifacts/xzOnly").toURI(), null);
        IQueryResult units = repo.query((IQuery)new ArtifactKeyQuery("osgi.bundle", "aaPluginFromXZ", new VersionRange("[1.0.0, 1.0.0]")), null);
        XZedRepositoryTest.assertEquals((int)1, (int)units.toSet().size());
    }

    @Test
    public void testLoadArtifactsXzBusted() throws OperationCanceledException {
        boolean repoCanLoad = true;
        try {
            XZedRepositoryTest.getMetadataRepositoryManager().loadRepository(XZedRepositoryTest.getTestData("xzedRepo", "testData/xzRepoTests/artifacts/xzBusted").toURI(), null);
        }
        catch (ProvisionException e) {
            repoCanLoad = false;
        }
        XZedRepositoryTest.assertFalse((boolean)repoCanLoad);
    }
}

