/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.mirror;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestAgentProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class MirrorApplicationTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public TestAgentProvider agentProvider = new TestAgentProvider();
    private File sourceRepoLocation;
    private File destRepoLocation;
    private MirrorApplication subject;

    @Before
    public void initRepositories() throws Exception {
        this.sourceRepoLocation = AbstractProvisioningTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space");
        this.destRepoLocation = this.tempFolder.newFolder("destRepo");
    }

    @Test
    public void testMirrorUnitWithArtifact() throws Exception {
        IInstallableUnit unit = this.getUnitFromSourceRepo("helloworld");
        this.subject = MirrorApplicationTest.createApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        this.subject.setSourceIUs(Arrays.asList(unit));
        MirrorApplicationTest.runApplication(this.subject);
        MatcherAssert.assertThat(this.artifactsIn(this.destRepoLocation), (Matcher)CoreMatchers.is(Collections.singleton("helloworld")));
    }

    @Test
    public void testMirrorUnitWithoutArtifacts() throws Exception {
        IInstallableUnit unitWithoutArtifact = this.getUnitFromSourceRepo("a.jre");
        MatcherAssert.assertThat((Object)unitWithoutArtifact.getArtifacts(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.any(IArtifactKey.class))));
        this.subject = MirrorApplicationTest.createApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        this.subject.setSourceIUs(Arrays.asList(unitWithoutArtifact));
        MirrorApplicationTest.runApplication(this.subject);
        MatcherAssert.assertThat(this.artifactsIn(this.destRepoLocation), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.any(String.class))));
    }

    private IInstallableUnit getUnitFromSourceRepo(String id) throws Exception {
        IMetadataRepository repository = this.agentProvider.getService(IMetadataRepositoryManager.class).loadRepository(this.sourceRepoLocation.toURI(), null);
        IQueryResult queryResult = repository.query(QueryUtil.createIUQuery((String)id), null);
        if (queryResult.isEmpty()) {
            throw new AssertionFailedError("No unit with ID '" + id + "' found in repository " + String.valueOf(this.sourceRepoLocation));
        }
        return (IInstallableUnit)queryResult.iterator().next();
    }

    private Set<String> artifactsIn(File repositoryLocation) throws Exception {
        IArtifactRepository repository = this.agentProvider.getService(IArtifactRepositoryManager.class).loadRepository(repositoryLocation.toURI(), null);
        return MirrorApplicationTest.artifactsIn(repository);
    }

    private static Set<String> artifactsIn(IArtifactRepository repository) {
        HashSet<String> result = new HashSet<String>();
        for (IArtifactKey artifactKey : repository.query(QueryUtil.createMatchQuery(IArtifactKey.class, (String)"true", (Object[])new Object[0]), null).toUnmodifiableSet()) {
            result.add(artifactKey.getId());
        }
        return result;
    }

    private static MirrorApplication createApplication(File sourceLocation, File destLocation, Boolean append) {
        MirrorApplication app = new MirrorApplication();
        if (destLocation != null) {
            RepositoryDescriptor dest = MirrorApplicationTest.createRepositoryDescriptor(destLocation.toURI(), append);
            app.addDestination(dest);
        }
        if (sourceLocation != null) {
            RepositoryDescriptor src = MirrorApplicationTest.createRepositoryDescriptor(sourceLocation.toURI(), null);
            app.addSource(src);
        }
        return app;
    }

    private static RepositoryDescriptor createRepositoryDescriptor(URI location, Boolean append) {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.setLocation(location);
        if (append != null) {
            descriptor.setAppend(append.booleanValue());
        }
        return descriptor;
    }

    private static StringBuilder runApplication(MirrorApplication app) throws ProvisionException {
        StringBuilder buffer = new StringBuilder();
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream(buffer)));
            app.run(null);
        }
        finally {
            System.setOut(out);
        }
        return buffer;
    }
}

