/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;
import org.junit.Assert;
import org.junit.Test;

public class CommonPatternsTest
extends VersionTesting {
    public static String TRIPLET_FORMAT_STRING = "n=0;[.n=0;[.n=0;]][dS=m;]";
    public static String MOZ_PREFIX = "format((<N=0;?s=m;?N=0;?s=m;?>(.<N=0;?s=m;?N=0;?s=m;?>)*)=p<0.m.0.m>;):";
    public static String TRIPLE_PREFIX = "format(" + TRIPLET_FORMAT_STRING + "):";
    public static String RPM_PREFIX = "format(<[n=0;:]a(d=[^a-zA-Z0-9@_-];?a)*>[-n[dS=!;]]):";
    public static String JSR277_PREFIX = "format(n(.n=0;){0,3}[-S=m;]):";

    @Test
    public void testMozillaPattern() {
        Version v1 = Version.parseVersion((String)(MOZ_PREFIX + "1.-1"));
        Version v2 = Version.parseVersion((String)(MOZ_PREFIX + "1"));
        Version v2a = Version.parseVersion((String)(MOZ_PREFIX + "1."));
        Version v2b = Version.parseVersion((String)(MOZ_PREFIX + "1.0"));
        Version v2c = Version.parseVersion((String)(MOZ_PREFIX + "1.0.0"));
        CommonPatternsTest.assertOrder(v1, v2);
        Assert.assertEquals((Object)v2, (Object)v2a);
        Assert.assertEquals((Object)v2a, (Object)v2b);
        Assert.assertEquals((Object)v2b, (Object)v2c);
        Version v3 = Version.parseVersion((String)(MOZ_PREFIX + "1.1a"));
        Version v4 = Version.parseVersion((String)(MOZ_PREFIX + "1.1aa"));
        Version v5 = Version.parseVersion((String)(MOZ_PREFIX + "1.1ab"));
        Version v6 = Version.parseVersion((String)(MOZ_PREFIX + "1.1b"));
        Version v7 = Version.parseVersion((String)(MOZ_PREFIX + "1.1c"));
        CommonPatternsTest.assertOrder(v2c, v3);
        CommonPatternsTest.assertOrder(v3, v4);
        CommonPatternsTest.assertOrder(v4, v5);
        CommonPatternsTest.assertOrder(v5, v6);
        CommonPatternsTest.assertOrder(v6, v7);
        Version v8 = Version.parseVersion((String)(MOZ_PREFIX + "1.1pre"));
        Version v8a = Version.parseVersion((String)(MOZ_PREFIX + "1.1pre0"));
        CommonPatternsTest.assertOrder(v7, v8);
        Assert.assertEquals((Object)v8, (Object)v8a);
        Version v9 = Version.parseVersion((String)(MOZ_PREFIX + "1.1pre1a"));
        Version v10 = Version.parseVersion((String)(MOZ_PREFIX + "1.1pre1aa"));
        Version v11 = Version.parseVersion((String)(MOZ_PREFIX + "1.1pre1b"));
        Version v12 = Version.parseVersion((String)(MOZ_PREFIX + "1.1pre1"));
        CommonPatternsTest.assertOrder(v8a, v9);
        CommonPatternsTest.assertOrder(v9, v10);
        CommonPatternsTest.assertOrder(v10, v11);
        CommonPatternsTest.assertOrder(v11, v12);
        Version v13 = Version.parseVersion((String)(MOZ_PREFIX + "1.1pre2"));
        CommonPatternsTest.assertOrder(v12, v13);
        Version v14 = Version.parseVersion((String)(MOZ_PREFIX + "1.1pre10"));
        CommonPatternsTest.assertOrder(v13, v14);
        Version v15 = Version.parseVersion((String)(MOZ_PREFIX + "1.1.-1"));
        CommonPatternsTest.assertOrder(v14, v15);
        Version v16 = Version.parseVersion((String)(MOZ_PREFIX + "1.1"));
        Version v16a = Version.parseVersion((String)(MOZ_PREFIX + "1.1.0"));
        Version v16b = Version.parseVersion((String)(MOZ_PREFIX + "1.1.00"));
        CommonPatternsTest.assertOrder(v15, v16);
        Assert.assertEquals((Object)v16, (Object)v16a);
        Assert.assertEquals((Object)v16a, (Object)v16b);
        Version v17 = Version.parseVersion((String)(MOZ_PREFIX + "1.10"));
        CommonPatternsTest.assertOrder(v16a, v17);
        Version v18 = Version.parseVersion((String)(MOZ_PREFIX + "2.0"));
        CommonPatternsTest.assertOrder(v17, v18);
    }

    @Test
    public void testMozillaPatternToString() {
        String test = MOZ_PREFIX + "1.1pre1aa";
        Assert.assertEquals((Object)MOZ_PREFIX, (Object)(Version.parseVersion((String)test).getFormat().toString() + ":"));
    }

    @Test
    public void testTripletPattern() {
        Version v1 = Version.parseVersion((String)(TRIPLE_PREFIX + "1"));
        Version v1a = Version.parseVersion((String)(TRIPLE_PREFIX + "1.0"));
        Version v1b = Version.parseVersion((String)(TRIPLE_PREFIX + "1.0.0"));
        Assert.assertEquals((Object)v1, (Object)v1a);
        Assert.assertEquals((Object)v1a, (Object)v1b);
        Version v2 = Version.parseVersion((String)(TRIPLE_PREFIX + "1.0.0.a"));
        CommonPatternsTest.assertOrder(v2, v1);
        Version v3 = Version.parseVersion((String)(TRIPLE_PREFIX + "1.1"));
        CommonPatternsTest.assertOrder(v1b, v3);
        Version v4 = Version.parseVersion((String)(TRIPLE_PREFIX + "1.1.0.a"));
        CommonPatternsTest.assertOrder(v4, v3);
        Version v5 = Version.parseVersion((String)(TRIPLE_PREFIX + "2"));
        CommonPatternsTest.assertOrder(v3, v5);
        Version v6 = Version.parseVersion((String)(TRIPLE_PREFIX + "1.1-FC1"));
        CommonPatternsTest.assertOrder(v6, v3);
    }

    @Test
    public void testTripletPatternToString() {
        String test = TRIPLE_PREFIX + "1.0-FC1";
        Assert.assertEquals((Object)TRIPLE_PREFIX, (Object)(Version.parseVersion((String)test).getFormat().toString() + ":"));
    }

    @Test
    public void testTripletPatternToOSGi() throws Exception {
        IVersionFormat triplet = Version.compile((String)TRIPLET_FORMAT_STRING);
        Assert.assertEquals((Object)Version.createOSGi((int)1, (int)0, (int)0), (Object)triplet.parse("1.0.0.-"));
        Assert.assertEquals((Object)Version.create((String)"1.0.0.zzz"), (Object)triplet.parse("1.0.0"));
        Assert.assertEquals((Object)Version.createOSGi((int)1, (int)0, (int)0, (String)"zzz"), (Object)Version.create((String)"raw:1.0.0.m"));
        Assert.assertEquals((Object)triplet.parse("1.0"), (Object)Version.create((String)"raw:1.0.0.m"));
        Assert.assertEquals((Object)triplet.parse("1.0.-"), (Object)Version.create((String)"raw:1.0.0.''"));
        Assert.assertEquals((Object)Version.createOSGi((int)1, (int)0, (int)0), (Object)Version.create((String)"raw:1.0.0.''"));
    }

    @Test
    public void testMinTranslation() throws Exception {
        IVersionFormat format = Version.compile((String)"n=0;[.n=0;[.n=0;]][dS=m{!};]");
        Assert.assertEquals((Object)Version.create((String)"raw:1.0.0.''"), (Object)format.parse("1.0.0.!"));
    }

    @Test
    public void testMaxTranslation() throws Exception {
        IVersionFormat format = Version.compile((String)"n=0;[.n=0;[.n=0;]][dS=''{~,4};]");
        Assert.assertEquals((Object)Version.create((String)"raw:1.0.0.m"), (Object)format.parse("1.0.0.~~~~"));
    }

    @Test
    public void testRPMPattern() {
        Version v1 = Version.parseVersion((String)(RPM_PREFIX + "33:1.2.3a-23/i386"));
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:<33.1.2.3.'a'>.23"), (Object)v1);
        Version v2 = Version.parseVersion((String)(RPM_PREFIX + "34:1"));
        CommonPatternsTest.assertOrder(v1, v2);
        Version v3 = Version.parseVersion((String)(RPM_PREFIX + "33:1.2.3b"));
        CommonPatternsTest.assertOrder(v1, v3);
        Version v11 = Version.parseVersion((String)(RPM_PREFIX + "1-1"));
        Version v12 = Version.parseVersion((String)(RPM_PREFIX + "1-2"));
        Version v13 = Version.parseVersion((String)(RPM_PREFIX + "1.0"));
        Version v14 = Version.parseVersion((String)(RPM_PREFIX + "1.1"));
        CommonPatternsTest.assertOrder(v11, v12);
        CommonPatternsTest.assertOrder(v12, v13);
        CommonPatternsTest.assertOrder(v11, v13);
        CommonPatternsTest.assertOrder(v12, v13);
        CommonPatternsTest.assertOrder(v11, v14);
        CommonPatternsTest.assertOrder(v12, v14);
        CommonPatternsTest.assertOrder(v13, v14);
    }

    @Test
    public void testRPMPatternToString() {
        String test = RPM_PREFIX + "33:1.2.3a-23/i386";
        Assert.assertEquals((Object)RPM_PREFIX, (Object)(Version.parseVersion((String)test).getFormat().toString() + ":"));
    }

    @Test
    public void testJsr277Pattern() {
        Version v1 = Version.parseVersion((String)(JSR277_PREFIX + "1"));
        Version v1a = Version.parseVersion((String)(JSR277_PREFIX + "1.0"));
        Version v1b = Version.parseVersion((String)(JSR277_PREFIX + "1.0.0"));
        Version v1c = Version.parseVersion((String)(JSR277_PREFIX + "1.0.0.0"));
        Assert.assertEquals((Object)v1, (Object)v1a);
        Assert.assertEquals((Object)v1a, (Object)v1b);
        Assert.assertEquals((Object)v1b, (Object)v1c);
        Version v2 = Version.parseVersion((String)(JSR277_PREFIX + "1-a"));
        Version v2a = Version.parseVersion((String)(JSR277_PREFIX + "1.0-a"));
        Version v2b = Version.parseVersion((String)(JSR277_PREFIX + "1.0.0-a"));
        Version v2c = Version.parseVersion((String)(JSR277_PREFIX + "1.0.0.0-a"));
        CommonPatternsTest.assertOrder(v2, v1);
        Assert.assertEquals((Object)v2, (Object)v2a);
        Assert.assertEquals((Object)v2a, (Object)v2b);
        Assert.assertEquals((Object)v2b, (Object)v2c);
        Version v3 = Version.parseVersion((String)(JSR277_PREFIX + "1.1"));
        CommonPatternsTest.assertOrder(v1b, v3);
        Version v4 = Version.parseVersion((String)(JSR277_PREFIX + "1.1.0-a"));
        CommonPatternsTest.assertOrder(v4, v3);
        Version v5 = Version.parseVersion((String)(JSR277_PREFIX + "2"));
        CommonPatternsTest.assertOrder(v3, v5);
    }

    @Test
    public void testJsr277PatternToString() {
        String test = JSR277_PREFIX + "1.0.0.0-a";
        Assert.assertEquals((Object)JSR277_PREFIX, (Object)(Version.parseVersion((String)test).getFormat().toString() + ":"));
    }
}

