/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionFormatException;
import org.junit.Assert;
import org.junit.Test;

public class FormatATest {
    @Test
    public void testNumeric() {
        Version v = Version.parseVersion((String)"format(a):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
    }

    @Test
    public void testString() {
        Version v = Version.parseVersion((String)"format(a):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
    }

    @Test
    public void testSequenceOfAuto() {
        Version v = Version.parseVersion((String)"format(aaaa):123abc456def");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:123.'abc'.456.'def'"), (Object)v);
    }

    @Test
    public void testExact() {
        Version v = Version.parseVersion((String)"format(a={3};aaa={3};):123abc456def");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:123.'abc'.456.'def'"), (Object)v);
        v = Version.parseVersion((String)"format(a={2};a):abc");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'ab'.'c'"), (Object)v);
        v = Version.parseVersion((String)"format(a={2};a):123");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:12.3"), (Object)v);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(a={4};aaa={3};):12.3abc456def");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(a={4};aaa={3};):123abc456def");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(a={4};aaa={3};):xyz123abc456");
        });
    }

    @Test
    public void testAtLeast() {
        Version v = Version.parseVersion((String)"format(a={2,};aaa={2,};):123abc456def");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:123.'abc'.456.'def'"), (Object)v);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(a={2,};aaa={2,};):1abc456def");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(a={2,};aaa={2,};):12abc456d");
        });
    }

    @Test
    public void testAtMost() {
        Version v = Version.parseVersion((String)"format(a={1,3};aaa={1,3};):123abc456def");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:123.'abc'.456.'def'"), (Object)v);
        v = Version.parseVersion((String)"format(a={1,2};aaaa={1,2};a):123abc456def");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:12.3.'abc'.456.'de'.'f'"), (Object)v);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(a={2,3};aaa={1,2};):1abc456def");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(a={2,3};aaa={2,3};):12abc456d");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(a={4,5};aaa={1,4};):123abc456def");
        });
    }

    @Test
    public void testEnum() {
        Version v1 = Version.parseVersion((String)"format(aa={alpha,beta,gamma};a):12beta2");
        Version v2 = Version.parseVersion((String)"raw:12.{alpha,^beta,gamma}.2");
        Assert.assertEquals((Object)v1, (Object)v2);
    }

    @Test
    public void testEnumOptional() {
        Version v1 = Version.parseVersion((String)"format(aa={alpha,beta,gamma}?;a):12foo2");
        Version v2 = Version.parseVersion((String)"raw:12.'foo'.2");
        Assert.assertEquals((Object)v1, (Object)v2);
        Assert.assertThrows((String)"bad enum was not detected", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(aa={alpha,beta,gamma};a):12foo2");
        });
    }

    @Test
    public void testEnumIgnoreCase() {
        Version v1 = Version.parseVersion((String)"format(aa={Alpha,Beta,Gamma}i;a):12beta2");
        Version v2 = Version.parseVersion((String)"raw:12.{alpha,^beta,gamma}.2");
        Assert.assertEquals((Object)v1, (Object)v2);
        v1 = Version.parseVersion((String)"format(aa={alpha,beta,gamma}i;a):12BETA2");
        v2 = Version.parseVersion((String)"raw:12.{alpha,^beta,gamma}.2");
        Assert.assertEquals((Object)v1, (Object)v2);
        Assert.assertThrows((String)"enum case sensitivity ignored", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(aa={alpha,beta,gamma};a):12BETA2");
        });
    }

    @Test
    public void testEnumBegins() {
        Version v1 = Version.parseVersion((String)"format(aa={alpha,beta,gamma}b;aa):12gammafoo2");
        Version v2 = Version.parseVersion((String)"raw:12.{alpha,beta,^gamma}.'foo'.2");
        Assert.assertEquals((Object)v1, (Object)v2);
        v1 = Version.parseVersion((String)"format(aa={alpha,beta,gamma}?;a):12gammafoo2");
        v2 = Version.parseVersion((String)"raw:12.'gammafoo'.2");
        Assert.assertEquals((Object)v1, (Object)v2);
        v1 = Version.parseVersion((String)"format(aa={alpha,beta,gamma}b?;aa):12gammafoo2");
        v2 = Version.parseVersion((String)"raw:12.{alpha,beta,^gamma}.'foo'.2");
        Assert.assertEquals((Object)v1, (Object)v2);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(aa={alpha,beta,gamma};a):12gammafoo2");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(aa={#,$,%}?;aa?):12#foo2");
        });
        v1 = Version.parseVersion((String)"format(aa={#,$,%}b;aa):12#foo2");
        v2 = Version.parseVersion((String)"raw:12.{^#,$,%}.'foo'.2");
        Assert.assertEquals((Object)v1, (Object)v2);
    }

    @Test
    public void testEnumFormatToString() {
        Version v1 = Version.parseVersion((String)"format(aa={alpha,beta,gamma};a):12beta2");
        Assert.assertEquals((Object)v1.toString(), (Object)"raw:12.{alpha,^beta,gamma}.2/format(aa={alpha,beta,gamma};a):12beta2");
    }

    @Test
    public void testPHPVersion() {
        IVersionFormat phpFormat = null;
        try {
            phpFormat = Version.compile((String)"n(d=[_+.-];?a={dev,alpha=a,beta=b,RC=rc,#,pl=p}?;)*");
        }
        catch (VersionFormatException e) {
            Assert.fail((String)e.getMessage());
        }
        Version v1 = phpFormat.parse("1.2.3");
        Version v2 = Version.parseVersion((String)"raw:1.2.3");
        Assert.assertEquals((Object)v1, (Object)v2);
        v1 = phpFormat.parse("1.2.alpha2");
        v2 = phpFormat.parse("1.2.a2");
        Assert.assertEquals((Object)v1, (Object)v2);
        v1 = phpFormat.parse("1.2.beta3");
        v2 = phpFormat.parse("1.2.#2");
        Assert.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        v1 = Version.parseVersion((String)"raw:1.2.{dev,a,b,RC,^#,p}.2");
        Assert.assertEquals((Object)v1, (Object)v2);
        v1 = Version.parseVersion((String)"raw:1.2.{dev,a,b,^rc,#,p}.2");
        Assert.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        v1 = Version.parseVersion((String)"raw:1.2.{dev,a,b,rc,#,^p}.2");
        Assert.assertTrue((v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
    }
}

