/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Assert;
import org.junit.Test;

public class FormatArrayTest {
    @Test
    public void testEmptyArray() {
        Assert.assertThrows((String)"Uncaught error: empty array group is not allowed:", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(<>q):''");
        });
    }

    @Test
    public void testEmptyArrayBecauseContentIsOptional() {
        Assert.assertThrows((String)"Uncaught error: produces an empty vector", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(<n?>q):''");
        });
    }

    @Test
    public void testOptionalArray() {
        Version v = Version.parseVersion((String)"format(<n>?S):abc");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'abc'"), (Object)v);
        v = Version.parseVersion((String)"format(<n>?S):1abc");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:<1>.'abc'"), (Object)v);
    }

    @Test
    public void testNumericArray() {
        Version v = Version.parseVersion((String)"format(<(n.?)+>):1.2.3.4.5.6.7.8.9");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:<1.2.3.4.5.6.7.8.9>"), (Object)v);
    }

    @Test
    public void testStringArray() {
        Version v = Version.parseVersion((String)"format(<(S=[^.];d?)+>):a.b.c.d.e.f.g.h.i");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:<'a'.'b'.'c'.'d'.'e'.'f'.'g'.'h'.'i'>"), (Object)v);
    }

    @Test
    public void testNestedArray() {
        Version v = Version.parseVersion((String)"format(<n.<n.n>.n>):1.2.3.4");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:<1.<2.3>.4>"), (Object)v);
        v = Version.parseVersion((String)"format(<n.<n.<n>>.n>):1.2.3.4");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:<1.<2.<3>>.4>"), (Object)v);
    }
}

