/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Assert;
import org.junit.Test;

public class FormatDTest {
    private static char[] s_delim = new char[]{' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_', '{', '|', '}', '~'};

    @Test
    public void testNumericWithDefaultSet() {
        Version v = null;
        String formatString = "format(ndn):";
        Integer one = 1;
        Integer two = 2;
        char[] cArray = s_delim;
        int n = s_delim.length;
        int n2 = 0;
        while (n2 < n) {
            char delim = cArray[n2];
            StringBuilder buf = new StringBuilder();
            buf.append(formatString);
            buf.append("1");
            buf.append(delim);
            buf.append("2");
            v = Version.parseVersion((String)buf.toString());
            Assert.assertNotNull((Object)v);
            Assert.assertEquals((Object)one, (Object)v.getSegment(0));
            Assert.assertEquals((Object)two, (Object)v.getSegment(1));
            ++n2;
        }
    }

    @Test
    public void testStringWithDefaultSet() {
        Version v = null;
        String formatString = "format(sds):";
        String one = "abc";
        String two = "def";
        char[] cArray = s_delim;
        int n = s_delim.length;
        int n2 = 0;
        while (n2 < n) {
            char delim = cArray[n2];
            StringBuilder buf = new StringBuilder();
            buf.append(formatString);
            buf.append(one);
            buf.append(delim);
            buf.append(two);
            v = Version.parseVersion((String)buf.toString());
            Assert.assertNotNull((Object)v);
            Assert.assertEquals((Object)one, (Object)v.getSegment(0));
            Assert.assertEquals((Object)two, (Object)v.getSegment(1));
            ++n2;
        }
    }

    @Test
    public void testAccepted() {
        Version v = Version.parseVersion((String)"format((d=[A-Z];n){3}):A1B22C333");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)1, (Object)v.getSegment(0));
        Assert.assertEquals((Object)22, (Object)v.getSegment(1));
        Assert.assertEquals((Object)333, (Object)v.getSegment(2));
        v = Version.parseVersion((String)"format((d=[ABZ];S=[^ABZ];){3}):Aa1Bb22Zc333");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"a1", (Object)v.getSegment(0));
        Assert.assertEquals((Object)"b22", (Object)v.getSegment(1));
        Assert.assertEquals((Object)"c333", (Object)v.getSegment(2));
        v = Version.parseVersion((String)"format((d=[A-Za-z];+n)+):Aa1Bb22Zc333");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)1, (Object)v.getSegment(0));
        Assert.assertEquals((Object)22, (Object)v.getSegment(1));
        Assert.assertEquals((Object)333, (Object)v.getSegment(2));
        v = Version.parseVersion((String)"format((d=[\\\\[\\]];n)+):[1\\22]333");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)1, (Object)v.getSegment(0));
        Assert.assertEquals((Object)22, (Object)v.getSegment(1));
        Assert.assertEquals((Object)333, (Object)v.getSegment(2));
    }

    @Test
    public void testRejected() {
        Version v = null;
        v = Version.parseVersion((String)"format((d=[^.:];S=[a-z0-9];){3}):/a1;b22=c333");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"a1", (Object)v.getSegment(0));
        Assert.assertEquals((Object)"b22", (Object)v.getSegment(1));
        Assert.assertEquals((Object)"c333", (Object)v.getSegment(2));
    }

    @Test
    public void testExplicit() {
        Version v = null;
        v = Version.parseVersion((String)"format('epoch='n';''major='n';''minor='n';'):epoch=1;major=22;minor=333;");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)1, (Object)v.getSegment(0));
        Assert.assertEquals((Object)22, (Object)v.getSegment(1));
        Assert.assertEquals((Object)333, (Object)v.getSegment(2));
        v = Version.parseVersion((String)"format('epoch='S=[^.];d'major='S=[^.];d'minor='S):epoch=a1ma.major=b22mi.minor=c333");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"a1ma", (Object)v.getSegment(0));
        Assert.assertEquals((Object)"b22mi", (Object)v.getSegment(1));
        Assert.assertEquals((Object)"c333", (Object)v.getSegment(2));
    }

    @Test
    public void testCounted() {
        Version v1 = Version.parseVersion((String)"format(dddn):///1");
        Version v2 = Version.parseVersion((String)"format(d{3}n):///1");
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Integer one = 1;
        Assert.assertEquals((Object)one, (Object)v1.getSegment(0));
        Assert.assertEquals((Object)one, (Object)v2.getSegment(0));
    }

    @Test
    public void testIllegalCharCount() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(d={3};n):///1");
        });
    }

    @Test
    public void testIllegalAsPad() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(nd=pm;n):1.0");
        });
    }

    @Test
    public void testIllegalWithDefault() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(nd='a';n):1.0");
        });
    }

    @Test
    public void testIllegalIgnore() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(nd=!;n):1.0");
        });
    }
}

