/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Assert;
import org.junit.Test;

public class FormatNTest {
    @Test
    public void testNonNegative() {
        Version v = Version.parseVersion((String)"format(n):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(n):0");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:0"), (Object)v);
        Assert.assertThrows((String)"negative number in 'n' format", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n):-1");
        });
    }

    @Test
    public void testNegativeValues() {
        Version v = Version.parseVersion((String)"format(N):-1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:-1"), (Object)v);
        v = Version.parseVersion((String)"format(N):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(N):0");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:0"), (Object)v);
    }

    @Test
    public void testLeadingZeros() {
        Version v = Version.parseVersion((String)"format(n):000001");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(N):-000001");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:-1"), (Object)v);
    }

    @Test
    public void testExact() {
        Version v = Version.parseVersion((String)"format(n={2};n={2};):1122");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:11.22"), (Object)v);
        v = Version.parseVersion((String)"format(N={4};N={1};):-1234");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:-123.4"), (Object)v);
        v = Version.parseVersion((String)"format(N={4};N={3};):-001234");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:-1.234"), (Object)v);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n={2};.;n={2};):1.2");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n={2};.;n={2};):111.2222");
        });
    }

    @Test
    public void testAtLeast() {
        Version v = Version.parseVersion((String)"format(n={2,};.n={2,};):111.22222");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:111.22222"), (Object)v);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n={2,};.;n={2};):111.2");
        });
    }

    @Test
    public void testAtMost() {
        Version v = Version.parseVersion((String)"format(n={2,3};.n={2,3};):111.22");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:111.22"), (Object)v);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n={2,3};.n={2,3};):111.2222");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n={2,3};.n={2,3};):1.222");
        });
    }

    @Test
    public void testNIsGreedy() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(nn):1010");
        });
    }
}

