/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Assert;
import org.junit.Test;

public class FormatProcessingTest {
    @Test
    public void testIgnore() {
        Version v = Version.parseVersion((String)"format(n=!;.n.n):100.1.2");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)1, (Object)v.getSegment(0));
        Assert.assertEquals((Object)2, (Object)v.getSegment(1));
    }

    @Test
    public void testDefaultArrayWithPad() {
        Version v = Version.parseVersion((String)"format(s.?<n.n>=<1.0pm>;=p10;?):alpha");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'alpha'.<1.0pm>"), (Object)v);
        v = Version.parseVersion((String)"format(s.?<n.n>=<1.0pm>;=p10;?):alpha.1.2");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'alpha'.<1.2p10>"), (Object)v);
    }

    @Test
    public void testDefaultValues() {
        Version v = Version.parseVersion((String)"format(n.[n=1;].?[s='foo';].?[a='bar';].?[a=2;]):9.");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:9.1.'foo'.'bar'.2"), (Object)v);
    }

    @Test
    public void testArrayDefaultValues() {
        Version v = null;
        v = Version.parseVersion((String)"format(n.<n.n>=<1.0>;?):9.");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:9.<1.0>"), (Object)v);
        v = Version.parseVersion((String)"format(n.<n=3;?.?n=4;?>=<1.0>;?):9.");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"individual defaults should be used", (Object)Version.parseVersion((String)"raw:9.<3.4>"), (Object)v);
        v = Version.parseVersion((String)"format(n.<n=3;?.n=4;?>=<1.0>;?):9.");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"individual defaults should not be used", (Object)Version.parseVersion((String)"raw:9.<1.0>"), (Object)v);
    }

    @Test
    public void testOtherTypeAsDefault() {
        Version v = null;
        v = Version.parseVersion((String)"format(s=123;?n):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#1.1", (Object)Version.parseVersion((String)"raw:123.1"), (Object)v);
        v = Version.parseVersion((String)"format(s=M;?n):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#1.2", (Object)Version.parseVersion((String)"raw:M.1"), (Object)v);
        v = Version.parseVersion((String)"format(s=-M;?n):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#1.3", (Object)Version.parseVersion((String)"raw:-M.1"), (Object)v);
        v = Version.parseVersion((String)"format(s=<1.2>;?n):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#1.4", (Object)Version.parseVersion((String)"raw:<1.2>.1"), (Object)v);
        v = Version.parseVersion((String)"format(n='abc';?s):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#2.1", (Object)Version.parseVersion((String)"raw:'abc'.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(n=M;?s):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#2.2", (Object)Version.parseVersion((String)"raw:M.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(n=-M;?s):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#2.3", (Object)Version.parseVersion((String)"raw:-M.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(n=<'a'.'b'>;?n):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#2.4", (Object)Version.parseVersion((String)"raw:<'a'.'b'>.1"), (Object)v);
        v = Version.parseVersion((String)"format(<n>='abc';?s):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#3.1", (Object)Version.parseVersion((String)"raw:'abc'.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(<n>=M;?s):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#3.2", (Object)Version.parseVersion((String)"raw:M.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(<n>=-M;?s):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#3.3", (Object)Version.parseVersion((String)"raw:-M.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(<n>=123;?s):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)"#3.4", (Object)Version.parseVersion((String)"raw:123.'a'"), (Object)v);
    }

    @Test
    public void testSameMoreThanOnce() {
        Assert.assertThrows((String)"error detected:2 x =!;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n=!;=!;.n):1.2");
        });
        Assert.assertThrows((String)"error detected:2 x =[];", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(s=[abc];=[123];.n):abc123.2");
        });
        Assert.assertThrows((String)"error detected:2x [^];", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(nd=[^:];=[^:];n):1.2");
        });
        Assert.assertThrows((String)"error detected:2x ={ };", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n={1,3};={1,3};.n):1.2");
        });
        Assert.assertThrows((String)"error detected:2x =default value", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n=0;=1;.n):1.2");
        });
        Assert.assertThrows((String)"error detected:2x =pm;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((n.n)=pm;=pm;):1.2");
        });
    }

    @Test
    public void testSetNotSet() {
        Assert.assertThrows((String)"error detected: =[];=[^];", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(nd=[a-z];=[^.:];n):1.2");
        });
    }

    @Test
    public void testBadPadCombinations() {
        Assert.assertThrows((String)"error detected: =p; =[];", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((n.n)=pm;=[abc];):1.2");
        });
        Assert.assertThrows((String)"error detected: =p; =[];", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((n.n)=pm;=[^.:];):1.2");
        });
        Assert.assertThrows((String)"error detected: =p; ={};", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((n.n)=pm;={1,3};):1.2");
        });
        Assert.assertThrows((String)"error detected: =p; =!;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((n.n)=pm;=!;):1.2");
        });
    }

    @Test
    public void testNonPaddable() {
        Assert.assertThrows((String)"error detected: n=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n=pm;):1");
        });
        Assert.assertThrows((String)"error detected: n=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(N=pm;):1");
        });
        Assert.assertThrows((String)"error detected: s=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(s=pm;):a");
        });
        Assert.assertThrows((String)"error detected: S=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(S=pm;):a");
        });
        Assert.assertThrows((String)"error detected: a=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(a=pm;):a");
        });
        Assert.assertThrows((String)"error detected: d=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(d=pm;):a");
        });
        Assert.assertThrows((String)"error detected: q=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q=pm;):a");
        });
        Assert.assertThrows((String)"error detected: q=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(r=pm;):a");
        });
        Assert.assertThrows((String)"error detected: 'x'=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format('x'=pm;n):x1");
        });
        Assert.assertThrows((String)"error detected: .=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(.=pm;n):x1");
        });
        Assert.assertThrows((String)"error detected: p=p;", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(p=pm;n):x1");
        });
    }
}

